/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;

public class DesignHandler {
    private Design sourceDesign;
    private Design targetDesign;
    private Map map = new TreeMap();
    private boolean logicalIsSelected = false;
    private List newRelationals = new ArrayList();
    private List subViews = new ArrayList();
    private List modelsToDeleteOnCancel = new ArrayList();

    public DesignHandler(Design sourceDesign, Design targetDesign) {
        this.sourceDesign = sourceDesign;
        this.targetDesign = targetDesign;
    }

    public String getSourceName() {
        return this.sourceDesign.getName();
    }

    public String getTargetName() {
        return this.targetDesign.getName();
    }

    public void addRelationalModelMap(RelationalDesign source, RelationalDesign target) {
        this.map.put(source.getObjectID(), target.getObjectID());
    }

    public List getSourceRelationalModels() {
        return Arrays.asList(this.map.keySet().toArray());
    }

    public List getTargetRelationalModels() {
        return Arrays.asList(this.map.values().toArray());
    }

    public String getTargetRelationalModelID(String sourceID) {
        return (String)this.map.get(sourceID);
    }

    public Design getSourceDesign() {
        return this.sourceDesign;
    }

    public DataTypesDesign getSourceDataTypesDesign() {
        return this.sourceDesign.getDataTypesDesign();
    }

    public LogicalDesign getSourceLogicalDesign() {
        return this.sourceDesign.getLogicalDesign();
    }

    public Design getTargetDesign() {
        return this.targetDesign;
    }

    public DataTypesDesign getTargetDataTypesDesign() {
        return this.targetDesign.getDataTypesDesign();
    }

    public LogicalDesign getTargetLogicalDesign() {
        return this.targetDesign.getLogicalDesign();
    }

    public boolean isLogicalIsSelected() {
        return this.logicalIsSelected;
    }

    public void setLogicalIsSelected(boolean logicalIsSelected) {
        this.logicalIsSelected = logicalIsSelected;
    }

    public List getNewRelationals() {
        return this.newRelationals;
    }

    public void addNewRelational(RelationalDesign relational) {
        this.newRelationals.add(relational);
    }

    public List getSubViews() {
        return this.subViews;
    }

    public void addSubView(DesignPartViewPlaceHolder subViewPL) {
        this.subViews.add(subViewPL);
    }

    public List getModelsToDeleteOnCancel() {
        return this.modelsToDeleteOnCancel;
    }
}

