/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.ViewIndex;

public class ViewIndexComparator
extends PropertiesComparator {
    private ViewIndex sourceIndex;
    private ViewIndex targetIndex;
    private Map objectsMap;

    public ViewIndexComparator(ViewIndex index, ViewIndex key, Map objectsMap) {
        super(index, key);
        this.sourceIndex = index;
        this.targetIndex = key;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initSchemaProperty();
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(INDEX_STATUS);
        ph.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexState() : "");
        ph.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexState() : "");
        if (this.isExcludedFromComparison(INDEX_STATUS)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !this.targetIndex.getIndexState().equals(this.sourceIndex.getIndexState())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(INDEX_FUNCTION_EXPRESSION);
        ph.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexExpression() : "");
        ph.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexExpression() : "");
        if (this.isExcludedFromComparison(INDEX_FUNCTION_EXPRESSION)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !this.isEqualClearLine(this.targetIndex.getIndexExpression(), this.sourceIndex.getIndexExpression())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COLUMNS);
        ph.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
        ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
        if (this.isExcludedFromComparison(COLUMNS)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap, true)) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(false);
        }
        this.propertiesList.add(ph);
    }

    protected void initSchemaProperty() {
        PropertyHolder ph = new PropertyHolder(SCHEMA);
        String sSchema = "";
        String tSchema = "";
        if (this.sourceIndex != null && !this.sourceIndex.isPK() && !this.sourceIndex.isUnique()) {
            sSchema = this.sourceIndex.getSchema();
        }
        if (this.targetIndex != null && !this.targetIndex.isPK() && !this.targetIndex.isUnique()) {
            tSchema = this.targetIndex.getSchema();
        }
        ph.setLeftValue(sSchema);
        ph.setRightValue(tSchema);
        if (this.isExcludedFromComparison(SCHEMA)) {
            ph.setExcluded(true);
        } else if (this.caseSensitive) {
            if (!ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                if (this.useSchema) {
                    ph.setSelected(true);
                } else {
                    ph.setFiltered(true);
                }
            }
        } else if (!ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            if (this.useSchema) {
                ph.setSelected(true);
            } else {
                ph.setFiltered(true);
            }
        }
        this.propertiesList.add(ph);
    }

    private String getElementsToString(ViewIndex keyObject) {
        StringBuffer sb = new StringBuffer();
        Iterator it = keyObject.getElementsCollection().iterator();
        boolean first = true;
        while (it.hasNext()) {
            String sort;
            ContainedObject co = (ContainedObject)it.next();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append("; ").append(co.getName());
                continue;
            }
            if (first) {
                sort = keyObject.getColumnSortOrder(co).trim();
                if ("ASC".equalsIgnoreCase(sort)) {
                    sort = "";
                }
                sb.append(co.getName()).append(" ").append(sort);
                first = false;
                continue;
            }
            sort = keyObject.getColumnSortOrder(co).trim();
            if ("ASC".equalsIgnoreCase(sort)) {
                sort = "";
            }
            sb.append("; ").append(co.getName()).append(" ").append(sort);
        }
        return sb.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromIndexToKey();
    }

    private void copyPropertiesFromIndexToKey() {
        if (this.targetIndex != null && this.sourceIndex != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(SCHEMA)) {
                    if (this.sourceIndex == null || this.targetIndex == null) continue;
                    this.setSchemaObject(this.sourceIndex, this.targetIndex);
                    continue;
                }
                if (ph.getName().equals(INDEX_STATUS)) {
                    this.targetIndex.setIndexState(this.sourceIndex.getIndexState());
                    continue;
                }
                if (!ph.getName().equals(COLUMNS)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey(this.sourceIndex, this.targetIndex);
            }
        }
    }

    private void setSchemaObject(ViewIndex source, ViewIndex target) {
        SchemaObject s_sch = source.getSchemaObject();
        if (s_sch == null) {
            target.setSchemaObject(null);
        } else {
            SchemaObject t_sch = (SchemaObject)((RelationalDesign)target.getDesignPart()).getSchemaObjectSet().getObjectByID(s_sch.getObjectID());
            if (t_sch == null) {
                t_sch = (SchemaObject)((RelationalDesign)target.getDesignPart()).getSchemaObjectSet().getByName(s_sch.getName());
            }
            if (t_sch != null) {
                target.setSchemaObject(t_sch);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceIndex != null ? this.sourceIndex.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetIndex != null ? this.targetIndex.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceIndex == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceIndex == null && this.targetIndex != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public void presetColumnsOrder() {
        EngPropertyHolder ph = this.getPropertyHolderByName(COLUMNS);
        if (ph != null) {
            if (this.getLeftSelectionObject() != null) {
                ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.sourceIndex != null) {
                    CompareObjectSelection[] nodes = this.getColumnNodes(this.sourceIndex, this.getTableNode());
                    ph.setLeftValue(this.getElementsToString(this.sourceIndex, nodes));
                } else {
                    ph.setLeftValue("");
                }
                if (this.targetIndex != null && this.sourceIndex != null) {
                    if (!MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap, true)) {
                        ph.setModified(true);
                        ph.setSelected(true);
                    } else {
                        ph.setModified(false);
                        ph.setSelected(false);
                    }
                    ph.setEditable(false);
                }
            } else {
                ph.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
                ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap, true)) {
                    ph.setModified(true);
                    ph.setSelected(true);
                    ph.setEditable(false);
                }
            }
        }
    }

    private CompareObjectSelection[] getColumnNodes(ViewIndex index, CompareObjectSelection tableNode) {
        ArrayList<CompareObjectSelection> templist = new ArrayList<CompareObjectSelection>();
        CompareObjectSelection columns = (CompareObjectSelection)tableNode.getChild(0);
        int nod_number = columns.getNumberOfChildren();
        for (int i = 0; i < nod_number; ++i) {
            CompareObjectSelection cnode = (CompareObjectSelection)columns.getChild(i);
            if (cnode.getStatus() == 3 || (!cnode.isSelected() || cnode.getStatus() != 2) && cnode.getStatus() == 2) continue;
            templist.add(cnode);
        }
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        ContainedObject[] cos = index.getElements();
        for (int i = 0; i < cos.length; ++i) {
            CompareObjectSelection node = this.getNode(templist, cos[i]);
            if (node == null) continue;
            list.add(node);
        }
        return list.toArray(new CompareObjectSelection[0]);
    }

    private CompareObjectSelection getNode(List list, ModelIDObject tofind) {
        for (CompareObjectSelection node : list) {
            if (node.getObject() != tofind) continue;
            return node;
        }
        return null;
    }

    private String getElementsToString(ViewIndex keyObject, CompareObjectSelection[] nodes) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < nodes.length; ++i) {
            ContainedObject co = (ContainedObject)nodes[i].getObject();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append("; ").append(co.getName());
                continue;
            }
            if (first) {
                sb.append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
        }
        return sb.toString();
    }

    private CompareObjectSelection getTableNode() {
        if (this.getLeftSelectionObject() != null) {
            return (CompareObjectSelection)((CompareObjectSelection)this.getLeftSelectionObject().getParent()).getParent();
        }
        return null;
    }
}

