/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class NoteComparator
extends PropertiesComparator {
    private Note leftNote;
    private Note rightNote;

    public NoteComparator(Note leftNote, Note rightNote) {
        super(leftNote, rightNote);
        this.leftNote = leftNote;
        this.rightNote = rightNote;
        this.initPropertiesList();
    }

    @Override
    public void copySelectedProperties() {
        if (this.leftNote != null && this.rightNote != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || !ph.getName().equals(NOTE_TEXT)) continue;
                this.rightNote.setText(this.leftNote.getText());
            }
        }
    }

    @Override
    protected void initPropertiesList() {
        PropertyHolder ph = new PropertyHolder(NOTE_TEXT);
        if (this.leftNote != null) {
            ph.setLeftValue(this.leftNote.getText());
        }
        if (this.rightNote != null) {
            ph.setRightValue(this.rightNote.getText());
        }
        if (this.isExcludedFromComparison(NOTE_TEXT)) {
            ph.setExcluded(true);
        } else if (this.leftNote != null && this.rightNote != null && !this.isEqualClearLine(this.leftNote.getText(), this.rightNote.getText())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }
}

