/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.IndexComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.PKUKComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StorageTemplateComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;

public class IndexComparator
extends PropertiesComparator {
    private Index sourceIndex;
    private Index targetIndex;
    private Map objectsMap;
    private boolean isPKorUK;
    private StorageDesign sourceSD;
    private StorageDesign targetSD;

    public IndexComparator(Index index, Index key, Map objectsMap, boolean isPKorUK, StorageDesign sourceSD, StorageDesign targetSD) {
        super(index, key);
        this.sourceIndex = index;
        this.targetIndex = key;
        this.objectsMap = objectsMap;
        this.isPKorUK = isPKorUK;
        this.sourceSD = sourceSD;
        this.targetSD = targetSD;
        this.initPropertiesList();
        this.initDynamicProperties();
        this.initStoragePropertiesList();
        this.initPropertiesFilterList();
        this.initStoragePropertiesFilterList();
        this.initPhysicalPropertiesComparator();
        this.updateStoragePropertiesExcludeFlag();
    }

    private void initPhysicalPropertiesComparator() {
        if (this.sourceSD != null && this.targetSD != null) {
            IndexProxy indexProxy;
            IndexProxy sourceIndexProxy = null;
            if (this.sourceIndex != null) {
                sourceIndexProxy = (IndexProxy)this.sourceSD.getStorageObject(this.sourceIndex.getObjectID());
            }
            IndexProxy targetIndexProxy = null;
            if (this.targetIndex != null) {
                targetIndexProxy = (IndexProxy)this.targetSD.getStorageObject(this.targetIndex.getObjectID());
            }
            StoragePropertiesComparator physicalComparator = null;
            IndexProxy indexProxy2 = indexProxy = sourceIndexProxy != null ? sourceIndexProxy : targetIndexProxy;
            if (indexProxy instanceof IndexProxyOracle) {
                physicalComparator = this.isPKorUK ? new PKUKComparatorOracle(sourceIndexProxy, targetIndexProxy) : new IndexComparatorOracle(sourceIndexProxy, targetIndexProxy);
            }
            this.setPhysicalPropertiesComparator(physicalComparator);
        }
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initSchemaProperty();
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(INDEX_STATUS);
        ph.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexState() : "");
        ph.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexState() : "");
        if (this.isExcludedFromComparison(INDEX_STATUS)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !this.targetIndex.getIndexState().equals(this.sourceIndex.getIndexState())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(INDEX_FUNCTION_EXPRESSION);
        ph.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexExpression() : "");
        ph.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexExpression() : "");
        if (this.isExcludedFromComparison(INDEX_FUNCTION_EXPRESSION)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !this.isEqualClearLine(this.targetIndex.getIndexExpression(), this.sourceIndex.getIndexExpression())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COLUMNS);
        ph.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
        ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
        if (this.isExcludedFromComparison(COLUMNS)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap, false)) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(false);
        }
        this.propertiesList.add(ph);
    }

    protected void initSchemaProperty() {
        String name;
        String lname;
        int ind;
        IndexProxy ip;
        RelationalDesign rd;
        StorageDesign sd;
        PropertyHolder ph = new PropertyHolder(SCHEMA);
        String sSchema = "";
        String tSchema = "";
        if (this.sourceIndex != null) {
            sd = this.sourceSD;
            if (sd == null) {
                rd = (RelationalDesign)this.sourceIndex.getDesignPart();
                sd = rd.getStorageDesign();
            }
            if (!this.sourceIndex.isPK() && !this.sourceIndex.isUnique()) {
                if (sd.isOpen() && (ip = (IndexProxy)sd.getStorageObject(this.sourceIndex.getObjectID())) != null && (ind = (lname = ip.getLongName()).indexOf(name = ip.getName())) > 0) {
                    sSchema = lname.substring(0, ind - 1);
                }
                if (sSchema.isEmpty()) {
                    sSchema = this.sourceIndex.getSchema();
                }
            }
        }
        if (this.targetIndex != null) {
            sd = this.targetSD;
            if (sd == null) {
                rd = (RelationalDesign)this.targetIndex.getDesignPart();
                sd = rd.getStorageDesign();
            }
            if (!this.targetIndex.isPK() && !this.targetIndex.isUnique()) {
                if (sd.isOpen() && (ip = (IndexProxy)sd.getStorageObject(this.targetIndex.getObjectID())) != null && (ind = (lname = ip.getLongName()).indexOf(name = ip.getName())) > 0) {
                    tSchema = lname.substring(0, ind - 1);
                }
                if (tSchema.isEmpty()) {
                    tSchema = this.targetIndex.getSchema();
                }
            }
        }
        ph.setLeftValue(sSchema);
        ph.setRightValue(tSchema);
        if (this.isExcludedFromComparison(SCHEMA)) {
            ph.setExcluded(true);
        } else if (this.caseSensitive) {
            if (!ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                if (this.useSchema) {
                    ph.setSelected(true);
                } else {
                    ph.setFiltered(true);
                }
            }
        } else if (!ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            if (this.useSchema) {
                ph.setSelected(true);
            } else {
                ph.setFiltered(true);
            }
        }
        this.propertiesList.add(ph);
    }

    protected void initStoragePropertiesList() {
        if (this.sourceSD instanceof StorageDesignOracle && this.targetSD instanceof StorageDesignOracle) {
            IndexProxyOracle sourceIndexProxy = null;
            IndexProxyOracle targetIndexProxy = null;
            SegmentOracle sourceSegment = null;
            SegmentOracle targetSegment = null;
            TableSpaceOracle sourceTableSpace = null;
            TableSpaceOracle targetTableSpace = null;
            Method templateSetter = null;
            Method tableSpaceSetter = null;
            boolean needTemplateComparator = false;
            if (this.sourceIndex != null && (sourceIndexProxy = (IndexProxyOracle)this.sourceSD.getStorageObject(this.sourceIndex.getObjectID())) != null) {
                try {
                    if (sourceIndexProxy instanceof PKProxyOracle) {
                        sourceSegment = ((PKProxyOracle)sourceIndexProxy).getIndexSegment();
                        templateSetter = PKProxyOracle.class.getMethod("setIndexSegment", SegmentOracle.class);
                    } else if (sourceIndexProxy instanceof UniqueOracle) {
                        sourceSegment = ((UniqueOracle)sourceIndexProxy).getIndexSegment();
                        templateSetter = UniqueOracle.class.getMethod("setIndexSegment", SegmentOracle.class);
                    } else {
                        sourceSegment = sourceIndexProxy.getSegment();
                        templateSetter = IndexProxyOracle.class.getMethod("setSegment", SegmentOracle.class);
                    }
                    sourceTableSpace = sourceIndexProxy.getTableSpace();
                    tableSpaceSetter = IndexProxyOracle.class.getMethod("setTableSpace", TableSpaceOracle.class);
                    if (sourceTableSpace != null || sourceSegment != null) {
                        needTemplateComparator = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.targetIndex != null && (targetIndexProxy = (IndexProxyOracle)this.targetSD.getStorageObject(this.targetIndex.getObjectID())) != null) {
                targetSegment = targetIndexProxy instanceof PKProxyOracle ? ((PKProxyOracle)targetIndexProxy).getIndexSegment() : (targetIndexProxy instanceof UniqueOracle ? ((UniqueOracle)targetIndexProxy).getIndexSegment() : targetIndexProxy.getSegment());
                targetTableSpace = targetIndexProxy.getTableSpace();
                if (targetTableSpace != null || targetSegment != null) {
                    needTemplateComparator = true;
                }
            }
            if (needTemplateComparator) {
                this.templateComparator = new StorageTemplateComparator(sourceIndexProxy, targetIndexProxy, sourceSegment, targetSegment, sourceTableSpace, targetTableSpace, templateSetter, tableSpaceSetter);
                this.templateComparator.filterStoragePropertiesList(this.getStoragePropertiesFilterList());
            }
        }
    }

    private String getElementsToString(Index keyObject) {
        StringBuffer sb = new StringBuffer();
        Iterator it = keyObject.getElementsCollection().iterator();
        boolean first = true;
        while (it.hasNext()) {
            String sort;
            Column co = (Column)it.next();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append("; ").append(co.getName());
                continue;
            }
            if (first) {
                sort = keyObject.getColumnSortOrder(co).trim();
                if ("ASC".equalsIgnoreCase(sort)) {
                    sort = "";
                }
                sb.append(co.getName()).append(" ").append(sort);
                first = false;
                continue;
            }
            sort = keyObject.getColumnSortOrder(co).trim();
            if ("ASC".equalsIgnoreCase(sort)) {
                sort = "";
            }
            sb.append("; ").append(co.getName()).append(" ").append(sort);
        }
        return sb.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromIndexToKey();
    }

    private void copyPropertiesFromIndexToKey() {
        if (this.targetIndex != null && this.sourceIndex != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(SCHEMA)) {
                    if (this.sourceIndex == null || this.targetIndex == null) continue;
                    this.setSchemaObject(this.sourceIndex, this.targetIndex);
                    continue;
                }
                if (ph.getName().equals(INDEX_STATUS)) {
                    this.targetIndex.setIndexState(this.sourceIndex.getIndexState());
                    continue;
                }
                if (!ph.getName().equals(COLUMNS)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey(this.sourceIndex, this.targetIndex);
            }
        }
    }

    private void setSchemaObject(Index source, Index target) {
        SchemaObject s_sch = source.getSchemaObject();
        if (s_sch == null) {
            target.setSchemaObject(null);
        } else {
            SchemaObject t_sch = (SchemaObject)((RelationalDesign)target.getDesignPart()).getSchemaObjectSet().getObjectByID(s_sch.getObjectID());
            if (t_sch == null) {
                t_sch = (SchemaObject)((RelationalDesign)target.getDesignPart()).getSchemaObjectSet().getByName(s_sch.getName());
            }
            if (t_sch != null) {
                target.setSchemaObject(t_sch);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceIndex != null ? this.sourceIndex.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetIndex != null ? this.targetIndex.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceIndex == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceIndex == null && this.targetIndex != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public void presetColumnsOrder() {
        EngPropertyHolder ph = this.getPropertyHolderByName(COLUMNS);
        if (ph != null) {
            if (this.getLeftSelectionObject() != null) {
                ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.sourceIndex != null) {
                    CompareObjectSelection[] nodes = this.getColumnNodes(this.sourceIndex, this.getTableNode());
                    ph.setLeftValue(this.getElementsToString(this.sourceIndex, nodes));
                } else {
                    ph.setLeftValue("");
                }
                if (this.targetIndex != null && this.sourceIndex != null) {
                    if (!MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap, false)) {
                        ph.setModified(true);
                        ph.setSelected(true);
                    } else {
                        ph.setModified(false);
                        ph.setSelected(false);
                    }
                    ph.setEditable(false);
                }
            } else {
                ph.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
                ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap, false)) {
                    ph.setModified(true);
                    ph.setSelected(true);
                    ph.setEditable(false);
                }
            }
        }
    }

    private CompareObjectSelection[] getColumnNodes(Index index, CompareObjectSelection tableNode) {
        ArrayList<CompareObjectSelection> templist = new ArrayList<CompareObjectSelection>();
        CompareObjectSelection columns = (CompareObjectSelection)tableNode.getChild(0);
        int nod_number = columns.getNumberOfChildren();
        for (int i = 0; i < nod_number; ++i) {
            CompareObjectSelection cnode = (CompareObjectSelection)columns.getChild(i);
            if (cnode.getStatus() == 3 || (!cnode.isSelected() || cnode.getStatus() != 2) && cnode.getStatus() == 2) continue;
            templist.add(cnode);
        }
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        ContainedObject[] cos = index.getElements();
        for (int i = 0; i < cos.length; ++i) {
            CompareObjectSelection node = this.getNode(templist, cos[i]);
            if (node == null) continue;
            list.add(node);
        }
        return list.toArray(new CompareObjectSelection[0]);
    }

    private CompareObjectSelection getNode(List list, ModelIDObject tofind) {
        for (CompareObjectSelection node : list) {
            if (node.getObject() != tofind) continue;
            return node;
        }
        return null;
    }

    private String getElementsToString(Index keyObject, CompareObjectSelection[] nodes) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < nodes.length; ++i) {
            ContainedObject co = (ContainedObject)nodes[i].getObject();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append("; ").append(co.getName());
                continue;
            }
            if (first) {
                sb.append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
        }
        return sb.toString();
    }

    private CompareObjectSelection getTableNode() {
        if (this.getLeftSelectionObject() != null) {
            return (CompareObjectSelection)((CompareObjectSelection)this.getLeftSelectionObject().getParent()).getParent();
        }
        return null;
    }
}

