/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelIdObjectSelectionListener;
import oracle.dbtools.crest.model.ModelObject;

public class CompareTreeNavigationDesign
implements TreeModel,
ModelIdObjectSelectionListener {
    private Set listeners = new HashSet();
    private ModelObject despart;

    public CompareTreeNavigationDesign(ModelObject root) {
        this.despart = root;
        this.traverseTreeAndRegisterListener(this.despart);
    }

    public CompareTreeNavigationDesign(ModelObject root, boolean traverse) {
        this.despart = root;
        if (traverse) {
            this.traverseTreeAndRegisterListener(this.despart);
        }
    }

    protected void traverseTreeAndRegisterListener(ModelObject node) {
        int num = node.getNumberOfChildren();
        if (node instanceof ModelIdObjectSelection) {
            ((ModelIdObjectSelection)node).addDDLSelectionListener(this);
        }
        for (int i = 0; i < num; ++i) {
            ModelObject child = node.getChild(i);
            if (child == null) continue;
            this.traverseTreeAndRegisterListener(child);
        }
    }

    protected void traverseTreeAndUnregisterAsListener(ModelObject node) {
        int num = node.getNumberOfChildren();
        if (node instanceof ModelIdObjectSelection) {
            ((ModelIdObjectSelection)node).removeDDLSelectionListener(this);
        }
        for (int i = 0; i < num; ++i) {
            ModelObject child = node.getChild(i);
            if (child == null) continue;
            this.traverseTreeAndUnregisterAsListener(child);
        }
    }

    @Override
    public Object getRoot() {
        return this.despart;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected ModelObject toModelObject(Object object) {
        return (ModelObject)object;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof ModelObject) {
            return this.toModelObject(node).isLeaf();
        }
        return true;
    }

    @Override
    public Object getChild(Object node, int index) {
        return this.toModelObject(node).getChildPlain(index);
    }

    @Override
    public int getChildCount(Object node) {
        if (node instanceof ModelObject) {
            return this.toModelObject(node).getNumberOfChildren();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child instanceof ModelObject) {
            return this.toModelObject(parent).getIndexForChild(this.toModelObject(child));
        }
        return this.toModelObject(parent).getIndexForChild(child);
    }

    public void fireStructureChanged(ModelObject object) {
        if (object.hasAlternatePaths()) {
            Object[][] altPaths = object.getAlternatePaths();
            for (int i = 0; i < altPaths.length; ++i) {
                this.fireStructureChanged(object, altPaths[i]);
            }
        } else {
            this.fireStructureChanged(object, object.getPath());
        }
    }

    protected void fireStructureChanged(ModelObject object, Object[] path) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(new TreeModelEvent((Object)this, path));
        }
    }

    protected void fireNodeChanged(ModelObject object) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(new TreeModelEvent((Object)this, new TreePath(object.getPath())));
        }
        this.fireStructureChanged(object);
    }

    @Override
    public void changed(ModelIdObjectSelection object) {
        this.fireNodeChanged(object);
    }

    public void unregisterAsListener() {
        this.traverseTreeAndUnregisterAsListener(this.despart);
    }
}

