/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.util.logging.Logger;

public class DesignObjectPlaceHolder
extends DesignObject
implements ObjectListener,
ContainerObjectListener {
    private DesignObject object;
    private static final Logger LOGGER = new Logger(DesignObjectPlaceHolder.class);
    protected boolean propagate = false;
    protected ContainerObjectEvent sharedEvent = new ContainerObjectEvent();

    public DesignObjectPlaceHolder(DesignPart designPart) {
        super(designPart);
    }

    public DesignObjectPlaceHolder(DesignPart designPart, String name) {
        super(designPart);
        this.setName(name);
    }

    public DesignObjectPlaceHolder(DesignPart designPart, DesignObject object) {
        super(designPart);
        this.object = object;
        this.setDesign(object.getDesign());
        if (this.getDesignObject() != null) {
            this.getDesignObject().addObjectListener(this);
            if (this.getDesignObject() instanceof ContainerObject) {
                ((ContainerObject)this.getDesignObject()).addContainerListener(this);
            }
        }
    }

    public DesignObjectPlaceHolder(DesignObject object) {
        this(object.getDesignPart(), object);
    }

    public DesignObjectPlaceHolder(DesignPart designPart, DesignObject object, boolean propagateSelection) {
        this(designPart, object);
        this.propagate = propagateSelection;
    }

    public void setObject(DesignObject object) {
        if (this.getDesignObject() != null) {
            this.getDesignObject().removeObjectListener(this);
        }
        this.object = object;
        if (this.getDesignObject() != null) {
            this.getDesignObject().addObjectListener(this);
        }
    }

    public Object getObject() {
        return this.object;
    }

    public DesignObject getDesignObject() {
        return this.object;
    }

    @Override
    public String getName() {
        if (this.object != null && this.object.getName() != null && !"".equals(this.object.getName())) {
            return this.object.getName();
        }
        return super.getName();
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    @Override
    public String getObjectTypeName() {
        return "StorageObjectPlaceHolder";
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("StorageObjectPlaceHolder");
    }

    @Override
    public int getNumberOfChildren() {
        return 0;
    }

    @Override
    public ModelObject getChild(int index) {
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void setParent(Object parent) {
        this.parent = parent;
    }

    @Override
    public Object getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return super.getParent();
    }

    @Override
    public void setShouldEngineer(boolean value, boolean setDirty) {
        if (this.getDesignObject() != null) {
            this.getDesignObject().setShouldEngineer(value, setDirty);
            if (this.propagate) {
                this.propagateShouldEngineer(value, setDirty);
            }
        }
    }

    @Override
    public boolean getShouldEngineer() {
        if (this.getDesignObject() != null) {
            return this.getDesignObject().getShouldEngineer();
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getObject().toString();
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.NAME_CHANGED)) {
            this.fireChange(ObjectChangeEvent.DESIGN_OBJECT_NAME_CHANGED);
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean value) {
        this.selected = value;
        if (this.propagate) {
            this.propagateSelected(value);
        }
    }

    public void propagateSelected(boolean selected) {
        int k = this.getNumberOfChildren();
        for (int i = 0; i < k; ++i) {
            DesignObject dp = (DesignObject)this.getChild(i);
            dp.setSelected(selected);
        }
    }

    public void propagateShouldEngineer(boolean selected) {
        this.propagateShouldEngineer(selected, true);
    }

    public void propagateShouldEngineer(boolean selected, boolean setDirty) {
        int k = this.getNumberOfChildren();
        for (int i = 0; i < k; ++i) {
            ModelObject object = this.getChild(i);
            if (!(object instanceof DesignObject)) continue;
            DesignObject dp = (DesignObject)object;
            dp.setShouldEngineer(selected, setDirty);
        }
    }

    @Override
    public boolean shouldBeEngineered() {
        if (this.getDesignObject() != null) {
            return this.getDesignObject().shouldBeEngineered();
        }
        return false;
    }

    @Override
    public void changed(ContainerObject container, ContainerObjectEvent event) {
        this.sharedEvent.setType(6);
        this.sharedEvent.setElement(container);
        ObjectListener[] listeners = this.getListeners().toArray(new ObjectListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            try {
                this.fireChange(new ObjectChangeEvent(Messages.getString("DesignObjectPlaceHolder.DesignObjectNameChanged")));
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Listener caused exception: ", e);
            }
        }
    }

    @Override
    public String getLongName() {
        if (this.getDesignObject() != null && this.getDesignObject().getName() != null && !"".equals(this.getDesignObject().getName())) {
            return this.getDesignObject().getLongName();
        }
        return super.getLongName();
    }
}

