/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FK_And_Delegate_Holder;

public abstract class AbstractViewElement
extends FKElement {
    private static String REFERRED_COLUMN = "referredColumn";
    private static String FK_ASSOCIATION = "fkAssociation";
    private String alias = "";
    private ContainedObjectWithDomain referencedColumn;
    private String expression = "";
    private String dataType = "";
    private AbstractView view = null;
    private ContainerWithKeyObject table = null;
    private String tableAlias = "";
    private String fkAssociationId;
    private String fkColumnId;
    private FKElement referencedColumnView;
    private String referencedColumnViewID;
    private TypeElement typeElement;
    private String headerAlias = "";
    private boolean previousColumn = true;
    private String abbreviation = "";
    private boolean dependOnFK_Mandatory = false;
    private FKIndexAssociation dependOnForeignKey;
    private String dependOnForeignKeyID = "";
    private FKElement delegate = null;
    private String viewID;
    private Collection allrefs = new ArrayList();
    List checkedCols;

    public AbstractViewElement(DesignPart designPart) {
        super(designPart);
        this.setUse((short)1);
    }

    public AbstractViewElement(DesignPart designPart, FKElement refColumn, FKIndexAssociation fkAssoc) {
        super(designPart);
        this.fkAssociationId = fkAssoc.getObjectID();
        this.fkColumnId = refColumn.getObjectID();
        FKElement.FKColRefNode ref = new FKElement.FKColRefNode(this);
        ref.fkAssocId = fkAssoc.getObjectID();
        ref.refColumnId = refColumn.getObjectID();
        this.allrefs.add(ref);
        this.setPreviousColumn(false);
    }

    @Override
    public boolean isPreviousColumn() {
        return this.previousColumn;
    }

    public void setPreviousColumn(boolean previousColumn) {
        this.previousColumn = previousColumn;
    }

    @Override
    public Datatype getDataType(String rdbmsName) {
        if (!(this.fkAssociationId == null || this.referencedColumnViewID == null || this.referencedColumnViewID.equalsIgnoreCase(this.getObjectID()) || this.isNested() || this.getContainer().isBST())) {
            Datatype dt;
            ContainedObjectWithDomain referencedColumn = this.getReferencedColumn();
            if (referencedColumn instanceof Column) {
                if (referencedColumn != null && !this.hasCircularRef()) {
                    return referencedColumn.getDataType(rdbmsName);
                }
            } else if (referencedColumn instanceof ColumnView && (dt = referencedColumn.getDataType(rdbmsName)) != null && !"UNKNOWN".equalsIgnoreCase(dt.getName())) {
                return dt;
            }
        }
        return super.getDataType(rdbmsName);
    }

    public String getDataTypeString() {
        return this.getDataType(0);
    }

    @Override
    public String getDatatypeString(String rdbmsName) {
        return this.getDataType(0);
    }

    @Override
    public String getDataType(int nestedLevel) {
        ContainedObjectWithDomain refColumn = this.getReferencedColumn();
        if (refColumn != null) {
            if (refColumn instanceof ColumnView) {
                return ((ColumnView)refColumn).getDataTypeString();
            }
            return refColumn.getDatatypeString(this.getDesignPart().getSelectedRDBMSType().getName());
        }
        if (this.getReferencedColumnView() != null && nestedLevel < 10) {
            return this.getReferencedColumnView().getDataType(nestedLevel + 1);
        }
        if (this.typeElement != null) {
            return this.typeElement.getDataType(this.getDesignPart().getSelectedRDBMSType().getName());
        }
        if ("".equalsIgnoreCase(this.dataType)) {
            return "UNKNOWN";
        }
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public boolean hasCircularRef() {
        this.checkedCols = new ArrayList();
        if (this.isFKColumn()) {
            for (FKElement.FKColRefNode snode : this.getRefColAndAssocIDs()) {
                FKElement refColumn = (FKElement)this.getDesign().getDesignObject(snode.refColumnId);
                if (refColumn == null) continue;
                if (this == refColumn) {
                    return true;
                }
                if (this.checkedCols.contains(refColumn)) continue;
                this.checkedCols.add(refColumn);
                boolean found = this.testColumn(refColumn);
                if (!found) continue;
                return found;
            }
        }
        return false;
    }

    private boolean testColumn(FKElement col) {
        if (col.isFKColumn()) {
            for (FKElement.FKColRefNode snode : col.getRefColAndAssocIDs()) {
                FKElement refColumn = (FKElement)this.getDesign().getDesignObject(snode.refColumnId);
                if (refColumn == null) continue;
                if (this == refColumn) {
                    return true;
                }
                if (this.checkedCols.contains(refColumn)) continue;
                this.checkedCols.add(refColumn);
                boolean found = this.testColumn(refColumn);
                if (!found) continue;
                return found;
            }
        }
        return false;
    }

    public ContainedObjectWithDomain getReferencedColumn() {
        FKIndexAssociation fkass;
        if (this.referencedColumn == null && this.fkColumnId != null && this.fkAssociationId != null && (fkass = this.getFKIndexAssociation(this.fkAssociationId)) != null && fkass.getRemoteTable() != null) {
            return (FKElement)fkass.getRemoteTable().getElementByID(this.fkColumnId);
        }
        return this.referencedColumn;
    }

    public void setReferencedColumn(ContainedObjectWithDomain referencedColumn) {
        if (this.referencedColumn != referencedColumn) {
            if (referencedColumn instanceof AbstractViewElement) {
                this.setReferencedColumnView((AbstractViewElement)referencedColumn);
            } else {
                if (this.referencedColumn != null) {
                    this.referencedColumn.removeObjectListener(this);
                }
                this.referencedColumn = referencedColumn;
                if (referencedColumn != null) {
                    this.setReferencedColumnView(null);
                    this.setReferencedColumnViewID(null);
                    referencedColumn.addObjectListener(this);
                    if (this.getContainer() != null) {
                        referencedColumn.addObjectListener(this.getContainer());
                    }
                }
            }
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        String oldAlias = this.alias;
        this.alias = alias == null ? "" : alias;
        if (!oldAlias.equals(this.alias)) {
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public AbstractView getView() {
        if (this.view == null && this.viewID != null && !"".equals(this.viewID)) {
            this.view = (AbstractView)this.getDesign().getDesignObject(this.viewID);
        }
        return this.view;
    }

    public void setView(AbstractView view) {
        this.view = view;
    }

    public ContainerWithKeyObject getTable() {
        return this.table;
    }

    public void setTable(ContainerWithKeyObject table) {
        this.table = table;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias == null ? "" : tableAlias;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPresentationName());
        return buffer.toString();
    }

    public String getPresentationName(boolean hasHeader) {
        String name = this.getHeaderAlias();
        if (!hasHeader || name == null || "".equalsIgnoreCase(name)) {
            name = this.getAlias();
        }
        if (name == null || "".equalsIgnoreCase(name)) {
            name = this.getName();
        }
        if (name.startsWith("NULL SET") && !"".equals(this.getExpression())) {
            name = this.getExpression();
        }
        return name;
    }

    public String getPresentationName() {
        String name = this.getHeaderAlias();
        if (name == null || "".equalsIgnoreCase(name)) {
            name = this.getPresentationName(false);
        } else {
            boolean hasHeader = true;
            if (this.getContainer() != null) {
                hasHeader = ((AbstractView)this.getContainer()).hasValidHeader();
            }
            name = this.getPresentationName(hasHeader);
        }
        return name;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        ContainedObjectWithDomain refColumn;
        super.changed(object, event);
        if (object instanceof ContainedObject && event.isType(ObjectChangeEvent.NAME_CHANGED) && (object == (refColumn = this.getReferencedColumn()) || refColumn == null && object == this.getReferencedColumnView())) {
            this.setName(object.getName());
        }
    }

    public FKElement getReferencedColumnView() {
        FKElement temp;
        if (this.referencedColumnView == null && this.referencedColumnViewID != null && (temp = (FKElement)this.getDesign().getDesignObject(this.referencedColumnViewID)) != null) {
            this.setReferencedColumnView(temp);
        }
        return this.referencedColumnView;
    }

    public void setReferencedColumnView(FKElement referencedColumnView) {
        if (this.referencedColumnView != referencedColumnView) {
            if (referencedColumnView == null || referencedColumnView instanceof AbstractViewElement) {
                if (this.referencedColumnView != null) {
                    this.referencedColumnView.removeObjectListener(this);
                }
                this.referencedColumnView = referencedColumnView;
                if (referencedColumnView != null) {
                    this.setReferencedColumn(null);
                    referencedColumnView.addObjectListener(this);
                    if (this.getContainer() != null) {
                        referencedColumnView.addObjectListener(this.getContainer());
                    }
                }
            } else {
                this.setReferencedColumn(this.referencedColumn);
            }
        }
    }

    public String getReferencedColumnViewID() {
        if (this.referencedColumnView != null) {
            this.referencedColumnViewID = this.referencedColumnView.getObjectID();
        }
        return this.referencedColumnViewID;
    }

    public void setReferencedColumnViewID(String referencedColumnViewID) {
        this.referencedColumnViewID = referencedColumnViewID;
    }

    public String getReferencedName() {
        if (this.getReferencedColumnView() != null) {
            FKElement el = this.getReferencedColumnView();
            if (el instanceof Column) {
                return el.getName();
            }
            return ((AbstractViewElement)el).getPresentationName();
        }
        if (this.getReferencedColumn() != null) {
            return this.getReferencedColumn().getName();
        }
        if (!"".equals(this.getAlias())) {
            return this.getAlias();
        }
        return this.getName();
    }

    public ContainerObject getReferencedContainer() {
        if (this.getReferencedColumnView() != null) {
            return this.getReferencedColumnView().getContainer();
        }
        if (this.getReferencedColumn() != null) {
            return this.getReferencedColumn().getContainer();
        }
        return null;
    }

    public String getViewID() {
        if (this.view != null) {
            this.viewID = this.view.getObjectID();
        }
        return this.viewID;
    }

    public void setViewID(String viewID) {
        this.viewID = viewID;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public void setTypeElement(TypeElement typeElement) {
        this.typeElement = typeElement;
    }

    public String getHeaderAlias() {
        return this.headerAlias;
    }

    public void setHeaderAlias(String headerAlias) {
        this.headerAlias = headerAlias;
    }

    @Override
    public boolean isDeprecated() {
        if (this.referencedColumn != null) {
            return this.referencedColumn.isDeprecated();
        }
        return super.isDeprecated();
    }

    @Override
    public boolean isMandatory() {
        if (this.isPKElement()) {
            return true;
        }
        if (this.referencedColumn != null) {
            return this.referencedColumn.isMandatory();
        }
        if (this.getReferencedColumnView() != null) {
            return this.getReferencedColumnView().isMandatory();
        }
        return super.isMandatory();
    }

    @Override
    public boolean isFKElement() {
        return this.isFKElement(false);
    }

    public boolean isFKElement(boolean onlyThisOne) {
        if (this.getAssociationsCount() > 0) {
            return true;
        }
        if (onlyThisOne) {
            return false;
        }
        return super.isFKElement();
    }

    @Override
    public boolean isInOptionalFK() {
        return this.getOptionalFK() != null;
    }

    public FKIndexAssociation getOptionalFK() {
        for (FKIndexAssociation fk : this.getAllFKs()) {
            if (fk.isMandatory()) continue;
            return fk;
        }
        return null;
    }

    @Override
    public List getAllFKs() {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        for (FKElement.FKColRefNode snode : this.allrefs) {
            FKIndexAssociation fkass = null;
            if (snode.fkAssocId != null) {
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            } else if (snode.fkAssociationRef != null) {
                snode.fkAssocId = snode.fkAssociationRef.getObject().getObjectID();
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            }
            if (fkass == null) continue;
            list.add(fkass);
        }
        return list;
    }

    private FKIndexAssociation getFKIndexAssociation(String fkId) {
        if (this.getContainerWithKeyObject() == null) {
            return null;
        }
        KeyObject[] indexes = this.getContainerWithKeyObject().getKeys();
        for (int i = 0; i < indexes.length; ++i) {
            if (!indexes[i].isFK() || !indexes[i].getFKAssociation().getObjectID().equalsIgnoreCase(fkId)) continue;
            return indexes[i].getFKAssociation();
        }
        return null;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public String getNotNullConstraintName() {
        return null;
    }

    @Override
    public void setNotNullConstraintName(String notNullConstraintName) {
    }

    @Override
    public boolean isReferingTo(FKIndexAssociation fk, FKElement delegate) {
        String fkid = fk.getObjectID();
        Iterator it = this.allrefs.iterator();
        String delegateId = delegate.getObjectID();
        while (it.hasNext()) {
            FKElement.FKColRefNode node = (FKElement.FKColRefNode)it.next();
            if (node.refColumnId == null || delegate == null || !node.refColumnId.equalsIgnoreCase(delegateId) || !fkid.equals(node.fkAssocId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addFKAssociation(FKElement refColumn, FKIndexAssociation fkAssociation) {
        String fkId = fkAssociation.getObjectID();
        String rfColId = refColumn.getObjectID();
        this.addFKAssociation(rfColId, fkId);
    }

    @Override
    public void addFKAssociation(String rfColId, String fkId) {
        if (this.allrefs.size() == 0) {
            this.fkAssociationId = fkId;
            this.fkColumnId = rfColId;
        }
        boolean added = false;
        for (FKElement.FKColRefNode ref : this.allrefs) {
            if (ref.fkAssocId.equalsIgnoreCase(fkId)) {
                ref.refColumnId = rfColId;
                added = true;
                continue;
            }
            if (ref.fkAssociationRef == null || !fkId.equalsIgnoreCase(ref.fkAssociationRef.getObject().getObjectID())) continue;
            ref.refColumnId = rfColId;
            added = true;
        }
        if (!added) {
            FKElement.FKColRefNode ref;
            ref = new FKElement.FKColRefNode(this);
            ref.fkAssocId = fkId;
            ref.refColumnId = rfColId;
            this.allrefs.add(ref);
        }
    }

    @Override
    public void removeFKAssociation(String fkAssocId) {
        if (this.fkAssociationId != null && this.fkAssociationId.equalsIgnoreCase(fkAssocId)) {
            FKElement refcol = this.getReferencedColumnView();
            this.fkAssociationId = null;
            this.fkColumnId = null;
            if (refcol != null && !this.isNested() && !this.getContainer().isBST()) {
                MergingModels.copyDataTypeFromCOWD_To_COWD(refcol, this, false);
            }
        }
        if (this.allrefs.size() > 0) {
            Iterator it;
            FKElement.FKColRefNode[] arr = this.allrefs.toArray(new FKElement.FKColRefNode[0]);
            for (int i = 0; i < arr.length; ++i) {
                if (!fkAssocId.equalsIgnoreCase(arr[i].fkAssocId) && (arr[i].fkAssociationRef == null || arr[i].fkAssociationRef.getObject() == null || !fkAssocId.equalsIgnoreCase(arr[i].fkAssociationRef.getObject().getObjectID()))) continue;
                this.allrefs.remove(arr[i]);
                break;
            }
            if ((it = this.allrefs.iterator()).hasNext()) {
                FKElement.FKColRefNode rnode = (FKElement.FKColRefNode)it.next();
                this.fkAssociationId = rnode.fkAssocId;
                this.fkColumnId = rnode.refColumnId;
            } else {
                this.fkAssociationId = null;
                this.fkColumnId = null;
            }
        }
    }

    @Override
    public int getAssociationsCount() {
        return this.allrefs.size();
    }

    @Override
    public Collection getFKAssociationsForDelegate(String delegateId) {
        ArrayList<DesignObject> col = new ArrayList<DesignObject>();
        for (FKElement.FKColRefNode snode : this.allrefs) {
            if (snode.fkAssocId != null) {
                if (!snode.refColumnId.equalsIgnoreCase(delegateId)) continue;
                col.add(this.getFKIndexAssociation(snode.fkAssocId));
                continue;
            }
            if (snode.fkAssociationRef == null || snode.fkAssociationRef.getObject() == null || !snode.refColumnId.equalsIgnoreCase(delegateId)) continue;
            col.add(snode.fkAssociationRef.getObject());
        }
        return col;
    }

    @Override
    public boolean isInMandatoryFK() {
        for (FKIndexAssociation fk : this.getAllFKs()) {
            if (!fk.isMandatory()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDependOnFK_AsMandatory() {
        return this.dependOnFK_Mandatory;
    }

    @Override
    public void setDependOnFK_AsMandatory(boolean dependOnFK_Mandatory) {
        this.dependOnFK_Mandatory = dependOnFK_Mandatory;
    }

    @Override
    public FKElement getReferencedColumn(FKIndexAssociation fkAssoc) {
        Iterator it = this.allrefs.iterator();
        String id = fkAssoc.getObjectID();
        while (it.hasNext()) {
            FKContainer remoteTable;
            FKIndexAssociation fkass;
            FKElement.FKColRefNode rnode = (FKElement.FKColRefNode)it.next();
            if (!rnode.fkAssocId.equalsIgnoreCase(id) || rnode.refColumnId == null || (fkass = this.getFKIndexAssociation(rnode.fkAssocId)) == null || (remoteTable = fkass.getRemoteTable()) == null) continue;
            return (FKElement)remoteTable.getElementByID(rnode.refColumnId);
        }
        return null;
    }

    public FKElement getReferencedColumn(String fkAssocID) {
        for (FKElement.FKColRefNode rnode : this.allrefs) {
            FKContainer remoteTable;
            FKIndexAssociation fkass;
            if (!rnode.fkAssocId.equalsIgnoreCase(fkAssocID) || rnode.refColumnId == null || (fkass = this.getFKIndexAssociation(rnode.fkAssocId)) == null || (remoteTable = fkass.getRemoteTable()) == null) continue;
            return (FKElement)remoteTable.getElementByID(rnode.refColumnId);
        }
        return null;
    }

    @Override
    public boolean isFKColumn() {
        return this.getAssociationsCount() > 0;
    }

    @Override
    public boolean isPartOfFKIndexAssociation(FKIndexAssociation fkAssoc) {
        FKElement.FKColRefNode[] arr = this.allrefs.toArray(new FKElement.FKColRefNode[0]);
        String id = fkAssoc.getObjectID();
        if (id == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (id.equalsIgnoreCase(arr[i].fkAssocId)) {
                return true;
            }
            if (arr[i].fkAssociationRef == null) continue;
            return id.equalsIgnoreCase(arr[i].fkAssociationRef.getObject().getObjectID());
        }
        return false;
    }

    @Override
    public List getAllDelegatesAndFK() {
        ArrayList<FK_And_Delegate_Holder> list = new ArrayList<FK_And_Delegate_Holder>();
        for (FKElement.FKColRefNode snode : this.allrefs) {
            FKElement dcol;
            FKIndexAssociation fkass = null;
            if (snode.fkAssocId != null) {
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            } else if (snode.fkAssociationRef != null) {
                snode.fkAssocId = snode.fkAssociationRef.getObject().getObjectID();
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            }
            if (fkass == null || snode.refColumnId == null || (dcol = (FKElement)fkass.getRemoteTable().getElementByID(snode.refColumnId)) == null) continue;
            FK_And_Delegate_Holder fkh = new FK_And_Delegate_Holder();
            fkh.delegateColumn = dcol;
            fkh.fk = fkass;
            list.add(fkh);
        }
        return list;
    }

    @Override
    public FKIndexAssociation getDependOnForeignKey() {
        DesignObject obj;
        if (this.dependOnForeignKey == null && !"".equals(this.dependOnForeignKeyID) && (obj = this.getDesign().getDesignObject(this.dependOnForeignKeyID)) instanceof FKIndexAssociation) {
            this.dependOnForeignKey = (FKIndexAssociation)obj;
        }
        return this.dependOnForeignKey;
    }

    @Override
    public void setDependOnForeignKey(FKIndexAssociation dependOnForeignKey) {
        if (dependOnForeignKey != null) {
            this.dependOnForeignKeyID = dependOnForeignKey.getObjectID();
        }
        this.dependOnForeignKey = dependOnForeignKey;
    }

    public String getDependOnForeignKeyID() {
        if (this.dependOnForeignKey != null && !this.dependOnForeignKey.isRemoved()) {
            this.dependOnForeignKeyID = this.dependOnForeignKey.getObjectID();
        }
        return this.dependOnForeignKeyID;
    }

    @Override
    public void setDependOnForeignKeyID(String dependOnForeignKeyID) {
        this.dependOnForeignKeyID = dependOnForeignKeyID;
    }

    @Override
    public FKElement getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        if (this.getReferencedColumn() != null) {
            return (FKElement)this.getReferencedColumn();
        }
        return this.getReferencedColumnView();
    }

    @Override
    public Collection getRefColAndAssocIDs() {
        for (FKElement.FKColRefNode snode : this.allrefs) {
            FKIndexAssociation fkass;
            if (snode.fkAssocId != null) {
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
                if (fkass != null) {
                    snode.remoteTableId = fkass.getRemoteTable().getObjectID();
                    snode.remoteKeyId = fkass.getKeyObject().getObjectID();
                    continue;
                }
                snode.remoteTableId = "null";
                snode.remoteKeyId = "null";
                continue;
            }
            if (snode.fkAssociationRef != null) {
                snode.fkAssocId = snode.fkAssociationRef.getObject().getObjectID();
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
                if (fkass != null) {
                    snode.remoteTableId = fkass.getRemoteTable().getObjectID();
                    snode.remoteKeyId = fkass.getKeyObject().getObjectID();
                    continue;
                }
                snode.remoteTableId = "null";
                snode.remoteKeyId = "null";
                continue;
            }
            snode.fkAssocId = "null";
            snode.remoteKeyId = "null";
            snode.remoteTableId = "null";
        }
        return this.allrefs;
    }

    public String getFKAssociationID() {
        return this.fkAssociationId;
    }

    public void setFKAssociationID(String fkAssociationId) {
        this.fkAssociationId = fkAssociationId;
    }

    public String getFKColumnID() {
        return this.fkAssociationId;
    }

    public void setFKColumnID(String fkColumnId) {
        this.fkColumnId = fkColumnId;
    }

    public List getFKAssociationMaps() {
        ArrayList list = new ArrayList();
        try {
            for (FKElement.FKColRefNode refNode : this.getRefColAndAssocIDs()) {
                FKIndexAssociation fk;
                if (refNode.fkAssocId == null || (fk = this.getFKIndexAssociation(refNode.fkAssocId)) == null) continue;
                TreeMap<String, String> map = new TreeMap<String, String>();
                map.put(REFERRED_COLUMN, refNode.refColumnId);
                map.put(FK_ASSOCIATION, refNode.fkAssocId);
                list.add(map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public void addFKAssociationMaps(List list) {
        for (Object obj : list) {
            if (!(obj instanceof Map)) continue;
            Map map = (Map)obj;
            String refCol = (String)map.get(REFERRED_COLUMN);
            String fkid = (String)map.get(FK_ASSOCIATION);
            if (refCol == null || fkid == null) continue;
            this.addFKAssociation(refCol, fkid);
        }
    }

    @Override
    public List getMappingsToAttributes() {
        ArrayList temp = new ArrayList();
        return temp;
    }

    @Override
    public boolean isReferingTo(FKElement delegate) {
        Iterator it = this.allrefs.iterator();
        String delegateId = delegate.getObjectID();
        while (it.hasNext()) {
            FKElement.FKColRefNode node = (FKElement.FKColRefNode)it.next();
            if (node.refColumnId == null || delegate == null || !node.refColumnId.equalsIgnoreCase(delegateId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDirectorySegmentName() {
        return "";
    }
}

