/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.udb;

import java.util.Map;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.MDFloat;
import oracle.dbtools.crest.model.datatype.MDUnknown;
import oracle.dbtools.crest.model.datatype.MDUserDefined_NoParams;
import oracle.dbtools.crest.model.datatype.udb.MDBigIntUDB;
import oracle.dbtools.crest.model.datatype.udb.MDBlobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDCharacterUDB;
import oracle.dbtools.crest.model.datatype.udb.MDClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDBClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDataLinkUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDateUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDecimalUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDoubleUDB;
import oracle.dbtools.crest.model.datatype.udb.MDGraphicUDB;
import oracle.dbtools.crest.model.datatype.udb.MDIntegerUDB;
import oracle.dbtools.crest.model.datatype.udb.MDLongVarGraphicUDB;
import oracle.dbtools.crest.model.datatype.udb.MDLongVarcharUDB;
import oracle.dbtools.crest.model.datatype.udb.MDRealUDB;
import oracle.dbtools.crest.model.datatype.udb.MDSmallIntUDB;
import oracle.dbtools.crest.model.datatype.udb.MDTimeStampUDB;
import oracle.dbtools.crest.model.datatype.udb.MDTimeUDB;
import oracle.dbtools.crest.model.datatype.udb.MDVarGraphicUDB;
import oracle.dbtools.crest.model.datatype.udb.MDVarcharUDB;

public class MDDataTypeFactoryUDB
extends MDDataTypeFactory {
    @Override
    protected void initFlyWeights() {
        Map flyweights = this.getFlyWeights();
        flyweights.put("UNKNOWN", new MDUnknown());
        flyweights.put("REAL", new MDRealUDB());
        MDDoubleUDB real = new MDDoubleUDB();
        real.setFloatSynonym();
        flyweights.put("DATALINK", new MDDataLinkUDB());
        flyweights.put("DATE", new MDDateUDB());
        flyweights.put("DOUBLE", new MDDoubleUDB());
        flyweights.put("INTEGER", new MDIntegerUDB());
        flyweights.put("REAL", new MDRealUDB());
        flyweights.put("TIME", new MDTimeUDB());
        flyweights.put("TIMESTAMP", new MDTimeStampUDB());
        MDVarcharUDB charVarying = new MDVarcharUDB();
        charVarying.setCharVaryingSynonym();
        flyweights.put("CHAR VARYING", charVarying);
        MDVarcharUDB characterVarying = new MDVarcharUDB();
        characterVarying.setCharacterVaryingSynonym();
        flyweights.put("CHARACTER VARYING", characterVarying);
        MDDecimalUDB numeric = new MDDecimalUDB();
        numeric.setNumericSynonym();
        flyweights.put("NUMERIC", numeric);
        flyweights.put("XML", new MDUserDefined_NoParams("XML"));
    }

    @Override
    protected void initHeavyWeights() {
        Map heavyweights = this.getHeavyWeights();
        heavyweights.put("BLOB", MDBlobUDB.class);
        heavyweights.put("CLOB", MDClobUDB.class);
        heavyweights.put("CHAR", MDCharacterUDB.class);
        heavyweights.put("DECIMAL", MDDecimalUDB.class);
        heavyweights.put("VARCHAR", MDVarcharUDB.class);
        heavyweights.put("GRAPHIC", MDGraphicUDB.class);
        heavyweights.put("VARGRAPHIC", MDVarGraphicUDB.class);
        heavyweights.put("LONG VARCHAR", MDLongVarcharUDB.class);
        heavyweights.put("LONG VARGRAPHIC", MDLongVarGraphicUDB.class);
        heavyweights.put("DBCLOB", MDDBClobUDB.class);
        heavyweights.put("BIGINT", MDBigIntUDB.class);
        heavyweights.put("SMALLINT", MDSmallIntUDB.class);
        heavyweights.put("FLOAT", MDFloat.class);
    }

    @Override
    public MDDataType createType(String name, String size) {
        MDDataType dataType = null;
        if ("BLOB".equals(name)) {
            dataType = new MDBlobUDB();
        } else if ("CLOB".equals(name)) {
            dataType = new MDClobUDB();
        } else if ("DBCLOB".equals(name)) {
            dataType = new MDDBClobUDB();
        } else if ("CHAR".equals(name)) {
            dataType = new MDCharacterUDB();
        } else if ("VARCHAR".equals(name)) {
            dataType = new MDVarcharUDB();
        } else if ("GRAPHIC".equals(name)) {
            dataType = new MDGraphicUDB();
        } else if ("VARGRAPHIC".equals(name)) {
            dataType = new MDVarGraphicUDB();
        } else if ("LONG VARGRAPHIC".equals(name)) {
            dataType = new MDLongVarGraphicUDB();
        } else {
            if ("DECIMAL".equals(name)) {
                dataType = new MDDecimalUDB();
                dataType.setPrecision(MDDataTypeFactory.stringToInt(size));
                return dataType;
            }
            if ("NUMERIC".equals(name)) {
                MDDecimalUDB dec = new MDDecimalUDB();
                dec.setNumericSynonym();
                dec.setPrecision(MDDataTypeFactory.stringToInt(size));
                return dec;
            }
            if ("FLOAT".equals(name)) {
                dataType = new MDFloat();
                dataType.setPrecision(MDDataTypeFactory.stringToInt(size));
                return dataType;
            }
        }
        if (dataType == null) {
            dataType = super.createUDNativeType(name, size);
        } else {
            dataType.setSize(size);
        }
        return dataType;
    }

    @Override
    public MDDataType createType(String name, int precision, int scale) {
        MDDecimalUDB dataType = null;
        if ("DECIMAL".equals(name)) {
            dataType = new MDDecimalUDB();
            dataType.setPrecision(precision);
            dataType.setScale(scale);
            return dataType;
        }
        if ("NUMERIC".equals(name)) {
            MDDecimalUDB dec = new MDDecimalUDB();
            dec.setNumericSynonym();
            dec.setPrecision(precision);
            dec.setScale(scale);
            return dec;
        }
        return super.createUDNativeType(name, precision, scale);
    }

    @Override
    public int getMaxPrecision(String type) {
        String tupper = type.toUpperCase();
        if (tupper.startsWith("DECF")) {
            return 34;
        }
        if (tupper.startsWith("DEC") || tupper.startsWith("NUM")) {
            return 31;
        }
        if (tupper.equals("FLOAT")) {
            return 53;
        }
        return 31;
    }
}

