/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle;

import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDNumberOracle
extends MDPackedSized {
    private String name = "NUMBER";

    public MDNumberOracle() {
        this.precision = 0;
    }

    @Override
    public String getMaxSize() {
        return "31";
    }

    public void setNumericSynonym() {
        this.name = "NUMERIC";
    }

    public void setDecimalSynonym() {
        this.name = "DECIMAL";
    }

    public void setDecSynonym() {
        this.name = "DEC";
    }

    public void setIntegerSynonym() {
        this.name = "INTEGER";
    }

    public void setFloatSynonym() {
        this.name = "FLOAT";
    }

    public void setRealSynonym() {
        this.name = "REAL";
    }

    public void setDoubleSynonym() {
        this.name = "DOUBLE";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setScale(int scale) {
        if (scale >= -84 && scale <= 127) {
            this.scale = scale;
            this.fireSizeChange();
        }
    }

    @Override
    public void setPrecision(int precision) {
        if (precision >= 1 && precision <= 38) {
            this.precision = precision;
            this.precisionStr = String.valueOf(precision);
            this.fireSizeChange();
        }
    }

    @Override
    public MDDataType deepCopy() {
        MDNumberOracle copy = new MDNumberOracle();
        copy.setPrecision(this.getPrecision());
        copy.setScale(this.getScale());
        return copy;
    }
}

