/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIResponsiblePartySet;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.editor.businessinfo.ResponsiblePartyPropertiesDialogEx;

public class BIResponsibleParty
extends DesignObject {
    private String responsibility = "";
    private List contacts = new ArrayList();
    private List elements = new ArrayList();
    private BIResponsibleParty parentParty = null;
    private List subParties = new ArrayList();
    public static final String TYPE_NAME = "ResponsibleParty";

    public BIResponsibleParty(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "RP";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ResponsiblePartyPropertiesDialogEx dialog = new ResponsiblePartyPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getResponsibility() {
        return this.responsibility;
    }

    public void setResponsibility(String responsibility) {
        this.responsibility = responsibility;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void addContact(BIContact contact) {
        if (!this.contacts.contains(contact)) {
            this.contacts.add(contact);
            contact.addResParty(this);
        }
    }

    public void removeContact(BIContact contact) {
        this.contacts.remove(contact);
        contact.removeResParty(this);
    }

    public void clearContacts() {
        for (BIContact contact : this.contacts) {
            contact.removeResParty(this);
        }
        this.contacts.clear();
    }

    public List getElements() {
        return this.elements;
    }

    public void addElement(DesignObject element) {
        if (element instanceof Table ? ((Table)element).isBackup() : element instanceof FKIndexAssociation && ((FKIndexAssociation)element).isBackupFK()) {
            return;
        }
        if (!this.elements.contains(element) && element.getObjectID() != null) {
            DesignObject obj = this.getByID(element);
            if (obj != null) {
                this.elements.remove(obj);
            }
            this.elements.add(element);
        }
    }

    private DesignObject getByID(DesignObject object) {
        for (DesignObject next : this.elements) {
            if (!next.getObjectID().equalsIgnoreCase(object.getObjectID())) continue;
            return next;
        }
        return null;
    }

    public void removeElement(DesignObject element) {
        this.elements.remove(element);
    }

    public BIResponsibleParty getParentParty() {
        return this.parentParty;
    }

    public void setParentParty(BIResponsibleParty parent) {
        if (this.parentParty != parent) {
            if (this.parentParty != null) {
                this.parentParty.removeSubParty(this);
            }
            if (parent != null) {
                parent.addSubParty(this);
            }
            this.parentParty = parent;
            BIResponsiblePartySet docSet = (BIResponsiblePartySet)this.getParent();
            docSet.fireChange(SetEvent.STRUCTURE_CHANGED);
        }
    }

    public List getSubParties() {
        return this.subParties;
    }

    public void setSubParties(List subParties) {
        this.subParties = subParties;
    }

    public void addSubParty(BIResponsibleParty subParty) {
        if (!this.subParties.contains(subParty)) {
            this.subParties.add(subParty);
        }
    }

    public void removeSubParty(BIResponsibleParty subParty) {
        if (this.subParties.contains(subParty)) {
            this.subParties.remove(subParty);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.subParties.size() <= 0;
    }

    @Override
    public int getNumberOfChildren() {
        return this.subParties.size();
    }

    @Override
    public ModelObject getChild(int index) {
        return (BIResponsibleParty)this.subParties.get(index);
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        ((BIResponsibleParty)desObject).setResponsibility(this.getResponsibility());
        Iterator it = this.getElements().iterator();
        while (it.hasNext()) {
            ((BIResponsibleParty)desObject).addElement((DesignObject)it.next());
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "party" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

