/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.businessinfo.EmailPropertiesDialogEx;

public class BIEmail
extends DesignObject {
    private String emailAddress = "";
    private String type = "";
    private List contacts = new ArrayList();
    public static final String TYPE_NAME = "Email";

    public BIEmail(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            EmailPropertiesDialogEx dialog = new EmailPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void addContact(BIContact contact) {
        if (!this.contacts.contains(contact)) {
            this.contacts.add(contact);
        }
    }

    public void removeContact(BIContact contact) {
        this.contacts.remove(contact);
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        ((BIEmail)desObject).setEmailAddress(this.getEmailAddress());
        ((BIEmail)desObject).setType(this.getType());
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "email" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

