/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TSDPPolicy;
import oracle.dbtools.crest.model.TSDPSubPolicySet;
import oracle.dbtools.crest.swingui.ApplicationView;

public class TSDPSubPolicy
extends ModelIDObject {
    public static final String TYPE_NAME = "TSDPSubPolicy";
    private ApplicationView appView;
    private boolean isBeingRemoved = false;
    private TSDPSubPolicySet tsdpSubPolicySet;
    private boolean removed = false;
    private String expression;
    private String maskType = "";
    private MaskTemplate maskTemplate;
    private String propertyDatatype;
    private int propertyLenght;
    private String propertyParentSchema;
    private String propertyParentTable;
    private TSDPPolicy tsdpPolicy;

    public TSDPSubPolicy(ApplicationView appView) {
        this.appView = appView;
        this.createGlobalID();
    }

    @Override
    public ApplicationView getAppView() {
        return this.appView;
    }

    @Override
    public String getOwnerDesignName() {
        return "";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            // empty if block
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public void remove() {
        if (!this.getIsBeingRemoved()) {
            this.setIsBeingRemoved(true);
            if (this.getTSDPSubPolicySet() != null) {
                this.getTSDPSubPolicySet().remove(this);
            }
            if (this.getTsdpPolicy() != null) {
                this.getTsdpPolicy().removeTSDPSubPolicy(this);
            }
            ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
            event.setAffected(this);
            this.fireChange(event);
            event.setAffected(null);
            this.setIsBeingRemoved(false);
            this.removed = true;
            this.closePropertiesDialog();
        }
    }

    protected void setIsBeingRemoved(boolean value) {
        this.isBeingRemoved = value;
    }

    public boolean getIsBeingRemoved() {
        return this.isBeingRemoved;
    }

    public void setTSDPPolicySet(TSDPSubPolicySet set) {
        this.tsdpSubPolicySet = set;
    }

    public TSDPSubPolicySet getTSDPSubPolicySet() {
        return this.tsdpSubPolicySet;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getMaskType() {
        return this.maskType;
    }

    public void setMaskType(String maskType) {
        this.maskType = maskType;
    }

    public MaskTemplate getMaskTemplate() {
        return this.maskTemplate;
    }

    public void setMaskTemplate(MaskTemplate maskTemplate) {
        this.maskTemplate = maskTemplate;
    }

    public String getPropertyDatatype() {
        return this.propertyDatatype;
    }

    public void setPropertyDatatype(String propertyDatatype) {
        this.propertyDatatype = propertyDatatype;
    }

    public int getPropertyLenght() {
        return this.propertyLenght;
    }

    public void setPropertyLenght(int propertyLenght) {
        this.propertyLenght = propertyLenght;
    }

    public String getPropertyParentSchema() {
        return this.propertyParentSchema;
    }

    public void setPropertyParentSchema(String propertyParentSchema) {
        this.propertyParentSchema = propertyParentSchema;
    }

    public String getPropertyParentTable() {
        return this.propertyParentTable;
    }

    public void setPropertyParentTable(String propertyParentTable) {
        this.propertyParentTable = propertyParentTable;
    }

    public void copy(TSDPSubPolicy subPolicy) {
        subPolicy.setName(this.getName());
        subPolicy.setComment(this.getComment());
        subPolicy.setNotes(this.getNotes());
        subPolicy.setExpression(this.getExpression());
        subPolicy.setMaskType(this.getMaskType());
        subPolicy.setMaskTemplate(this.getMaskTemplate());
        subPolicy.setPropertyDatatype(this.getPropertyDatatype());
        subPolicy.setPropertyLenght(this.getPropertyLenght());
        subPolicy.setPropertyParentSchema(this.getPropertyParentSchema());
        subPolicy.setPropertyParentTable(this.getPropertyParentTable());
    }

    public TSDPPolicy getTsdpPolicy() {
        return this.tsdpPolicy;
    }

    public void setTsdpPolicy(TSDPPolicy tsdpPolicy) {
        this.tsdpPolicy = tsdpPolicy;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        ModelIDObject object = null;
        if ("maskTemplate".equalsIgnoreCase(propertyName)) {
            object = this.getAppView().getMaskTemplateSet().getObjectByID(id);
        }
        if (object != null) {
            return object;
        }
        return super.translateIdToObject(propertyName, id);
    }
}

