/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class RHSynonym
extends RowHandler {
    public static final String OBJECT_TYPE = "SYNONYM";

    public RHSynonym(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createSynonym(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createSynonym(VarFileLine line) {
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(site);
        if (storageDesign != null) {
            SynonymDB2 synonym = storageDesign.getSynonymSet().createSynonym();
            synonym.setName(this.getField(line, "SYNONYM_NAME"));
            this.fillOwner(line, synonym);
            String tableKey = this.getField(line, "SYNONYM_TABLE_KEY");
            if (!tableKey.equalsIgnoreCase("0")) {
                TableProxyDB2 tableProxy;
                Table table = (Table)this.getCreatedObject(tableKey);
                if (table != null && (tableProxy = (TableProxyDB2)storageDesign.getTableProxySet().getProxy(table.getObjectID())) != null) {
                    synonym.setTable(tableProxy);
                }
            } else {
                TableViewProxyDB2 viewProxy;
                TableView tableView;
                String tableViewKey = this.getField(line, "SYNONYM_VIEW_KEY");
                if (!tableViewKey.equalsIgnoreCase("0") && (tableView = (TableView)this.getCreatedObject(tableViewKey)) != null && (viewProxy = (TableViewProxyDB2)storageDesign.getTableViewProxySet().getProxy(tableView.getObjectID())) != null) {
                    synonym.setView(viewProxy);
                }
            }
            this.addCreatedObject(this.getField(line, "general_id"), synonym);
            this.removeSelectedLine(line);
        }
    }

    private void fillOwner(VarFileLine line, SynonymDB2 synonym) {
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool == 1000) {
            String ownerName = this.getField(line, "SYNONYM_AUTHID");
            Owner owner = (Owner)this.getAllCreatedObjects().get(ownerName);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)synonym.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(ownerName);
            }
            synonym.setOwner(owner);
        } else {
            String key = this.getField(line, "SYNONYM_AUTHID");
            Owner owner = (Owner)this.getCreatedObject(key);
            synonym.setOwner(owner);
        }
    }
}

