/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.v70.IndexProxyDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHPrimaryKey
extends RowHandler {
    private boolean columnsAreAdded = true;
    public static final String OBJECT_TYPE = "PRIMARY_KEY";
    public static final String OBJECT_TYPE_COOL = "PRIMARY_KEYS";
    private static final String NAME_PRIMARY = "PRIMARY";
    private static final String NAME_PKEY = "PKEY";
    private static final Logger LOGGER = new Logger(RHPrimaryKey.class);

    public RHPrimaryKey(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(line);
            this.addPrimaryKeyLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        list.add(OBJECT_TYPE_COOL);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createPrimaryKey(line, hasMapping);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createPrimaryKey(VarFileLine line, boolean hasMapping) {
        if (!hasMapping) {
            Index index = this.getIndexForPK(line);
            if (index != null) {
                String pkname = this.getField(line, "index_name");
                if (NAME_PRIMARY.equalsIgnoreCase(pkname)) {
                    pkname = NAME_PKEY;
                }
                index.setName(pkname);
                String akPK = this.getField(line, "pk_or_ak");
                if (akPK.equals("1")) {
                    index.makePK();
                } else {
                    index.setUnique(true);
                }
                this.fillElements(line, index);
                this.addCreatedObject(this.getField(line, "general_id"), index);
                String colJCTid = this.getField(line, "PK_COLJCT_5_INDEX");
                List colList = this.getColumnFromSelected(colJCTid);
                int j = 0;
                for (Column column : colList) {
                    if (!index.contains(column)) {
                        index.add(column);
                    }
                    index.moveToIndex(column, j);
                    ++j;
                }
                this.removeSelectedLine(line);
            }
        } else {
            String idPK = this.getField(line, "general_id");
            Index index = (Index)this.getAllCreatedObjects().get(idPK);
            if (index != null && index.isPK()) {
                String pkname = this.getField(line, "index_name");
                if (NAME_PRIMARY.equalsIgnoreCase(pkname)) {
                    pkname = NAME_PKEY;
                }
                index.setName(pkname);
                this.fillElements(line, index);
                String colJCTid = this.getField(line, "PK_COLJCT_5_INDEX");
                List colList = this.getColumnFromSelected(colJCTid);
                int j = 0;
                for (Column column : colList) {
                    if (!index.contains(column)) {
                        index.add(column);
                    }
                    index.moveToIndex(column, j);
                    ++j;
                }
                this.removeSelectedLine(line);
            } else {
                index = this.getIndexForPK(line);
                if (index != null) {
                    index.setName(this.getField(line, "index_name"));
                    String akPK = this.getField(line, "pk_or_ak");
                    if (akPK.equals("1")) {
                        index.makePK();
                    } else {
                        index.setUnique(true);
                    }
                    this.fillElements(line, index);
                    this.addCreatedObject(this.getField(line, "general_id"), index);
                    this.removeSelectedLine(line);
                } else {
                    LOGGER.error("Index is not found in getAllCreatedObjects() for RHPrimaryKey.createPrimaryKey()");
                    this.importLog.addError("Unknown primary key index near " + line);
                }
            }
        }
    }

    private List getColumnFromSelected(String indexId) {
        TreeMap<Integer, Column> map = new TreeMap<Integer, Column>();
        Integer col_pos = new Integer(3);
        ArrayList<ContainedObject> columns = new ArrayList<ContainedObject>();
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            Column selectColumn;
            if (!selectedLine.getType().equalsIgnoreCase("COLJCT") || !this.getField(selectedLine, "COLJCT_5_KEY").equalsIgnoreCase(indexId) || (selectColumn = (Column)this.getCreatedObject(this.getField(selectedLine, "COLJCT_COLUMN_KEY"))) == null) continue;
            String pos = this.getField(selectedLine.getLine(), col_pos);
            int position = Integer.parseInt(pos);
            map.put(new Integer(position), selectColumn);
        }
        for (Integer key : map.keySet()) {
            ContainedObject col = (ContainedObject)map.get(key);
            if (col == null) continue;
            columns.add(col);
        }
        return columns;
    }

    private Index getIndexForPK(VarFileLine line) {
        this.columnsAreAdded = true;
        Index index = null;
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool == 1000) {
            String keyIndex = this.getField(line, "primarykey_index_id").trim();
            if (keyIndex.equals("0")) {
                String keyColumnSet = this.getField(line, "primarykey_column_set").trim();
                String keyTable = null;
                for (VarFileLine lineSelected : this.getAllSelectedLines()) {
                    if (!lineSelected.getType().equals("COLUMN_SET") || !this.getField(lineSelected, "general_id").trim().equals(keyColumnSet)) continue;
                    keyTable = this.getField(lineSelected, "COLUMNSET_table").trim();
                }
                Table table = (Table)this.getAllCreatedObjects().get(keyTable);
                List columns = this.getColumnsToPutOnIndex(line);
                if (this.columnsAreAdded && table != null) {
                    index = table.createIndex();
                    for (Column column : columns) {
                        index.add(column);
                    }
                }
            } else {
                index = (Index)this.getAllCreatedObjects().get(keyIndex);
            }
        } else {
            String indexKey = this.getField(line, "primarykey_index_id").trim();
            if (indexKey.equals("0")) {
                String keyTable = this.getField(line, "primarykey_cool_tableid");
                Table table = (Table)this.getAllCreatedObjects().get(keyTable);
                List columns = this.getColumnsToPutOnIndex(line);
                if (this.columnsAreAdded && table != null) {
                    index = table.createIndex();
                    for (Column column : columns) {
                        index.add(column);
                    }
                }
            } else {
                index = (Index)this.getAllCreatedObjects().get(indexKey);
            }
        }
        return index;
    }

    private List getColumnsToPutOnIndex(VarFileLine line) {
        ArrayList<Column> listColumn = new ArrayList<Column>();
        String keyColumnSet = this.getField(line, "primarykey_coljct5");
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool == 1000) {
            for (VarFileLine selectedLine : this.getAllSelectedLines()) {
                String key;
                if (!selectedLine.getType().equals("COLUMN_SETTABLE_CO") || !(key = this.getField(selectedLine, "general_id").trim()).equals(keyColumnSet)) continue;
                String keyColumn = this.getField(selectedLine, "COLUMNSETTABLE_TABLECOLUMN");
                Column column = (Column)this.getAllCreatedObjects().get(keyColumn);
                if (column != null) {
                    listColumn.add(column);
                    continue;
                }
                this.columnsAreAdded = false;
            }
        } else {
            for (VarFileLine selectedLine : this.getAllSelectedLines()) {
                String key;
                if (!selectedLine.getType().equals("COLJCT") || !(key = this.getField(selectedLine, "COLJCT_5_KEY").trim()).equals(keyColumnSet)) continue;
                String keyColumn = this.getField(selectedLine, "COLJCT_COLUMN_KEY");
                Column column = (Column)this.getAllCreatedObjects().get(keyColumn);
                if (column != null) {
                    listColumn.add(column);
                    continue;
                }
                this.columnsAreAdded = false;
            }
        }
        return listColumn;
    }

    protected void fillElements(VarFileLine line, Index index) {
        index.makeValidPKIfNotEmpty();
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(site);
        IndexProxyDB2v70 indexProxy = (IndexProxyDB2v70)storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        if (indexProxy != null) {
            indexProxy.setNoIntegrity(true);
            try {
                int generate = Integer.parseInt(this.getField(line, "primarykey_generate"));
                if (generate == 0) {
                    indexProxy.setGeneratedInRDBMS(false);
                } else if (generate == 1) {
                    indexProxy.setGeneratedInRDBMS(true);
                }
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong Format in RHPrimaryKey.createPrimaryKey : ");
                message.append(line.getLine());
                LOGGER.error(message.toString(), e);
                this.importLog.addWarning("Wrong primary key syntax near " + line);
            }
        }
    }
}

