/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SequenceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSequencesUDBv81
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SEQUENCES";
    private static final Logger LOGGER = new Logger(MOHSequencesUDBv81.class);

    public MOHSequencesUDBv81(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        if (storageDesign != null && storageDesign instanceof StorageDesignUDBv81) {
            StorageDesignUDBv81 storage = (StorageDesignUDBv81)storageDesign;
            for (SchemaUDBv81 schema : storage.getSchemaSet()) {
                this.initSequences(sqlConnection, storage, schema);
            }
        }
    }

    private void initSequences(Connection sqlConnection, StorageDesignUDBv81 storage, SchemaUDBv81 schema) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT seqname,s.increment, s.start, s.maxvalue,  ");
            buffer.append("s.minvalue, s.cycle, s.cache, s.order ");
            buffer.append("from  sysibm.SYSSEQUENCES s ");
            buffer.append("WHERE seqschema = '");
            buffer.append(schema.getName()).append("'");
            buffer.append(" and seqtype = 'S'");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHSequencesUDBv81.initSequences():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String seqName = rs.getString(1);
                int increment = rs.getInt(2);
                int startWith = rs.getInt(3);
                String maxValue = rs.getString(4);
                String minValue = rs.getString(5);
                String cycle = rs.getString(6);
                int cache = rs.getInt(7);
                String order = rs.getString(8);
                SequenceUDBv81 sequence = (SequenceUDBv81)storage.getSequenceSet().createSequence();
                sequence.setName(seqName);
                this.stampModelObject((ModelObject)sequence, schema.getName(), seqName);
                sequence.setIncrementBy(increment);
                sequence.setStartWith(startWith);
                sequence.setMaxValue(maxValue);
                sequence.setMinValue(minValue);
                sequence.setCache(cache);
                sequence.setSchema(schema);
                sequence.setOwner(schema.getOwner());
                if ("Y".equalsIgnoreCase(cycle)) {
                    sequence.setCycle("YES");
                }
                if (!"Y".equalsIgnoreCase(order)) continue;
                sequence.setOrder("YES");
            }
            rs.close();
        }
        statement.close();
    }
}

