/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHHierarchyUDBv81
extends AbstractMOHandler {
    private static final Logger LOGGER = new Logger(MOHHierarchyUDBv81.class);

    public MOHHierarchyUDBv81(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        if (storageDesign != null && storageDesign instanceof StorageDesignUDBv81) {
            StorageDesignUDBv81 storage = (StorageDesignUDBv81)storageDesign;
            Iterator it = storage.getSchemaSet().iterator();
            while (it.hasNext()) {
                Statement statement = sqlConnection.createStatement();
                SchemaUDBv81 schema = (SchemaUDBv81)it.next();
                ResultSet rs = null;
                try {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("select metatype,sub_name,super_schema,super_name ");
                    buffer.append(" from syscat.hierarchies ");
                    buffer.append("where metatype in ('U','W') and sub_schema = '").append(schema.getName()).append("'");
                    rs = statement.executeQuery(buffer.toString());
                }
                catch (Exception e) {
                    LOGGER.error("MOHHierarchyUDBv81.generate(): ", e);
                }
                if (rs != null) {
                    while (rs.next()) {
                        RelationalObjectProxy tp;
                        String type = rs.getString(1);
                        String name = rs.getString(2);
                        String superSchema = rs.getString(3);
                        String superName = rs.getString(4);
                        ContainerObject table = null;
                        ContainerObject superTable = null;
                        if (type.equalsIgnoreCase("W")) {
                            tp = this.getStorageDesign().getTableViewProxySet().getBySchemaAndName(schema.getName(), name);
                            if (tp != null) {
                                table = (ContainerObject)tp.getObject();
                            }
                            if ((tp = this.getStorageDesign().getTableViewProxySet().getBySchemaAndName(superSchema, superName)) != null) {
                                superTable = (ContainerObject)tp.getObject();
                            }
                        } else {
                            tp = this.getStorageDesign().getTableProxySet().getByUserSchemaAndName(schema.getName(), name);
                            if (tp != null) {
                                table = (ContainerObject)tp.getObject();
                            }
                            if ((tp = this.getStorageDesign().getTableProxySet().getByUserSchemaAndName(superSchema, superName)) != null) {
                                superTable = (ContainerObject)tp.getObject();
                            }
                        }
                        if (superTable == null || table == null) continue;
                        ContainerView parentTV = (ContainerView)superTable.getTopView();
                        ContainerView childTV = (ContainerView)table.getTopView();
                        if (parentTV == null || childTV == null) continue;
                        TypeSubstitution ts = this.getRelationalDesign().createTypeSubstitution();
                        ts.setChildCV(childTV);
                        ts.setParentCV(parentTV);
                        ts.addToAllDPVs();
                    }
                    rs.close();
                }
                statement.close();
            }
        }
    }
}

