/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTypeIncompleteUDB
extends AbstractMOHandler {
    private Map selectedTypes = new TreeMap();
    private static List types;
    public static final String OBJECT_TYPE = "TYPE";
    private static final Logger LOGGER;

    public MOHTypeIncompleteUDB(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        DBObject dbo;
        DBObject dbo2;
        int i;
        this.selectedTypes = new TreeMap();
        types = new ArrayList();
        TreeMap additionalTypes = new TreeMap();
        ArrayList<DBObject> tab_view_types = new ArrayList<DBObject>();
        for (i = 0; i < selectedObjects.size(); ++i) {
            dbo2 = (DBObject)selectedObjects.get(i);
            if (OBJECT_TYPE.equalsIgnoreCase(dbo2.getType())) {
                types.add(dbo2);
                this.selectedTypes.put(dbo2.toString(), dbo2);
            }
            if ("TYPED TABLE".equalsIgnoreCase(dbo2.getType())) {
                this.addAdditionalType(additionalTypes, dbo2);
            }
            if (!"VIEW".equalsIgnoreCase(dbo2.getType())) continue;
            tab_view_types.add(dbo2);
        }
        this.generateAdditionalTableTypes(sqlConnection, additionalTypes);
        this.generateAdditionalColumnTypes(sqlConnection, additionalTypes);
        for (i = 0; i < tab_view_types.size(); ++i) {
            DBObject dbotv = (DBObject)tab_view_types.get(i);
            dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dbotv.getTypeName(), OBJECT_TYPE, dbotv.getTypeOwner());
            dbo.setSuperTypeOwner(dbotv.getSuperTypeOwner());
            dbo.setSuperTypeName(dbotv.getSuperTypeName());
            if (dbo.toString() == null || this.selectedTypes.containsKey(dbo.toString())) continue;
            types.add(dbo);
            this.selectedTypes.put(dbo.toString(), dbo);
        }
        for (int step = 0; step < types.size(); ++step) {
            dbo2 = (DBObject)types.get(step);
            this.addSuperTypes(sqlConnection, dbo2);
            this.getAdditionalAttributeTypes(sqlConnection, dbo2);
            this.generateAdditionalParameterAndResultTypes(sqlConnection, dbo2);
        }
        for (int i2 = 0; i2 < types.size(); ++i2) {
            dbo = (DBObject)types.get(i2);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType()) || !this.createStructuredType(dbo) || !selectedObjects.contains(dbo)) continue;
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private boolean createStructuredType(DBObject dbo) {
        String name = dbo.getName();
        String schemaName = dbo.getSchema();
        StructuredType type = this.getDesign().getDataTypesDesign().createStructuredType();
        type.setName(name);
        this.stampModelObject(type, dbo);
        StorageDesignUDB storage = (StorageDesignUDB)this.getStorageDesign();
        StructuredTypeProxyUDB proxy = (StructuredTypeProxyUDB)storage.getStructuredTypeProxySet().getProxy(type.getObjectID());
        if (proxy != null) {
            proxy.setName(name);
            SchemaUDB schema = (SchemaUDB)storage.getSchemaSet().getByName(schemaName);
            if (schema != null) {
                proxy.setSchema(schema);
            }
        }
        return true;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select a.typename, a.metatype,b.super_schema,b.super_name,b.root_schema,b.root_name ");
                buffer.append("FROM syscat.DATATYPES a left join syscat.hierarchies b ");
                buffer.append("on a.typename = b.sub_name ");
                buffer.append("and a.typeschema = b.sub_schema ");
                buffer.append("WHERE a.metatype in ('T','R') and a.TYPESCHEMA = '");
                buffer.append(dboNext.getName()).append("' ");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTypeIncompleteUDB.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    DBObject dboDatatype;
                    String typeName = rs.getString(1);
                    String metatype = rs.getString(2);
                    if (metatype.equalsIgnoreCase("R")) {
                        dboDatatype = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), typeName, OBJECT_TYPE, dboNext.getName(), "Structured type");
                        String superTypeOwner = rs.getString(3);
                        String superTypeName = rs.getString(4);
                        dboDatatype.setSuperTypeOwner(superTypeOwner);
                        dboDatatype.setSuperTypeName(superTypeName);
                    } else {
                        dboDatatype = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), typeName, "DATATYPE", dboNext.getName(), "Distinct type");
                    }
                    list.add(dboDatatype);
                }
                rs.close();
            }
            statement.close();
        }
        return list;
    }

    private void addSuperTypes(Connection sqlConnection, DBObject dbo) throws SQLException {
        DBObject superType;
        String superTypeOwner = dbo.getSuperTypeOwner();
        String superTypeName = dbo.getSuperTypeName();
        if (superTypeName != null && !superTypeName.equals("") && !this.selectedTypes.containsKey((superType = new DBObject(false, superTypeName, OBJECT_TYPE, superTypeOwner)).toString())) {
            types.add(superType);
            this.selectedTypes.put(superType.toString(), superType);
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select a.typename, a.metatype,b.super_schema,b.super_name,b.root_schema,b.root_name ");
                buffer.append("FROM syscat.DATATYPES a left join syscat.hierarchies b ");
                buffer.append("on a.typename = b.sub_name ");
                buffer.append("and a.typeschema = b.sub_schema ");
                buffer.append("WHERE a.metatype = 'R' and a.TYPESCHEMA = '");
                buffer.append(superTypeOwner).append("' ");
                buffer.append("and a.typename = '");
                buffer.append(superTypeName).append("' ");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTypeIncompleteUDB.extract(): " + e.getMessage());
            }
            if (rs != null) {
                String metatype;
                if (rs.next() && (metatype = rs.getString(2)).equalsIgnoreCase("R")) {
                    String superOwner = rs.getString(3);
                    String superName = rs.getString(4);
                    superType.setSuperTypeOwner(superOwner);
                    superType.setSuperTypeName(superName);
                }
                rs.close();
            }
            statement.close();
        }
    }

    private void addAdditionalType(Map additionalTypes, DBObject dbo) {
        if (!additionalTypes.containsKey(dbo.getSchema())) {
            additionalTypes.put(dbo.getSchema(), '\'' + dbo.getName() + '\'');
        } else {
            String tableNames = (String)additionalTypes.get(dbo.getSchema());
            tableNames = tableNames + ',' + '\'' + dbo.getName() + '\'';
            additionalTypes.put(dbo.getSchema(), tableNames);
        }
    }

    private void generateAdditionalTableTypes(Connection sqlConnection, Map additionalTypes) throws SQLException {
        for (String schemaName : additionalTypes.keySet()) {
            String tableNames = (String)additionalTypes.get(schemaName);
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select distinct a.rowtypeschema, a.rowtypename, b.super_schema, b.super_name ");
                buffer.append(" from syscat.tables a left join syscat.hierarchies b ");
                buffer.append("  on a.rowtypename = b.sub_name ");
                buffer.append("  and a.rowtypeschema = b.sub_schema  ");
                buffer.append(" where tabschema = ").append('\'').append(schemaName).append('\'').append(' ').append("AND");
                buffer.append(" a.tabname in ").append('(').append(tableNames).append(')');
                buffer.append(' ').append("AND");
                buffer.append(" rowtypename is not null");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (Exception e) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.generateAdditionalTableTypes():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    DBObject superType;
                    String owner = rs.getString(1);
                    String name = rs.getString(2);
                    String superTypeOwner = rs.getString(3);
                    String superTypeName = rs.getString(4);
                    DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), name, OBJECT_TYPE, owner);
                    dbo.setSuperTypeOwner(superTypeOwner);
                    dbo.setSuperTypeName(superTypeName);
                    if (!this.selectedTypes.containsKey(dbo.toString())) {
                        types.add(dbo);
                        this.selectedTypes.put(dbo.toString(), dbo);
                    }
                    if (superTypeName == null || superTypeName.equals("") || this.selectedTypes.containsKey((superType = new DBObject(false, superTypeName, OBJECT_TYPE, superTypeOwner)).toString())) continue;
                    types.add(superType);
                    this.selectedTypes.put(superType.toString(), superType);
                }
                rs.close();
            }
            statement.close();
        }
    }

    private void generateAdditionalColumnTypes(Connection sqlConnection, Map additionalTypes) throws SQLException {
        for (String schemaName : additionalTypes.keySet()) {
            String tableNames = (String)additionalTypes.get(schemaName);
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select distinct ");
                buffer.append("a.typeschema, a.typename,b.super_schema,b.super_name ");
                buffer.append(" from syscat.columns a, syscat.DATATYPES c left join syscat.hierarchies b ");
                buffer.append("  on  c.typename = b.sub_name ");
                buffer.append("  and c.typeschema = b.sub_schema ");
                buffer.append("  and c.typeschema = b.sub_schema ");
                buffer.append("where a.TABSCHEMA = ").append('\'').append(schemaName).append('\'').append(' ').append("AND");
                buffer.append(" a.tabname in ").append('(').append(tableNames).append(')');
                buffer.append(' ').append("AND");
                buffer.append(" a.typename <>'REFERENCE' ");
                buffer.append("  and c.metatype = 'R' ");
                buffer.append("  and a.typename = c.typename and a.typeschema = c.typeschema ");
                buffer.append("union ");
                buffer.append("select distinct ");
                buffer.append("a.target_typeschema, a.target_typename,b.super_schema,b.super_name ");
                buffer.append(" from syscat.columns a, syscat.DATATYPES c left join syscat.hierarchies b ");
                buffer.append("  on  c.typename = b.sub_name ");
                buffer.append("  and c.typeschema = b.sub_schema ");
                buffer.append("  and c.typeschema = b.sub_schema ");
                buffer.append("where a.TABSCHEMA = ").append('\'').append(schemaName).append('\'').append(' ').append("AND");
                buffer.append(" a.tabname in ").append('(').append(tableNames).append(')');
                buffer.append(' ').append("AND");
                buffer.append("  a.typename = 'REFERENCE' ");
                buffer.append("  and c.metatype = 'R' ");
                buffer.append("  and a.target_typename = c.typename and a.target_typeschema = c.typeschema ");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (Exception e) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.generateAdditionalColumnTypes():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(2);
                    String owner = rs.getString(1);
                    String superTypeOwner = rs.getString(3);
                    String superTypeName = rs.getString(4);
                    DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), name, OBJECT_TYPE, owner);
                    dbo.setSuperTypeOwner(superTypeOwner);
                    dbo.setSuperTypeName(superTypeName);
                    if (this.selectedTypes.containsKey(dbo.toString())) continue;
                    types.add(dbo);
                    this.selectedTypes.put(dbo.toString(), dbo);
                }
                rs.close();
            }
            statement.close();
        }
    }

    private void getAdditionalAttributeTypes(Connection sqlConnection, DBObject dbo) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select distinct a.attr_typeschema as attr_typeschema, ");
            buffer.append("  a.attr_typename as attr_typename,b.super_schema,b.super_name ");
            buffer.append(" from syscat.attributes a, syscat.DATATYPES c left join syscat.hierarchies b ");
            buffer.append("  on  c.typename = b.sub_name ");
            buffer.append("  and c.typeschema = b.sub_schema ");
            buffer.append(" where a.TYPESCHEMA = ").append('\'').append(dbo.getSchema()).append('\'').append(' ').append("AND");
            buffer.append(" a.TYPENAME = ").append('\'').append(dbo.getName()).append('\'');
            buffer.append("  and a.attr_typename <> 'REFERENCE' ");
            buffer.append("  and a.attr_typename = c.typename and a.attr_typeschema = c.typeschema ");
            buffer.append("  and c.metatype = 'R' ");
            buffer.append("union ");
            buffer.append("select distinct a.target_typeschema as attr_typeschema, ");
            buffer.append("  a.target_typename as attr_typename,b.super_schema,b.super_name ");
            buffer.append(" from syscat.attributes a, syscat.DATATYPES c left join syscat.hierarchies b ");
            buffer.append("  on  c.typename = b.sub_name ");
            buffer.append("  and c.typeschema = b.sub_schema ");
            buffer.append(" where a.TYPESCHEMA = ").append('\'').append(dbo.getSchema()).append('\'').append(' ').append("AND");
            buffer.append(" a.TYPENAME = ").append('\'').append(dbo.getName()).append('\'');
            buffer.append("  and a.attr_typename = 'REFERENCE' ");
            buffer.append("  and a.target_typename = c.typename and a.target_typeschema = c.typeschema ");
            buffer.append("  and c.metatype = 'R' ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            LOGGER.error("MOHTypeIncompleteOraclev9i.getAttributeType():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                DBObject superType;
                String owner = rs.getString(1);
                String typeName = rs.getString(2);
                String superTypeOwner = rs.getString(3);
                String superTypeName = rs.getString(4);
                DBObject newType = new DBObject(false, typeName, OBJECT_TYPE, owner);
                newType.setSuperTypeOwner(superTypeOwner);
                newType.setSuperTypeName(superTypeName);
                if (!this.selectedTypes.containsKey(newType.toString())) {
                    types.add(newType);
                    this.selectedTypes.put(newType.toString(), newType);
                }
                if (superTypeName == null || superTypeName.equals("") || this.selectedTypes.containsKey((superType = new DBObject(false, superTypeName, OBJECT_TYPE, superTypeOwner)).toString())) continue;
                types.add(superType);
                this.selectedTypes.put(superType.toString(), superType);
            }
            rs.close();
        }
        statement.close();
    }

    private void generateAdditionalParameterAndResultTypes(Connection sqlConnection, DBObject dbo) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("with functions (funcname, funcschema,subject_typeschema, subject_typename) ");
            buffer.append("as ( ");
            buffer.append("select distinct funcname, funcschema,subject_typeschema, subject_typename ");
            buffer.append("from syscat.functions  ");
            buffer.append("where effect not in ('MU','OB','CN') and method = 'Y' ");
            buffer.append("and subject_typeschema =").append('\'').append(dbo.getSchema()).append('\'').append(' ').append("AND");
            buffer.append(" subject_typename = ").append('\'').append(dbo.getName()).append('\'').append(" ) ");
            buffer.append("select distinct a.typeschema as typeschema, a.typename as typename,b.super_schema,b.super_name ");
            buffer.append(" from functions f, ");
            buffer.append("  syscat.funcparms a, syscat.DATATYPES c left join syscat.hierarchies b ");
            buffer.append("  on  c.typename = b.sub_name ");
            buffer.append("  and c.typeschema = b.sub_schema ");
            buffer.append(" where ");
            buffer.append("  a.typename = c.typename and a.typeschema = c.typeschema ");
            buffer.append("  and c.metatype = 'R' ");
            buffer.append("  and a.typename <> 'REFERENCE' ");
            buffer.append("  and f.funcname = a.funcname and f.funcschema = a.funcschema ");
            buffer.append("union ");
            buffer.append("select distinct a.target_typeschema as typeschema, a.target_typename as typename,b.super_schema,b.super_name ");
            buffer.append(" from functions f,syscat.funcparms a, syscat.DATATYPES c left join syscat.hierarchies b ");
            buffer.append("  on  c.typename = b.sub_name ");
            buffer.append("  and c.typeschema = b.sub_schema ");
            buffer.append(" where ");
            buffer.append("  a.typename = 'REFERENCE' ");
            buffer.append("  and a.target_typename = c.typename and a.target_typeschema = c.typeschema ");
            buffer.append("  and c.metatype = 'R' ");
            buffer.append("  and f.funcname = a.funcname and f.funcschema = a.funcschema ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            LOGGER.error("MOHTypeIncompleteOraclev9i.getParameterType():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                DBObject superType;
                String owner = rs.getString(1);
                String typeName = rs.getString(2);
                String superTypeOwner = rs.getString(3);
                String superTypeName = rs.getString(4);
                DBObject newType = new DBObject(false, typeName, OBJECT_TYPE, owner);
                newType.setSuperTypeOwner(superTypeOwner);
                newType.setSuperTypeName(superTypeName);
                if (!this.selectedTypes.containsKey(newType.toString())) {
                    types.add(newType);
                    this.selectedTypes.put(newType.toString(), newType);
                }
                if (superTypeName == null || superTypeName.equals("") || this.selectedTypes.containsKey((superType = new DBObject(false, superTypeName, OBJECT_TYPE, superTypeOwner)).toString())) continue;
                types.add(superType);
                this.selectedTypes.put(superType.toString(), superType);
            }
            rs.close();
        }
        statement.close();
    }

    static {
        LOGGER = new Logger(MOHTypeIncompleteUDB.class);
    }
}

