/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHOwnerUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "OWNER";
    private static List schemas = new ArrayList();
    private static final Logger LOGGER = new Logger(MOHOwnerUDB.class);

    public MOHOwnerUDB(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    public static List getSchemas() {
        return schemas;
    }

    public static void setSchemas(List schemas) {
        MOHOwnerUDB.schemas = schemas;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            StorageDesignUDB storage;
            OwnerUDB owner;
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign != null && storageDesign instanceof StorageDesignUDB && (owner = (OwnerUDB)(storage = (StorageDesignUDB)storageDesign).getOwnerSet().getByName(name.trim())) == null) {
                owner = (OwnerUDB)storage.getOwnerSet().createElement(null);
                owner.setName(name.trim());
                this.stampModelObject(owner, dbo);
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        this.initSchema(sqlConnection, schemas);
    }

    private void initSchema(Connection sqlConnection, List schemas) throws SQLException {
        for (int i = 0; i < schemas.size(); ++i) {
            DBObject dbo = (DBObject)schemas.get(i);
            if (!dbo.isSelected()) continue;
            this.createSchema(sqlConnection, dbo.getName());
        }
    }

    private void createSchema(Connection sqlConnection, String name) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT  schemaname,definer,remarks  ");
            buffer.append("from syscat.schemata ");
            buffer.append("WHERE schemaname = '");
            buffer.append(name).append("'");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHOwnerUDB.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String ownerName = rs.getString(2);
                String comment = rs.getString(3);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB)) continue;
                StorageDesignUDB storage = (StorageDesignUDB)storageDesign;
                SchemaUDB schema = storage.getSchemaSet().createSchema();
                schema.setName(name);
                this.stampModelObject((ModelObject)schema, "", name);
                OwnerUDB owner = (OwnerUDB)storage.getOwnerSet().getByName(ownerName);
                schema.setOwner(owner);
                schema.setCommentInRDBMS(comment);
            }
            rs.close();
        }
        statement.close();
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        MOHOwnerUDB.schemas = schemas;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT  distinct grantee group  ");
            buffer.append("from syscat.schemaauth ");
            buffer.append("WHERE granteetype = 'U' ");
            buffer.append("union ");
            buffer.append("SELECT  distinct grantee group  ");
            buffer.append("from syscat.tabauth ");
            buffer.append("WHERE granteetype = 'U' ");
            buffer.append("union ");
            buffer.append("SELECT  distinct case owner when 'SYSIBM' then definer   ");
            buffer.append("else owner  end as owner ");
            buffer.append("from SYSCAT.schemata ");
            buffer.append("WHERE schemaname not like 'SYS%' ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHOwnerUDB.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String dimName = rs.getString(1);
                DBObject dboDim = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dimName, OBJECT_TYPE);
                list.add(dboDim);
            }
            rs.close();
        }
        statement.close();
        return list;
    }
}

