/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.udb.MOHAliasUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHBufferpoolUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHDatatypeUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHForeignKeyUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHOwnerUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHPartitionGroupUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHPrivilegesUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHProcedureUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHSchemaPrivilegesUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHSummerTableUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTableUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTablespaceUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTypeIncompleteUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTypeUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHUserGroupUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHViewUDB;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHForeignKeyUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHHierarchyUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHPartitionGroupUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHSequencesUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHStagingTableUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHSummerTableUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHTableUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHTablespaceUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHTypedTableUDBv81;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class DBMExtractionHandlerUDB
extends AbstractDBMExtractionHandler {
    private static DBMExtractionHandlerUDB dbmExtractionHandler;
    private List mohObjectsv71 = null;
    private List mohObjectsv81 = null;
    private static final Logger LOGGER;

    public DBMExtractionHandlerUDB(StorageDesign sd) {
        super(sd);
    }

    public static AbstractDBMExtractionHandler getInstance() {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerUDB(null);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
    }

    @Override
    public List getMOHObjects(Connection conn) {
        if (conn != null) {
            this.init(conn);
        }
        switch (this.dbMajorVersion) {
            case 7: {
                return this.getMOHObjectsv71();
            }
            case 8: {
                return this.getMOHObjectsv81();
            }
            case 9: {
                return this.getMOHObjectsv9();
            }
        }
        return this.getMOHObjectsv81();
    }

    public List getMOHObjectsv71() {
        if (this.mohObjectsv71 == null) {
            this.mohObjectsv71 = new ArrayList();
            this.mohObjectsv71.add(new MOHUserGroupUDB(this));
            this.mohObjectsv71.add(new MOHOwnerUDB(this));
            this.mohObjectsv71.add(new MOHSchemaPrivilegesUDB(this));
            this.mohObjectsv71.add(new MOHTypeIncompleteUDB(this));
            this.mohObjectsv71.add(new MOHDatatypeUDB(this));
            this.mohObjectsv71.add(new MOHTypeUDB(this));
            this.mohObjectsv71.add(new MOHBufferpoolUDB(this));
            this.mohObjectsv71.add(new MOHPartitionGroupUDB(this));
            this.mohObjectsv71.add(new MOHTablespaceUDB(this));
            this.mohObjectsv71.add(new MOHTableUDB(this));
            this.mohObjectsv71.add(new MOHSummerTableUDB(this));
            this.mohObjectsv71.add(new MOHForeignKeyUDB(this));
            this.mohObjectsv71.add(new MOHViewUDB(this));
            this.mohObjectsv71.add(new MOHAliasUDB(this));
            this.mohObjectsv71.add(new MOHProcedureUDB(this));
            this.mohObjectsv71.add(new MOHPrivilegesUDB(this));
        }
        return this.mohObjectsv71;
    }

    public List getMOHObjectsv81() {
        if (this.mohObjectsv81 == null) {
            this.mohObjectsv81 = new ArrayList();
            this.mohObjectsv81.add(new MOHUserGroupUDB(this));
            this.mohObjectsv81.add(new MOHOwnerUDB(this));
            this.mohObjectsv81.add(new MOHSchemaPrivilegesUDB(this));
            this.mohObjectsv81.add(new MOHTypeIncompleteUDB(this));
            this.mohObjectsv81.add(new MOHDatatypeUDB(this));
            this.mohObjectsv81.add(new MOHTypeUDB(this));
            this.mohObjectsv81.add(new MOHBufferpoolUDB(this));
            this.mohObjectsv81.add(new MOHPartitionGroupUDBv81(this));
            this.mohObjectsv81.add(new MOHTablespaceUDBv81(this));
            this.mohObjectsv81.add(new MOHTableUDBv81(this));
            this.mohObjectsv81.add(new MOHSummerTableUDBv81(this));
            this.mohObjectsv81.add(new MOHStagingTableUDBv81(this));
            this.mohObjectsv81.add(new MOHTypedTableUDBv81(this));
            this.mohObjectsv81.add(new MOHForeignKeyUDBv81(this));
            this.mohObjectsv81.add(new MOHViewUDB(this));
            this.mohObjectsv81.add(new MOHAliasUDB(this));
            this.mohObjectsv81.add(new MOHProcedureUDB(this));
            this.mohObjectsv81.add(new MOHPrivilegesUDB(this));
            this.mohObjectsv81.add(new MOHSequencesUDBv81(this));
            this.mohObjectsv81.add(new MOHHierarchyUDBv81(this));
        }
        return this.mohObjectsv81;
    }

    public List getMOHObjectsv9() {
        return this.getMOHObjectsv81();
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 7: {
                return this.getDesign().getRDBMSSiteSet().get(StorageDesignUDBv71.RDBMS_TYPE);
            }
            case 8: {
                return this.getDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
            }
            case 9: {
                return this.getDesign().getRDBMSSiteSet().get(StorageDesignUDBv9.RDBMS_TYPE);
            }
        }
        return this.getDesign().getRDBMSSiteSet().get(StorageDesignUDBv9.RDBMS_TYPE);
    }

    @Override
    public List getSchemas(Connection conn) throws Exception {
        ArrayList list = new ArrayList();
        if (conn != null) {
            DatabaseMetaData dbmd = conn.getMetaData();
            try {
                int ind;
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = -1;
                try {
                    this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (this.dbMajorVersion == -1 && (ind = this.dbProductVersion.indexOf(46)) > 0) {
                    String ver = this.dbProductVersion.substring(0, ind);
                    try {
                        this.dbMajorVersion = Integer.parseInt(ver);
                    }
                    catch (Exception e) {
                        this.dbMajorVersion = 9;
                    }
                }
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
            return this.getUDBSchemas(conn);
        }
        return list;
    }

    public List getUDBSchemas(Connection conn) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = conn.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select schemaname,case owner  ");
            buffer.append("when 'SYSIBM' then definer ");
            buffer.append("else owner end as owner ");
            buffer.append("FROM SYSCAT.schemata ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("DBMExtractionHandlerUDB.getSchemas(): ", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1).trim();
                DBObject dbo = new DBObject(false, name);
                list.add(dbo);
            }
            rs.close();
        }
        return list;
    }

    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        if (this.storageDesign == null) {
            this.storageDesign = ApplicationView.getInstance().getCurrentDesign().getRelationalDesign().getStorageDesign();
        }
        if (!this.isNullStorageDesign(this.storageDesign)) {
            super.generateDesign(conn, selectedObjects, importLog, monitor);
        }
    }

    static {
        LOGGER = new Logger(DBMExtractionHandlerUDB.class);
    }
}

