/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.MOHForeignKey;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBMExtractionHandlerSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHForeignKeySQLServerv2k5
extends MOHForeignKey {
    private static final Logger LOGGER = new Logger(MOHForeignKeySQLServerv2k5.class);

    public MOHForeignKeySQLServerv2k5(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesignSqlServer storage = (StorageDesignSqlServer)this.getStorageDesign();
        String defDBName = this.getDesign().getAppView().getSettings().getDefaultSqlServerDatabase();
        if (((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).isDefaultDBImpoted()) {
            defDBName = "";
        }
        for (DataBaseSqlServer db : storage.getDataBaseSet()) {
            if (db.getName().equalsIgnoreCase("[None]") || db.getName().equalsIgnoreCase(defDBName)) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("USE").append(' ');
                buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
                buffer.append("SELECT").append(' ');
                buffer.append("o").append('.');
                buffer.append("ID").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.');
                buffer.append("NAME").append(' ');
                buffer.append(',').append(' ');
                buffer.append("t").append('.');
                buffer.append("NAME").append(' ');
                buffer.append("tablename").append(' ');
                buffer.append(',').append(' ');
                buffer.append("t").append('.');
                buffer.append("ID").append(' ');
                buffer.append("tableid").append(' ');
                buffer.append(',').append(' ');
                buffer.append("not_for_replication = ObjectProperty(o.id, 'CnstIsNotRepl')").append(' ');
                buffer.append(',').append(' ');
                buffer.append("is_delete_cascade = ObjectProperty(o.id, 'CnstIsDeleteCascade')").append(' ');
                buffer.append(',').append(' ');
                buffer.append("is_upd_cascade = ObjectProperty(o.id, 'CnstIsUpdateCascade')").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHandlerSqlServer.getFormattedName(db)).append('.').append("dbo.sysobjects o").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHandlerSqlServer.getFormattedName(db)).append('.').append("dbo.sysobjects t").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("o.xtype = 'F'").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o.parent_obj").append(' ').append('=').append(' ').append("t.id").append(' ');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHForeignKeySqlServer.initForeignKeys():", e);
            }
            ArrayList<Properties> list = new ArrayList<Properties>();
            if (rs != null) {
                while (rs.next()) {
                    String constrId = rs.getString(1);
                    String fkName = rs.getString(2);
                    String tableName = rs.getString(3);
                    int notForReplication = rs.getInt(5);
                    int isDeleteCascade = rs.getInt(6);
                    int isUpdateCascade = rs.getInt(7);
                    Properties props = new Properties();
                    props.setProperty("constrId", constrId);
                    props.setProperty("fkName", fkName);
                    props.setProperty("tableName", tableName);
                    props.setProperty("notForReplication", String.valueOf(notForReplication));
                    props.setProperty("isDeleteCascade", String.valueOf(isDeleteCascade));
                    props.setProperty("isUpdateCascade", String.valueOf(isUpdateCascade));
                    list.add(props);
                }
            }
            if (statement != null) {
                statement.close();
            }
            for (Properties props : list) {
                FKIndexAssociation fk;
                String constrId = props.getProperty("constrId");
                String fkName = props.getProperty("fkName");
                String tableName = props.getProperty("tableName");
                int notForReplication = Integer.parseInt(props.getProperty("notForReplication"));
                int isDeleteCascade = Integer.parseInt(props.getProperty("isDeleteCascade"));
                int isUpdateCascade = Integer.parseInt(props.getProperty("isUpdateCascade"));
                Table table = this.getTable(db, tableName);
                if (table == null || (fk = this.initFK(table, constrId, fkName, db, sqlConnection)) == null) continue;
                this.initFKColumns(fk, db.getName(), constrId, sqlConnection);
                if (isDeleteCascade == 1) {
                    fk.setDeleteRule("CASCADE");
                }
                fk.resetMandatoryUsingColumns();
                FKProxySqlServer fkProxy = (FKProxySqlServer)storage.getFKProxySet().getProxy(fk.getObjectID());
                if (fkProxy == null) continue;
                if (isUpdateCascade == 1) {
                    fkProxy.setOnUpdate("CASCADE");
                }
                if (notForReplication != 1) continue;
                fkProxy.setForReplication("NO");
            }
        }
    }

    private void initFKColumns(FKIndexAssociation fk, String db, String constrId, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("column_name").append(' ');
            buffer.append('=').append(' ');
            buffer.append("col_name(fkeyid,fkey)").append(' ');
            buffer.append(',').append(' ');
            buffer.append("refcol_name").append(' ');
            buffer.append('=').append(' ');
            buffer.append("col_name(rkeyid,rkey)").append(' ');
            buffer.append(',').append(' ');
            buffer.append("keyno").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append('.').append("dbo.sysforeignkeys").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("constid").append(' ').append('=').append(' ').append(constrId).append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("keyno").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHForeignKeySQLServerv2k5.initForeignKeys():", e);
        }
        if (rs != null) {
            FKContainer table = fk.getTable();
            FKContainer refTable = fk.getRemoteTable();
            while (rs.next()) {
                String colName = rs.getString(1);
                String refColName = rs.getString(2);
                Column col = (Column)table.getElementByName(colName);
                Column refCol = (Column)refTable.getElementByName(refColName);
                if (col == null || refCol == null) continue;
                col.addFKAssociation(refCol, fk);
                fk.getLocalFKIndex().add(col);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private FKIndexAssociation initFK(Table table, String constrId, String fkName, DataBaseSqlServer db, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet propsRS = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("rtrim(user_name(ObjectProperty(rkeyid,'ownerid'))) reftab_owner_name").append(' ');
            buffer.append(',').append(' ');
            buffer.append("object_name(rkeyid) reftab_name").append(' ');
            buffer.append(',').append(' ');
            buffer.append("key_name = (select name from ");
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append('.').append("dbo.sysindexes").append(' ');
            buffer.append("where id = rkeyid and indid = rkeyindid)").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append('.').append("dbo.sysreferences").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("constid").append(' ').append('=').append(' ').append(constrId).append(' ');
            propsRS = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHForeignKeySQLServerv2k5.initForeignKeys():", e);
        }
        if (propsRS != null && propsRS.next()) {
            RelationalDesign rd;
            String refTableName = propsRS.getString(2);
            String keyName = propsRS.getString(3);
            Table refTable = (Table)this.getRelationalDesign().getTableSet().getByName(refTableName);
            if (refTable == null && (rd = ((RelationalDesign)table.getDesignPart()).getRelatedSyncModel()) != null) {
                refTable = (Table)rd.getTableSet().getByName(refTableName);
            }
            if (refTable != null) {
                FKIndexAssociation[] fkias = table.getFKIndexAssociationsWith(refTable);
                for (int f = 0; f < fkias.length; ++f) {
                    FKIndexAssociation fkass = fkias[f];
                    if (!fkass.getName().equalsIgnoreCase(fkName)) continue;
                    if (statement != null) {
                        statement.close();
                    }
                    return null;
                }
                ContainerObjectPlaceHolder placeHolder = (ContainerObjectPlaceHolder)refTable.getPKeys().getByName(keyName);
                Index index = null;
                if (placeHolder != null && (index = (Index)placeHolder.getObject()) == null) {
                    placeHolder = (ContainerObjectPlaceHolder)refTable.getUKeys().getByName(keyName);
                    index = (Index)placeHolder.getObject();
                }
                if (index != null) {
                    FKIndexAssociation fkass = table.addFK(index);
                    if (fkName != null) {
                        fkass.setName(fkName);
                        fkass.getLocalFKIndex().setName(fkName);
                        this.stampModelObject((ModelObject)fkass, table.getSourceObjSchema(), fkName);
                        if (statement != null) {
                            statement.close();
                        }
                        return fkass;
                    }
                }
            }
        }
        if (statement != null) {
            statement.close();
        }
        return null;
    }

    private Table getTable(DataBaseSqlServer db, String name) {
        for (StorageObjectPlaceHolder ob : db.getTables()) {
            TableProxySqlServer proxy = (TableProxySqlServer)ob.getObject();
            if (!proxy.getName().equals(name)) continue;
            return (Table)proxy.getObject();
        }
        return null;
    }
}

