/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBMExtractionHandlerSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.storage.DistinctTypeProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DistinctTypeProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatatypeSqlServerv2k5
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "DATATYPE";
    private static final Logger LOGGER = new Logger(MOHDatatypeSqlServerv2k5.class);

    public MOHDatatypeSqlServerv2k5(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            String id = dbo.getId();
            String usertypeId = dbo.getUsertypeId();
            String schemaName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("USE").append(' ');
                buffer.append(MOHDatatypeSqlServerv2k5.getFormattedName(db)).append(' ');
                buffer.append("SELECT").append(' ');
                buffer.append("st").append('.');
                buffer.append("NAME").append(' ');
                buffer.append(" AS [Name]").append(' ');
                buffer.append(',').append(' ');
                buffer.append("st.user_type_id AS [ID]").append(' ');
                buffer.append(',').append(' ');
                buffer.append("CAST(CASE WHEN baset.name IN (N'nchar', N'nvarchar') ");
                buffer.append("AND st.max_length <> -1 THEN st.max_length/2 ");
                buffer.append("ELSE st.max_length END AS int) AS [Length], ");
                buffer.append("CAST(st.precision AS int) AS [NumericPrecision], ");
                buffer.append("CAST(st.scale AS int) AS [NumericScale], ");
                buffer.append("st.max_length AS [MaxLength],");
                buffer.append("st.is_nullable AS [Nullable], ");
                buffer.append("(case when st.default_object_id = 0 then N'' else def.name end) AS [Default],");
                buffer.append("(case when st.default_object_id = 0 then N'' else  ");
                buffer.append("schema_name(def.schema_id) end) AS [DefaultSchema], ");
                buffer.append("(case when st.rule_object_id = 0 then N'' else rul.name end) AS [Rule], ");
                buffer.append("(case when st.rule_object_id = 0 then N'' else ");
                buffer.append("schema_name(rul.schema_id) end) AS [RuleSchema], ");
                buffer.append("st.collation_name AS [Collation], ");
                buffer.append("baset.name AS [SystemType] ");
                buffer.append("FROM").append(' ');
                buffer.append("sys.types AS st ");
                buffer.append("LEFT OUTER JOIN sys.types AS baset ON baset.user_type_id = ");
                buffer.append("st.system_type_id and baset.user_type_id = baset.system_type_id ");
                buffer.append("LEFT OUTER JOIN sys.objects AS def ON def.object_id = ");
                buffer.append("st.default_object_id ");
                buffer.append("LEFT OUTER JOIN sys.objects AS rul ON rul.object_id = st.rule_object_id ");
                buffer.append("WHERE").append(' ');
                buffer.append("st.schema_id = ").append(id).append(' ');
                buffer.append(" and st.user_type_id = ").append(usertypeId).append(' ');
                buffer.append("and (st.schema_id!=4 and st.system_type_id!=240 and st.user_type_id != st.system_type_id)");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHDatatypeSqlServerv2k5.generate():", e);
            }
            if (rs != null && rs.next()) {
                int prec = 0;
                int scale = 0;
                try {
                    prec = rs.getInt(4);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    scale = rs.getInt(5);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String size = rs.getString(6);
                String nullSettings = rs.getString(7);
                String defaultObj = rs.getString(8);
                String defaultSchema = rs.getString(9);
                String rule = rs.getString(10);
                String ruleSchema = rs.getString(11);
                String systype = rs.getString(13);
                DistinctType type = this.getDesign().getDataTypesDesign().createDistinctType();
                type.setName(name);
                this.setProperties(type, rs, size, prec, scale, systype);
                this.stampModelObject(type, dbo);
                StorageDesign storage = this.getStorageDesign();
                if (storage != null && storage instanceof StorageDesignSqlServerv2k5) {
                    StorageDesignSqlServerv2k5 storageDesign = (StorageDesignSqlServerv2k5)storage;
                    DistinctTypeProxySqlServerv2k5 dt = (DistinctTypeProxySqlServerv2k5)storageDesign.getProxy(type);
                    DataBaseSqlServerv2k5 database = (DataBaseSqlServerv2k5)storageDesign.getDataBaseSet().getByName(db);
                    if (dt != null) {
                        if (database == null) {
                            database = (DataBaseSqlServerv2k5)storageDesign.getDataBaseSet().createDataBase();
                            database.setName(db);
                            this.stampModelObject((ModelObject)database, "", db);
                        }
                        UsedUserDefinedDatav2k5 usedDType = (UsedUserDefinedDatav2k5)storageDesign.getUsedUserDefinedDataSet().createUsedUserDefinedData();
                        usedDType.setName(name);
                        usedDType.setDatabase(database);
                        usedDType.setDistinctTypeProxy(dt);
                        this.stampModelObject((ModelObject)usedDType, dbo.getSchema(), name);
                        SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)database.getSchemas().getByName(schemaName);
                        if (schema != null) {
                            usedDType.setSchema(schema);
                        }
                        if ("1".equals(nullSettings)) {
                            dt.setNullType(DistinctTypeProxy.NULL_STATES[0]);
                        } else {
                            dt.setNullType(DistinctTypeProxy.NULL_STATES[1]);
                        }
                        String longRuleName = "";
                        if (!ruleSchema.equals("")) {
                            longRuleName = ruleSchema + ".";
                        }
                        longRuleName = longRuleName + rule;
                        String longDefaultName = "";
                        if (!defaultSchema.equals("")) {
                            longDefaultName = defaultSchema + ".";
                        }
                        longDefaultName = longDefaultName + defaultObj;
                        ((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).addToDefaultMap(longDefaultName, usedDType.getObjectID());
                        ((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).addToRuleMap(longRuleName, usedDType.getObjectID());
                    }
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void setProperties(DistinctType type, ResultSet rs, String size, int prec, int scale, String systype) throws Exception {
        String utype = systype != null ? systype.toUpperCase() : "";
        boolean isvarcharMax = false;
        if ((utype.equalsIgnoreCase("varchar") || utype.equalsIgnoreCase("nvarchar")) && size.equals("-1")) {
            isvarcharMax = true;
        }
        String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(systype);
        LogicalDatatype logicalDT = null;
        if (isvarcharMax) {
            logicalDT = this.getDesign().getLogicalDatatypeSet().getLogTypeForVarcharMax(utype, this.getDbmeHandler().getRDBMSSite().getType().getName());
        }
        if (logicalDT == null) {
            logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getDbmeHandler().getRDBMSSite().getType(), usedDatatype);
        }
        if (logicalDT == null) {
            logicalDT = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(usedDatatype, this.getDbmeHandler().getRDBMSSite().getType().getName());
        }
        if (logicalDT != null) {
            type.setLogicalDataType(logicalDT);
            if (isvarcharMax) {
                type.setSize("max");
            } else if (utype.indexOf("NCHAR") > -1 || utype.indexOf("NVARCHAR") > -1) {
                try {
                    int si = Integer.parseInt(size) / 2;
                    type.setSize(String.valueOf(si));
                }
                catch (RuntimeException e) {
                    type.setSize(size);
                }
            } else {
                type.setSize(size);
                type.setScale(scale);
            }
            type.setPrecision(prec);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList list = new ArrayList();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dbo = (DBUserSqlServer)dboNext;
            list.addAll(this.extractByUser(sqlConnection, dbo));
        }
        return list;
    }

    private List extractByUser(Connection sqlConnection, DBUserSqlServer dbo) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        String dbName = dbo.getDb();
        String schemaId = dbo.getId();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("DISTINCT").append(' ');
            buffer.append("t").append('.').append("NAME").append(' ');
            buffer.append("userdef_name").append(' ').append(',');
            buffer.append("usertype ");
            buffer.append("FROM").append(' ');
            buffer.append(MOHDatatypeSqlServerv2k5.getFormattedName(dbName)).append('.').append("dbo.systypes t").append(' ');
            buffer.append(',').append(' ');
            buffer.append('(').append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("XTYPE").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHDatatypeSqlServerv2k5.getFormattedName(dbName)).append('.').append("dbo.systypes").append(' ');
            buffer.append(')').append(' ');
            buffer.append("st").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("t").append('.').append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(schemaId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("t").append('.').append("XTYPE").append(' ');
            buffer.append("<>").append(' ');
            buffer.append("t").append('.').append("XUSERTYPE").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("t").append('.').append("XTYPE").append(' ');
            buffer.append('=').append(' ');
            buffer.append("st").append('.').append("XTYPE").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHDatatypeSqlServerv2k5.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String defName = rs.getString(1);
                String usertypeId = rs.getString(2);
                DBObjectSqlServer dboDef = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), defName, OBJECT_TYPE, dbo.getName());
                dboDef.setDb(dbName);
                dboDef.setId(schemaId);
                dboDef.setUsertypeId(usertypeId);
                list.add(dboDef);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }
}

