/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k12;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHRoleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHRoleSqlServerv2k12
extends MOHRoleSqlServerv2k5 {
    protected static final String OBJECT_TYPE = "ROLE";
    private static final Logger LOGGER = new Logger(MOHRoleSqlServerv2k12.class);

    public MOHRoleSqlServerv2k12(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    protected void initPrivileges(RoleSqlServer role, String role_id, String db, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("DB_PRIV").append(' ');
            buffer.append('=').append(' ');
            buffer.append(" case action ");
            buffer.append(" when 178 then 'CREATE FUNCTION'");
            buffer.append(" when 198 then 'CREATE TABLE'");
            buffer.append(" when 203 then 'CREATE DATABASE'");
            buffer.append(" when 207 then 'CREATE VIEW'");
            buffer.append(" when 222 then 'CREATE PROCEDURE'");
            buffer.append(" when 233 then 'CREATE DEFAULT'");
            buffer.append(" when 236 then 'CREATE RULE'");
            buffer.append(" end").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHRoleSqlServerv2k12.getFormattedName(db)).append('.').append("dbo.sysprotects").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("protecttype in (204,205)").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("action in (178,198,203,207,222,233,236)").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(role_id).append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    role.setSystemPrivileges(rs.getString(1));
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHRoleSqlServerv2k12.bindColumns():", e);
        }
    }
}

