/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHViewSqlServer
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "VIEW";
    private static final Logger LOGGER = new Logger(MOHViewSqlServer.class);

    public MOHViewSqlServer(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList list = new ArrayList();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dbo = (DBUserSqlServer)dboNext;
            list.addAll(this.extractByUser(sqlConnection, dbo));
        }
        return list;
    }

    private List extractByUser(Connection sqlConnection, DBUserSqlServer dbUser) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        String uid = dbUser.getUid();
        String db = dbUser.getDb();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("o").append('.').append("NAME").append(' ');
            buffer.append("VIEWNAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("u").append('.').append("NAME").append(' ');
            buffer.append("USERNAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHViewSqlServer.getFormattedName(db)).append('.').append("dbo.sysobjects o").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHViewSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers u").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("XTYPE").append(' ');
            buffer.append('=').append(' ');
            buffer.append('\'').append("V").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("o").append('.').append("UID").append(' ');
            buffer.append('=').append(' ').append(uid).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("o").append('.').append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append("u").append('.').append("UID").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSQLServer.extractByUser():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String tableName = rs.getString(1);
                String username = rs.getString(2);
                DBObjectSqlServer dboTable = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), tableName, OBJECT_TYPE, username);
                dboTable.setDb(db);
                list.add(dboTable);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("u").append('.').append("NAME").append(' ');
                buffer.append("USERNAME").append(' ');
                buffer.append(',').append(' ');
                buffer.append("s").append('.').append("TEXT").append(' ');
                buffer.append("DEFINITION").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("ID").append(' ');
                buffer.append("VIEWID").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHViewSqlServer.getFormattedName(db)).append('.').append("dbo.sysobjects o").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHViewSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers u").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHViewSqlServer.getFormattedName(db)).append('.').append("dbo.syscomments s").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("XTYPE").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append("V").append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o").append('.').append("UID").append(' ');
                buffer.append('=').append(' ');
                buffer.append("u").append('.').append("UID").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o").append('.').append("ID").append(' ');
                buffer.append('=').append(' ');
                buffer.append("s").append('.').append("ID").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o").append('.').append("NAME").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append(name).append('\'').append(' ');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHViewSqlServer.generate():", e);
            }
            ArrayList<Properties> list = new ArrayList<Properties>();
            if (rs != null) {
                while (rs.next()) {
                    String username = rs.getString(1);
                    String body = rs.getString(2);
                    String view_id = rs.getString(3);
                    boolean moreProps = false;
                    for (int j = 0; j < list.size(); ++j) {
                        Properties listProps = (Properties)list.get(j);
                        if (!listProps.getProperty("username").equals(username) || !listProps.getProperty("view_id").equals(view_id)) continue;
                        listProps.setProperty("body", listProps.getProperty("body") + body);
                        moreProps = true;
                        break;
                    }
                    if (moreProps) continue;
                    Properties props = new Properties();
                    props.setProperty("username", username);
                    props.setProperty("body", body);
                    props.setProperty("view_id", view_id);
                    list.add(props);
                }
            }
            if (statement != null) {
                statement.close();
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                TableView view = this.getRelationalDesign().getTableViewSet().createTableView(null);
                view.setSchemaObject(this.getSchemaSqlServer(dbo.getSchema(), db));
                view.setName(name);
                this.stampModelObject(view, dbo);
                view.setSyntaxProvider("MSSQL");
                Properties props = (Properties)it.next();
                String username = props.getProperty("username");
                String body = props.getProperty("body");
                String view_id = props.getProperty("view_id");
                view.setUserDefinedSQL(this.parseAsSelect(body));
                view.setUserDefined(true);
                view.getColumns(body.replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("   ", " ").replaceAll("  ", " "));
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignSqlServer)) continue;
                StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                DataBaseSqlServer database = null;
                if (!"".equalsIgnoreCase(db)) {
                    database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = storage.getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                } else {
                    database = (DataBaseSqlServer)storage.getDataBaseSet().getNullInstance();
                }
                TableViewProxySqlServer proxy = (TableViewProxySqlServer)storage.getTableViewProxySet().getProxy(view.getObjectID());
                proxy.setDataBase(database);
                this.setUser(proxy, storage, username, db, sqlConnection);
                this.initIndexesOnView(proxy, storage, view_id, db, sqlConnection);
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private String parseAsSelect(String userDef) {
        String beforeAs = Token.getStringBefore2(userDef, "AS");
        String afterAs = Token.getStringAfter(userDef, "AS");
        if (!"".equals(beforeAs) && !"".equals(afterAs) && afterAs.startsWith("(")) {
            afterAs = Token.getValBetweenBrackets(afterAs);
            return beforeAs + ' ' + "AS" + ' ' + afterAs;
        }
        return userDef;
    }

    private void initIndexesOnView(TableViewProxySqlServer proxy, StorageDesignSqlServer storage, String view_id, String db, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("i.name").append(' ');
            buffer.append(',').append(' ');
            buffer.append("clustered_ind = ");
            buffer.append("case when (i.status & 16)=16 ");
            buffer.append("then 'YES' ");
            buffer.append("else 'NO' ");
            buffer.append("end, f.groupname filegroup, ");
            buffer.append("i.origfillfactor fill_factor, i.indid, ");
            buffer.append("unique_ind = case when (i.status & 2)<>0 then 'YES' else 'NO' end, ");
            buffer.append("stats_no_recompute = case when (i.status & 16777216)<>0 then 'YES'  else 'NO' end, ");
            buffer.append("ignore_dup_keys = case when (i.status & 1)<>0 then 'YES'  else 'NO' end, ");
            buffer.append("is_pad_index = (select INDEXPROPERTY(i.id, i.name,'IsPadIndex')) ");
            buffer.append("FROM").append(' ');
            buffer.append(MOHViewSqlServer.getFormattedName(db)).append('.').append("dbo.sysindexes i").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHViewSqlServer.getFormattedName(db)).append('.').append("dbo.sysfilegroups f").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("i").append('.').append(' ');
            buffer.append("ID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(view_id).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("f").append('.').append("GROUPID").append(' ');
            buffer.append('=').append(' ');
            buffer.append("i").append('.').append("GROUPID").append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    String indexName = rs.getString(1);
                    String clustered = rs.getString(2);
                    String filegroup = rs.getString(3);
                    int fillFactor = rs.getInt(4);
                    String ind_id = rs.getString(5);
                    String unique = rs.getString(6);
                    String statsNoRecompute = rs.getString(7);
                    String ignoreDupKeys = rs.getString(8);
                    int isPadIndex = rs.getInt(9);
                    proxy.setSchemaBinding("YES");
                    IndexOnViewSqlServer index = storage.getIndexOnViewSet().createIndexOnView();
                    index.setName(indexName);
                    index.setView(proxy);
                    index.setClustered(clustered);
                    this.stampModelObject((ModelObject)index, proxy, indexName);
                    index.setFillFactor(fillFactor);
                    index.setUnique(unique);
                    if (statsNoRecompute.equalsIgnoreCase("NO")) {
                        index.setRecomputeStatistics("NO");
                    } else {
                        index.setRecomputeStatistics("AUTO");
                    }
                    index.setIgnoreDupKey(ignoreDupKeys);
                    if (isPadIndex == 0) {
                        index.setPadIndex("NO");
                    } else {
                        index.setPadIndex("YES");
                    }
                    FileGroupSqlServer fg = (FileGroupSqlServer)storage.getFileGroupSet().getByName(filegroup);
                    if (fg == null) {
                        fg = storage.getFileGroupSet().createFileGroup();
                        fg.setName(filegroup);
                        fg.setDataBase(proxy.getDataBase());
                        this.stampModelObject((ModelObject)fg, proxy, filegroup);
                    }
                    index.setFilegroup(fg);
                    this.initColumns(index, view_id, ind_id, db, sqlConnection);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHViewSqlServer.initIndexesOnView():", e);
        }
    }

    private void initColumns(IndexOnViewSqlServer index, String view_id, String ind_id, String db, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHViewSqlServer.getFormattedName(db)).append(' ');
            buffer.append(";").append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("col_name(id,colid) columnname").append(' ');
            buffer.append(',').append(' ');
            buffer.append("sort_desc = indexkey_property(id, indid, keyno, 'isdescending') ");
            buffer.append("FROM").append(' ');
            buffer.append(MOHViewSqlServer.getFormattedName(db)).append('.').append("dbo.sysindexkeys").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("id").append(' ');
            buffer.append('=').append(' ');
            buffer.append(view_id).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("indid").append(' ');
            buffer.append('=').append(' ');
            buffer.append(ind_id).append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("keyno");
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    String colName = rs.getString(1);
                    int sortOrder = rs.getInt(2);
                    index.setCols(colName);
                    if (sortOrder == 0) {
                        index.setCols("ASC");
                        continue;
                    }
                    index.setCols("DESC");
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHViewSqlServer.initIndexesOnView():", e);
        }
    }

    private void setUser(TableViewProxySqlServer view, StorageDesignSqlServer storageDesign, String username, String db, Connection sqlConnection) {
        String loginname;
        UserSqlServer user = (UserSqlServer)storageDesign.getUserSet().getByName(username);
        if (user == null) {
            user = storageDesign.getUserSet().createUser();
            user.setName(username);
            user.setDatabase(view.getDataBase());
            this.stampModelObject((ModelObject)user, db, username);
        }
        if ((loginname = this.getLogin(username, db, sqlConnection)) != null) {
            LoginSqlServer login = (LoginSqlServer)storageDesign.getLoginSet().getByName(loginname);
            if (login == null) {
                login = storageDesign.getLoginSet().createLogin();
                login.setName(loginname);
                this.stampModelObject((ModelObject)login, view, loginname);
            }
            user.setLogin(login);
            login.setUsers(username);
        }
        view.setUser(user);
    }

    private String getLogin(String username, String db, Connection sqlConnection) {
        String login = null;
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("l.loginname").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("master.dbo.syslogins l").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHViewSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers u").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("l").append('.').append("sid").append(' ');
            buffer.append('=').append(' ');
            buffer.append("u").append('.').append("sid").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("u").append('.').append("NAME").append(' ');
            buffer.append('=').append(' ').append('\'');
            buffer.append(username).append('\'').append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null && rs.next()) {
                login = rs.getString(1);
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHViewSqlServer.getLogin():", e);
        }
        return login;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }
}

