/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ContextOraclev9i;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHContextOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "CONTEXT";
    private static final Logger LOGGER = new Logger(MOHContextOraclev9i.class);
    protected boolean dbaUser;

    public MOHContextOraclev9i(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            String filterCondition = this.getFilterConditionOracle("NAMESPACE");
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAMESPACE").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? DBA_CONTEXT : ALL_CONTEXT).append(' ');
            if (filterCondition != null) {
                buffer.append("WHERE").append(' ').append(filterCondition).append(' ');
            }
            buffer.append("ORDER BY").append(' ');
            buffer.append("NAMESPACE");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException se) {
            if (se.getMessage().startsWith("ORA-00942")) {
                System.out.println("MOHContextOraclev9i.extract(): " + se.getMessage());
                LOGGER.error("MOHContextOraclev9i.extract(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_context" : "all_context"));
            } else {
                System.out.println("MOHContextOraclev9i.extract(): " + se.getMessage());
                LOGGER.error("MOHContextOraclev9i.extract():", se);
            }
        }
        catch (Exception e) {
            System.out.println("MOHContextOraclev9i.extract(): " + e.getMessage());
            LOGGER.error("MOHContextOraclev9i.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String userName = rs.getString("NAMESPACE");
                DBObject dboUser = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), userName, OBJECT_TYPE);
                list.add(dboUser);
            }
            rs.close();
        }
        statement.close();
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) {
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ');
                        buffer.append("NAMESPACE").append(',');
                        buffer.append("SCHEMA").append(',');
                        buffer.append("PACKAGE").append(',');
                        buffer.append(this.dbaUser ? TYPE : NULL).append(' ').append("AS").append(' ').append("TYPE").append(' ');
                        buffer.append("FROM").append(' ');
                        buffer.append(this.dbaUser ? DBA_CONTEXT : ALL_CONTEXT).append(' ');
                        buffer.append("WHERE").append(' ');
                        buffer.append("NAMESPACE").append('=').append('?');
                        statement = sqlConnection.prepareStatement(buffer.toString());
                    }
                    statement.setString(1, dbo.getName());
                    rs = statement.executeQuery();
                }
                catch (SQLException se) {
                    if (se.getMessage().startsWith("ORA-00942")) {
                        System.out.println("MOHContextOraclev9i.generate(): " + se.getMessage());
                        LOGGER.error("MOHContextOraclev9i.generate(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_context" : "all_context"));
                    } else {
                        System.out.println("MOHContextOraclev9i.generate(): " + se.getMessage());
                        LOGGER.error("MOHContextOraclev9i.generate():", se);
                    }
                }
                catch (Exception e) {
                    System.out.println("MOHContextOraclev9i.generate(): " + e.getMessage());
                    LOGGER.error("MOHContextOraclev9i.generate():", e);
                }
                if (rs != null) {
                    StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                    while (rs.next()) {
                        String namespace = rs.getString("NAMESPACE");
                        String _schema = rs.getString("SCHEMA");
                        String _package = rs.getString("PACKAGE");
                        String type = rs.getString("TYPE");
                        ContextOraclev9i context = (ContextOraclev9i)storage.getContextSet().createContext();
                        context.setName(namespace);
                        context.setNamespace(namespace);
                        if (!namespace.equals(namespace.toUpperCase())) {
                            context.setNameHasQuotes(true);
                        }
                        context.setPackage(_schema + "." + _package);
                        if (type != null) {
                            if ("ACCESSED GLOBALLY".equalsIgnoreCase(type.trim())) {
                                context.setAccessedGlobally("YES");
                            } else if ("INITIALIZED GLOBALLY".equalsIgnoreCase(type.trim())) {
                                context.setInitialized("GLOBALLY");
                            } else if ("INITIALIZED EXTERNALLY".equalsIgnoreCase(type.trim())) {
                                context.setInitialized("EXTERNALLY");
                            }
                        }
                        this.stampModelObject(context, dbo);
                    }
                    rs.close();
                }
            }
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (statement != null) {
            statement.close();
        }
    }
}

