/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTablespaceDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTablespaceDB2.class);

    public MOHTablespaceDB2(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TYPE, PARTITIONS, DBNAME, ");
                buffer.append("DSSIZE, SEGSIZE, BPOOL, LOCKRULE, LOCKMAX, ");
                buffer.append("CLOSERULE, ENCODING_SCHEME, LOCKPART, MAXROWS, ");
                buffer.append("OBID, PSID, NACTIVE, CREATEDBY, SPACE ");
                buffer.append("from SYSIBM.SYSTABLESPACE").append(' ');
                buffer.append("WHERE NAME = '").append(name).append("' and dbname = '").append(dbo.getCatalog()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHTablespaceDB2.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                        String type = rs.getString(1);
                        int partions = rs.getInt(2);
                        String dbname = rs.getString(3);
                        int dssize = rs.getInt(4);
                        int segsize = rs.getInt(5);
                        String bpool = rs.getString(6);
                        String lockrule = rs.getString(7);
                        int lockmax = rs.getInt(8);
                        String closerule = rs.getString(9);
                        String ccsid = rs.getString(10);
                        String lockpart = rs.getString(11);
                        int maxrows = rs.getInt(12);
                        int obid = rs.getInt(13);
                        int psid = rs.getInt(14);
                        int nactive = rs.getInt(15);
                        String createdby = rs.getString(16);
                        int space = rs.getInt(17);
                        DataBaseDB2 db = (DataBaseDB2)storage.getDataBaseSet().getByName(dbname);
                        if (db == null) {
                            db = storage.getDataBaseSet().createDataBase();
                            db.setName(dbname);
                        }
                        if (db != null) {
                            TableSpaceDB2 ts = storage.getTableSpaceSet().createTableSpace();
                            ts.setName(name);
                            ts.setDataBase(db);
                            this.stampModelObject(ts, dbo);
                            if ("L".equalsIgnoreCase(type)) {
                                ts.setType("LOB");
                            }
                            if (dssize > 0) {
                                ts.setDsSize(dssize / 0x100000 + " G");
                            }
                            ts.setSegSize("" + segsize);
                            BufferPoolDB2 bp = (BufferPoolDB2)storage.getBufferPoolSet().getByName(bpool);
                            if (bp != null) {
                                ts.setBufferPool(bp);
                            }
                            if ("A".equalsIgnoreCase(lockrule)) {
                                ts.setLockSize("ANY");
                            } else if ("L".equalsIgnoreCase(lockrule)) {
                                ts.setLockSize("LOB");
                            } else if ("P".equalsIgnoreCase(lockrule)) {
                                ts.setLockSize("PAGE");
                            } else if ("R".equalsIgnoreCase(lockrule)) {
                                ts.setLockSize("ROW");
                            } else if ("S".equalsIgnoreCase(lockrule)) {
                                ts.setLockSize(OBJECT_TYPE);
                            } else if ("T".equalsIgnoreCase(lockrule)) {
                                ts.setLockSize("TABLE");
                            }
                            ts.setLockMax(lockmax);
                            if ("N".equalsIgnoreCase(closerule)) {
                                ts.setClose(false);
                            } else {
                                ts.setClose(true);
                            }
                            if (ccsid.trim().equalsIgnoreCase("E")) {
                                ts.setCcsid("EBCDIC");
                            } else if (ccsid.trim().equalsIgnoreCase("A")) {
                                ts.setCcsid("ASCII");
                            } else if (ccsid.trim().equalsIgnoreCase("U")) {
                                ts.setCcsid("UNICODE");
                            }
                            if ("Y".equalsIgnoreCase(lockpart)) {
                                ts.setLockPart(true);
                            } else {
                                ts.setClose(false);
                            }
                            ts.setMaxRows(maxrows);
                            ts.setObid(obid);
                            ts.setPsid(psid);
                            ts.setNactive(nactive);
                            ts.setCreatedBy(createdby);
                            ts.setSpace(space);
                            ts.setNumParts(partions);
                            if (partions > 0) {
                                ts.setType("PARTITIONED");
                                this.initTablespacePartitions(sqlConnection, ts);
                            }
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initTablespacePartitions(Connection sqlConnection, TableSpaceDB2 ts) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT PARTITION, COMPRESS, ");
            buffer.append("VCATNAME, STORNAME, PQTY, SQTY, FREEPAGE, PCTFREE, GBPCACHE, TRACKMOD ");
            buffer.append("from SYSIBM.SYSTABLEPART ");
            buffer.append("WHERE TSNAME = '");
            buffer.append(ts.getName()).append("'");
            buffer.append(" and DBNAME = '");
            buffer.append(ts.getDataBase().getName()).append("'");
            buffer.append("ORDER BY PARTITION");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTablespaceDB2.initTablespacePartitions():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                StorageTemplateDB2 realst;
                AbstractStorageDesignDB2 storage;
                StorageDesign storageDesign;
                int partNumber = rs.getInt(1);
                String compress = rs.getString(2);
                String vcatName = rs.getString(3);
                String sgName = rs.getString(4).trim();
                int pqty = rs.getInt(5) * 4;
                int sqty = rs.getInt(6) * 4;
                int freepage = rs.getInt(7);
                int pctfree = rs.getInt(8);
                String gbcache = rs.getString(9);
                String track = rs.getString(10);
                if (partNumber > 0) {
                    storageDesign = this.getStorageDesign();
                    storage = null;
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        StorageTemplateDB2 realst2;
                        storage = (AbstractStorageDesignDB2)storageDesign;
                        ts.setType("PARTITIONED");
                        PartitionDB2 part = storage.getPartitionSet().createPartition();
                        part.setTableSpace(ts);
                        part.setPartNumber(partNumber);
                        if ("Y".equalsIgnoreCase(compress)) {
                            part.setCompress(true);
                        } else {
                            part.setCompress(false);
                        }
                        StorageTemplateDB2 st = storage.getStorageTemplateSet().createStorageTemplate();
                        part.setStorageTemplate(st);
                        if (!"".equalsIgnoreCase(sgName)) {
                            StorageGroupDB2 sg = (StorageGroupDB2)storage.getStorageGroupSet().getByName(sgName);
                            if (sg != null) {
                                st.setStorageGroup(sg);
                            }
                        } else {
                            VCatDB2 vcat = (VCatDB2)storage.getVCatSet().getByName(vcatName);
                            if (vcat != null) {
                                st.setVCat(vcat);
                            }
                        }
                        st.setSgPriqty(pqty);
                        st.setSgSeqty(sqty);
                        st.setFreePage(freepage);
                        st.setPctFree(pctfree);
                        if ("A".equalsIgnoreCase(gbcache)) {
                            st.setGbCache("ALL");
                        } else if ("N".equalsIgnoreCase(gbcache)) {
                            st.setGbCache("NONE");
                        } else if ("S".equalsIgnoreCase(gbcache)) {
                            st.setGbCache("SYSTEM");
                        } else if ("".equalsIgnoreCase(gbcache)) {
                            st.setGbCache("CHANGED");
                        }
                        if ("N".equalsIgnoreCase(track)) {
                            st.setTrackMode(false);
                        } else {
                            st.setTrackMode(true);
                        }
                        if ((realst2 = storage.getStorageTemplateSet().removeIfExistEqual(st)) == part.getStorageTemplate()) continue;
                        part.setStorageTemplate(realst2);
                        continue;
                    }
                    LOGGER.error("Unable to find Storage Design!");
                    continue;
                }
                storageDesign = this.getStorageDesign();
                storage = null;
                if (storageDesign == null || !(storageDesign instanceof AbstractStorageDesignDB2)) continue;
                storage = (AbstractStorageDesignDB2)storageDesign;
                if ("Y".equalsIgnoreCase(compress)) {
                    ts.setCompress(true);
                } else {
                    ts.setCompress(false);
                }
                StorageTemplateDB2 st = storage.getStorageTemplateSet().createStorageTemplate();
                ts.setStorageTemplate(st);
                if (!"".equalsIgnoreCase(sgName)) {
                    StorageGroupDB2 sg = (StorageGroupDB2)storage.getStorageGroupSet().getByName(sgName);
                    if (sg != null) {
                        st.setStorageGroup(sg);
                    }
                } else {
                    VCatDB2 vcat = (VCatDB2)storage.getVCatSet().getByName(vcatName);
                    if (vcat != null) {
                        st.setVCat(vcat);
                    }
                }
                st.setSgPriqty(pqty);
                st.setSgSeqty(sqty);
                st.setFreePage(freepage);
                st.setPctFree(pctfree);
                if ("A".equalsIgnoreCase(gbcache)) {
                    st.setGbCache("ALL");
                } else if ("N".equalsIgnoreCase(gbcache)) {
                    st.setGbCache("NONE");
                } else if ("S".equalsIgnoreCase(gbcache)) {
                    st.setGbCache("SYSTEM");
                } else if ("".equalsIgnoreCase(gbcache)) {
                    st.setGbCache("CHANGED");
                }
                if ("N".equalsIgnoreCase(track)) {
                    st.setTrackMode(false);
                } else {
                    st.setTrackMode(true);
                }
                if ((realst = storage.getStorageTemplateSet().removeIfExistEqual(st)) == ts.getStorageTemplate()) continue;
                ts.setStorageTemplate(realst);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT name,creator,dbname from SYSIBM.SYSTABLESPACE").append(' ');
            buffer.append("WHERE CREATOR <> 'SYSIBM' order by dbname,name");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTablespaceDB2.extract(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String tsname = rs.getString(1);
                String creator = rs.getString(2);
                String dbname = rs.getString(3);
                DBObject dboTs = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tsname, OBJECT_TYPE, creator);
                dboTs.setCatalog(dbname);
                list.add(dboTs);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }
}

