/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHProcedureDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "PROCEDURE";
    private static final Logger LOGGER = new Logger(MOHProcedureDB2.class);

    public MOHProcedureDB2(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String ownerName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT PARMLIST ");
                buffer.append("from SYSIBM.SYSPROCEDURES ");
                buffer.append("WHERE PROCEDURE = '").append(name).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHProcedureDB2.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                        String body = rs.getString(1);
                        StoredProcedureDB2 proc = storage.getStoredProcedureSet().createStoredProcedure();
                        proc.setName(name);
                        proc.setBody(body);
                        this.stampModelObject(proc, dbo);
                        Owner owner = (Owner)storage.getOwnerSet().getByName(ownerName);
                        if (owner != null) {
                            proc.setOwner(owner);
                        } else {
                            owner = (Owner)storage.getOwnerSet().createElement(ownerName);
                            owner.setName(ownerName);
                            this.stampModelObject((ModelObject)owner, "", ownerName);
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT PROCEDURE from SYSIBM.SYSPROCEDURES ");
                buffer.append("WHERE AUTHID = '");
                buffer.append(dboNext.getName()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHProcedureDB2.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), name, OBJECT_TYPE, dboNext.getName());
                    list.add(dbo);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }
}

