/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateStoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StoredProcedureSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateStoredProcedureSqlServerv2k5
extends SHCreateStoredProcedureSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateStoredProcedureSqlServerv2k5.class);

    public SHCreateStoredProcedureSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateStoredProcedureSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create proc") || Token.startsWithString(statement, "create procedure")) {
            this.parseStoredProcedure(statement, line);
        } else {
            this.nextHandler(line);
        }
    }

    private void parseStoredProcedure(String statement, String line) {
        StoredProcedureSqlServerv2k5 proc;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (storageDesign != null && (proc = (StoredProcedureSqlServerv2k5)storageDesign.getStoredProcedureSet().createStoredProcedure()) != null) {
            try {
                this.design.getRelationalDesign().stampModelObjectDDL(proc);
                this.initStoredProcedureName(storageDesign, proc, statement);
                this.initBody(proc, line, statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(statement + " Error parsing stored procedure for SqlServer!");
                this.importLog.addFailedStatement(SHCreateStoredProcedureSqlServerv2k5.FormatCR(line, "\n"));
            }
        }
    }

    private void initStoredProcedureName(StorageDesignSqlServerv2k5 storageDesign, StoredProcedureSqlServerv2k5 proc, String statement) throws ParseException {
        try {
            String name;
            int number = 1;
            String token = Token.getToken(statement, number);
            while (!("".equalsIgnoreCase(token) || token.equalsIgnoreCase("PROCEDURE") || token.equalsIgnoreCase("PROC"))) {
                token = Token.getToken(statement, ++number);
            }
            if ((name = Token.getToken(statement, ++number)).indexOf(46) > -1) {
                String schemaName = name.substring(0, name.indexOf(46));
                schemaName = Token.getValBetweenSquareBrackets(schemaName);
                SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)storageDesign.getSchemaSet().getByName(schemaName);
                if (schema == null) {
                    schema = (SchemaSqlServerv2k5)storageDesign.getSchemaSet().createSchema();
                    schema.setName(schemaName);
                    this.design.getRelationalDesign().stampModelObjectDDL(schema);
                    schema.setDatabase(this.getCurrentDB());
                }
                if (schema != null) {
                    proc.setSchema(schema);
                }
                name = name.substring(name.indexOf(46) + 1);
            }
            proc.setName(name);
            proc.setDatabase(this.getCurrentDB());
        }
        catch (Exception e) {
            LOGGER.error(statement + " Error parsing stored procedure name (SqlServer)! ");
            this.importLog.addError("Error parsing stored procedure name for SqlServer " + statement);
            throw new ParseException();
        }
    }

    private void initBody(StoredProcedureSqlServerv2k5 proc, String line, String statement) {
        int number = 1;
        String token = Token.getToken(statement, number);
        while (!("".equalsIgnoreCase(token) || token.equalsIgnoreCase("PROCEDURE") || token.equalsIgnoreCase("PROC"))) {
            token = Token.getToken(statement, ++number);
        }
        String name = Token.getToken(statement, ++number);
        proc.setBody(Token.getStringAfter(line, name));
    }
}

