/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k12;

import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateIndexSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.IndexProxySqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexSqlServerv2k12
extends SHCreateIndexSqlServerv2k5 {
    private boolean columnstoreIndex;
    private static final Logger LOGGER = new Logger(SHCreateIndexSqlServer.class);

    public SHCreateIndexSqlServerv2k12(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateIndexSqlServerv2k12.clearCR(line);
        if (Token.startsWithString(statement, "create index") || Token.startsWithString(statement, "create unique index") || Token.startsWithString(statement, "create unique clustered index") || Token.startsWithString(statement, "create unique nonclustered index") || Token.startsWithString(statement, "create clustered index") || Token.startsWithString(statement, "create nonclustered index") || Token.startsWithString(statement, "create primary xml index") || Token.startsWithString(statement, "create xml index") || Token.startsWithString(statement, "create columnstore index") || Token.startsWithString(statement, "create nonclustered columnstore index")) {
            this.index = null;
            this.indexName = "";
            this.columnstoreIndex = false;
            try {
                this.parseIndex(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateIndexSqlServerv2k12.FormatCR(line, "\n"));
            }
            this.index = null;
            this.table = null;
            this.viewProxy = null;
            this.indexName = "";
            this.columnstoreIndex = false;
            this.stoDesign = null;
            this.view = null;
            this.iov = null;
        } else {
            this.nextHandler(line);
        }
    }

    private void parseIndex(String statement) {
        this.statement = statement;
        if (this.isPK()) {
            this.parsePK(statement);
        } else if (this.isUK()) {
            this.parseUK(statement);
        } else if (this.isIOV()) {
            this.parseIOV(statement);
        } else if (this.isSecondaryXMLIndex()) {
            this.parseSecondaryXMLIndex(statement);
        } else if (this.isColumnstoreIndex()) {
            this.parseColumnstoreIndex();
        } else {
            this.parseInd();
        }
    }

    public void parseColumnstoreIndex() {
        try {
            this.indexName = this.initIndexName();
            this.constructColumnstoreIndex();
            this.setColumnForColumnstoreIndex();
            if (this.index != null && this.index.getName().equals(this.indexName)) {
                IndexProxySqlServerv2k12 indexProxy;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k12)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (indexProxy = (IndexProxySqlServerv2k12)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    this.initColumnstoreIndex(indexProxy);
                    this.initDropExisting(indexProxy);
                    this.initMaxdop(indexProxy);
                    this.initClusteredColumnstore(indexProxy);
                    this.initFileGroup(indexProxy);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("", e);
            this.importLog.addError("Setting columns to columnstore index " + this.indexName + " failed.");
        }
    }

    private boolean isColumnstoreIndex() {
        this.columnstoreIndex = Token.hasToken(this.statement, "COLUMNSTORE");
        return this.columnstoreIndex;
    }

    private void initColumnstoreIndex(IndexProxySqlServerv2k12 indexProxy) {
        indexProxy.setColumnstoreIndex(this.columnstoreIndex);
    }

    private void initClusteredColumnstore(IndexProxy indexProxy) {
        if (Token.hasToken(this.statement, "NONCLUSTERED")) {
            indexProxy.setClustered(false);
        } else {
            indexProxy.setClustered(false);
        }
    }

    private void constructColumnstoreIndex() {
        String name = this.getName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(name);
        if (this.table != null) {
            Index[] indexes = (Index[])this.table.getKeys();
            for (int i = 0; i < indexes.length; ++i) {
                Index ind = indexes[i];
                if (!ind.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = ind;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
                this.index = this.table.createIndex();
                this.index.setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        }
    }

    private void setColumnForColumnstoreIndex() throws ObjectDoesNotExistException {
        Map columnCollection = null;
        if (this.table != null && (columnCollection = this.getColumnsForTable()).size() > 0) {
            String columnString = Token.getValBetweenBrackets(this.statement, 1);
            if ("".equalsIgnoreCase(columnString.trim())) {
                return;
            }
            boolean functionString = Token.hasCloseAndOpenBrackets(columnString);
            if (functionString) {
                this.index.setIndexExpression(columnString);
                return;
            }
            StringTokenizer columnToken = new StringTokenizer(columnString, ",");
            while (columnToken.hasMoreTokens()) {
                Column columnTable;
                String columnName = columnToken.nextToken().trim();
                columnName = Token.getValBetweenSquareBrackets(columnName);
                columnName = Token.getNamesOnly(columnName);
                String sortOrder = "ASC";
                int posColumnSpace = columnName.indexOf(" ");
                if (posColumnSpace > 0) {
                    columnName = columnName.substring(0, posColumnSpace);
                }
                if ((columnTable = (Column)columnCollection.get(columnName = Token.getValBetweenSquareBrackets(columnName))) != null) {
                    try {
                        this.index.add(columnTable);
                        this.index.setColumnSortOrder(columnTable, sortOrder);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception occured while adding column to columnstore index!" + this.statement);
                        this.importLog.addError("Error in adding column " + columnTable + " to columnstore index " + this.indexName);
                    }
                    continue;
                }
                throw new ObjectDoesNotExistException("Column");
            }
        }
    }
}

