/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHGrantPrivilegesSqlServer
extends DDLStatementHandlerSqlServer {
    private StorageDesignSqlServerv2k storageDesign;
    private static final Logger LOGGER = new Logger(SHGrantPrivilegesSqlServer.class);

    public SHGrantPrivilegesSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHGrantPrivilegesSqlServer.clearCR(line);
        if ((Token.startsWithString(statement, "grant") || Token.startsWithString(statement, "grant all")) && !Token.hasToken(statement, "ON")) {
            try {
                this.grantPrivileges(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHGrantPrivilegesSqlServer.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void grantPrivileges(String statement) {
        this.statement = statement.replaceAll("\"", "");
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            String priv = Token.getStringAfter(this.statement, "GRANT").trim();
            priv = Token.getStringBeforeToken(priv, "TO").trim();
            this.initTo(priv);
        }
    }

    private void initTo(String priv) {
        String to = Token.getStringAfterToken(this.statement, "TO").trim();
        if (!to.equalsIgnoreCase("")) {
            StringTokenizer tokenizer = new StringTokenizer(to, ",");
            String userOrRole = null;
            while (tokenizer.hasMoreTokens()) {
                String pr;
                userOrRole = tokenizer.nextToken().trim();
                userOrRole = Token.getValBetweenSquareBrackets(userOrRole);
                DataBaseSqlServer db = this.getCurrentDB();
                StorageObjectCollection users = db.getUsers();
                StorageObjectCollection roles = db.getRoles();
                if (users.getByName(userOrRole) != null) {
                    UserSqlServer user = (UserSqlServer)users.getByName(userOrRole);
                    StringTokenizer userTokenizer = new StringTokenizer(priv, ",");
                    pr = null;
                    while (userTokenizer.hasMoreTokens()) {
                        pr = userTokenizer.nextToken().trim();
                        user.setSystemPrivileges(pr);
                    }
                    continue;
                }
                if (roles.getByName(userOrRole) == null) continue;
                RoleSqlServer role = (RoleSqlServer)roles.getByName(userOrRole);
                StringTokenizer roleTokenizer = new StringTokenizer(priv, ",");
                pr = null;
                while (roleTokenizer.hasMoreTokens()) {
                    pr = roleTokenizer.nextToken().trim();
                    role.setSystemPrivileges(pr);
                }
            }
        } else {
            LOGGER.error("SHGrantPrivilegesSqlServer.initTo(): wrong syntax!");
            this.importLog.addError("Error in setting TO objects of permission " + this.statement);
        }
    }
}

