/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.RuleSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRuleSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String RULENAME = "@rulename";
    private static final Logger LOGGER = new Logger(SHCreateRuleSqlServer.class);
    private RuleSqlServer rule;
    private StorageDesignSqlServerv2k storageDesign;

    public SHCreateRuleSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateRuleSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "create rule ")) {
            try {
                this.parseRule(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHCreateRuleSqlServer.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "exec sp_bindrule ")) {
            try {
                this.bindRule(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHCreateRuleSqlServer.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseRule(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            this.rule = this.storageDesign.getRuleSet().createRule();
            if (this.rule != null) {
                this.initRuleName();
                this.initExpression();
                this.design.getRelationalDesign().stampModelObjectDDL(this.rule);
                if (this.rule.getDatabase() == null) {
                    this.rule.setDatabase(this.getCurrentDB());
                }
            }
        }
    }

    private void initRuleName() {
        String name = Token.getStringAfter(this.statement, "RULE").trim();
        if ((name = Token.getStringBefore(name, "AS").trim()).indexOf(46) > -1) {
            String ownerName = name.substring(0, name.indexOf(46));
            ownerName = Token.getValBetweenSquareBrackets(ownerName);
            UserSqlServer owner = (UserSqlServer)this.storageDesign.getUserSet().getByName(ownerName);
            if (owner != null) {
                this.rule.setOwner(owner);
                this.rule.setDatabase(owner.getDatabase());
            }
            name = name.substring(name.indexOf(46) + 1);
        }
        this.rule.setName(name);
    }

    private void initExpression() {
        String exp = Token.getStringAfter(this.statement, "AS").trim();
        this.rule.setExpression(exp);
    }

    private void bindRule(String statement) {
        String bind;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (this.storageDesign != null && (bind = Token.getStringAfter(this.statement, "sp_bindrule").trim()).indexOf(44) > -1) {
            RuleSqlServerv2k rule;
            String name = bind.substring(0, bind.indexOf(44)).trim();
            String column = bind.substring(bind.indexOf(44) + 1).trim();
            if (name.startsWith(RULENAME)) {
                name = Token.getStringAfter(name, "=").trim();
            }
            if (name.toUpperCase().startsWith("N'")) {
                name = name.substring(1);
            }
            if (name.startsWith("'")) {
                name = Token.getValBetweenQuotationMarks(name);
            }
            if (column.startsWith("@")) {
                column = Token.getStringAfter(column, "=").trim();
            }
            if (column.toUpperCase().startsWith("N'")) {
                column = column.substring(1);
            }
            if (column.startsWith("'")) {
                column = Token.getValBetweenQuotationMarks(column);
            }
            if (name.indexOf(46) > -1) {
                name = name.substring(name.indexOf(46) + 1);
            }
            if ((rule = (RuleSqlServerv2k)this.storageDesign.getRuleSet().getByName(name)) != null) {
                this.bindColumn(rule, column);
            }
        }
    }

    private void bindColumn(RuleSqlServer rule, String columnString) {
        StringTokenizer tokenizer = new StringTokenizer(columnString, ".");
        String userName = null;
        String tableName = null;
        String col = null;
        String columnName = null;
        if (tokenizer.countTokens() == 2) {
            col = columnString;
            tableName = tokenizer.nextToken().trim();
            columnName = tokenizer.nextToken().trim();
        } else if (tokenizer.countTokens() == 3) {
            userName = tokenizer.nextToken().trim();
            col = columnString.substring(columnString.indexOf(".")).trim();
            tableName = tokenizer.nextToken().trim();
            columnName = tokenizer.nextToken().trim();
        } else {
            LOGGER.error("RuleSqlServer " + rule.getName() + ": wrong column syntax!");
            this.importLog.addWarning("Wrong column syntax for rule " + rule.getName());
        }
        if (userName != null) {
            userName = Token.getValBetweenSquareBrackets(userName);
            UserSqlServer user = (UserSqlServer)this.storageDesign.getUserSet().getByName(userName);
            if (user != null) {
                rule.setOwner(user);
            }
        }
        if (col != null) {
            tableName = Token.getValBetweenSquareBrackets(tableName);
            TableProxySqlServer table = ((TableProxySetSqlServer)this.storageDesign.getTableProxySet()).getByName(tableName);
            if (table != null) {
                rule.setColumns(columnName);
                rule.setDatabase(table.getDatabase());
            }
        }
    }
}

