/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateLoginSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String LOGINAME = "@loginame";
    private static final String PASSWD = "@passwd";
    private static final String DEFDB = "@defdb";
    private static final String DEFLANGUAGE = "@deflanguage";
    private static final String LANGUAGE = "@language";
    private static final String NAME_IN_DB = "@name_in_db";
    private RDBMSSite site;
    private StorageDesignSqlServerv2k stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateLoginSqlServer.class);

    public SHCreateLoginSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateLoginSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "exec sp_addlogin")) {
            try {
                this.createSQLServerLogin(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateLoginSqlServer.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "exec sp_grantlogin")) {
            try {
                this.createWindowsLogin(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateLoginSqlServer.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "exec sp_defaultdb")) {
            try {
                this.initDefaultDB(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateLoginSqlServer.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "exec sp_defaultlanguage")) {
            try {
                this.initDefaultLanguage(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateLoginSqlServer.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "exec sp_grantdbaccess")) {
            try {
                this.initUsers(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateLoginSqlServer.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void createSQLServerLogin(String statement) {
        LoginSqlServer login;
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null && (login = this.stoDesign.getLoginSet().createLogin()) != null) {
            login.setAuthentication("SQL Server");
            this.design.getRelationalDesign().stampModelObjectDDL(login);
            String exp = Token.getStringAfter(this.statement, "sp_addlogin").trim();
            StringTokenizer tokenizer = new StringTokenizer(exp, ",");
            try {
                String name = tokenizer.nextToken().trim();
                String pass = tokenizer.nextToken().trim();
                String db = tokenizer.nextToken().trim();
                String language = tokenizer.nextToken().trim();
                if (name.startsWith(LOGINAME)) {
                    name = Token.getStringAfter(name, "=").trim();
                }
                if (name.toUpperCase().startsWith("N'")) {
                    name = name.substring(1);
                }
                if (name.startsWith("'")) {
                    name = Token.getValBetweenQuotationMarks(name);
                }
                name = Token.getValBetweenSquareBrackets(name);
                if (pass.startsWith(PASSWD)) {
                    pass = Token.getStringAfter(pass, "=").trim();
                }
                if (pass.toUpperCase().startsWith("N'")) {
                    pass = pass.substring(1);
                }
                if (pass.startsWith("'")) {
                    pass = Token.getValBetweenQuotationMarks(pass);
                }
                if (db.startsWith(DEFDB)) {
                    db = Token.getStringAfter(db, "=").trim();
                }
                if (db.toUpperCase().startsWith("N'")) {
                    db = db.substring(1);
                }
                if (db.startsWith("'")) {
                    db = Token.getValBetweenQuotationMarks(db);
                }
                db = Token.getValBetweenSquareBrackets(db);
                if (language.startsWith(DEFLANGUAGE)) {
                    language = Token.getStringAfter(language, "=").trim();
                }
                if (language.toUpperCase().startsWith("N'")) {
                    language = language.substring(1);
                }
                if (language.startsWith("'")) {
                    language = Token.getValBetweenQuotationMarks(language);
                }
                login.setName(name);
                login.setPassword(pass);
                login.setDefaultDatabase((DataBaseSqlServer)this.stoDesign.getDataBaseSet().getByName(db));
                login.setLanguage(language);
            }
            catch (NoSuchElementException e) {
                LOGGER.error("LoginSqlServer.createSQLServerLogin(): wrong syntax!", e);
                this.importLog.addError("Wrong syntax near " + statement);
            }
        }
    }

    private void createWindowsLogin(String statement) {
        LoginSqlServer login;
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null && (login = this.stoDesign.getLoginSet().createLogin()) != null) {
            login.setAuthentication("WINDOWS");
            this.design.getRelationalDesign().stampModelObjectDDL(login);
            String name = Token.getStringAfter(this.statement, "sp_grantlogin").trim();
            if (name.startsWith(LOGINAME)) {
                name = Token.getStringAfter(name, "=").trim();
            }
            if (name.toUpperCase().startsWith("N'")) {
                name = name.substring(1);
            }
            if (name.startsWith("'")) {
                name = Token.getValBetweenQuotationMarks(name);
            }
            name = Token.getValBetweenSquareBrackets(name);
            login.setName(name);
        }
    }

    private void initDefaultDB(String statement) {
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            String exp = Token.getStringAfter(this.statement, "sp_defaultdb").trim();
            StringTokenizer tokenizer = new StringTokenizer(exp, ",");
            if (tokenizer.countTokens() == 2) {
                String name = tokenizer.nextToken().trim();
                String db = tokenizer.nextToken().trim();
                if (name.startsWith(LOGINAME)) {
                    name = Token.getStringAfter(name, "=").trim();
                }
                if (name.toUpperCase().startsWith("N'")) {
                    name = name.substring(1);
                }
                if (name.startsWith("'")) {
                    name = Token.getValBetweenQuotationMarks(name);
                }
                name = Token.getValBetweenSquareBrackets(name);
                if (db.startsWith(DEFDB)) {
                    db = Token.getStringAfter(db, "=").trim();
                }
                if (db.toUpperCase().startsWith("N'")) {
                    db = db.substring(1);
                }
                if (db.startsWith("'")) {
                    db = Token.getValBetweenQuotationMarks(db);
                }
                db = Token.getValBetweenSquareBrackets(db);
                LoginSqlServer login = (LoginSqlServer)this.stoDesign.getLoginSet().getByName(name);
                if (login != null) {
                    login.setDefaultDatabase((DataBaseSqlServer)this.stoDesign.getDataBaseSet().getByName(db));
                }
            } else {
                LOGGER.error("LoginSqlServer.initDefaultDB(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax defining default db " + exp);
            }
        }
    }

    private void initDefaultLanguage(String statement) {
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            String exp = Token.getStringAfter(this.statement, "sp_defaultlanguage").trim();
            StringTokenizer tokenizer = new StringTokenizer(exp, ",");
            try {
                String name = tokenizer.nextToken().trim();
                String language = tokenizer.nextToken().trim();
                if (name.startsWith(LOGINAME)) {
                    name = Token.getStringAfter(name, "=").trim();
                }
                if (name.toUpperCase().startsWith("N'")) {
                    name = name.substring(1);
                }
                if (name.startsWith("'")) {
                    name = Token.getValBetweenQuotationMarks(name);
                }
                name = Token.getValBetweenSquareBrackets(name);
                if (language.startsWith(LANGUAGE)) {
                    language = Token.getStringAfter(language, "=").trim();
                }
                if (language.toUpperCase().startsWith("N'")) {
                    language = language.substring(1);
                }
                if (language.startsWith("'")) {
                    language = Token.getValBetweenQuotationMarks(language);
                }
                language = Token.getValBetweenSquareBrackets(language);
                LoginSqlServer login = (LoginSqlServer)this.stoDesign.getLoginSet().getByName(name);
                if (login != null) {
                    login.setLanguage(language);
                }
            }
            catch (NoSuchElementException e) {
                LOGGER.error("LoginSqlServer.initDefaultLanguage(): wrong syntax!", e);
                this.importLog.addWarning("Wrong syntax defining default language " + exp);
            }
        }
    }

    private void initUsers(String statement) {
        if (this.getCurrentDB() != null) {
            this.statement = statement;
            this.site = this.design.getSelectedRDBMSSite();
            this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
            if (this.stoDesign != null) {
                String exp = Token.getStringAfter(this.statement, "sp_grantdbaccess").trim();
                StringTokenizer tokenizer = new StringTokenizer(exp, ",");
                if (tokenizer.countTokens() == 2) {
                    String loginName = tokenizer.nextToken().trim();
                    String userName = tokenizer.nextToken().trim();
                    if (loginName.startsWith(LOGINAME)) {
                        loginName = Token.getStringAfter(loginName, "=").trim();
                    }
                    if (loginName.toUpperCase().startsWith("N'")) {
                        loginName = loginName.substring(1);
                    }
                    if (loginName.startsWith("'")) {
                        loginName = Token.getValBetweenQuotationMarks(loginName);
                    }
                    loginName = Token.getValBetweenSquareBrackets(loginName);
                    if (userName.startsWith(NAME_IN_DB)) {
                        userName = Token.getStringAfter(userName, "=").trim();
                    }
                    if (userName.toUpperCase().startsWith("N'")) {
                        userName = userName.substring(1);
                    }
                    if (userName.startsWith("'")) {
                        userName = Token.getValBetweenQuotationMarks(userName);
                    }
                    userName = Token.getValBetweenSquareBrackets(userName);
                    LoginSqlServer login = (LoginSqlServer)this.stoDesign.getLoginSet().getByName(loginName);
                    if (login != null && userName != null && !userName.trim().equalsIgnoreCase("")) {
                        if (login.getUserSet().isEmpty()) {
                            UserSqlServer user = this.stoDesign.getUserSet().createUser();
                            user.setName(userName);
                            this.design.getRelationalDesign().stampModelObjectDDL(user);
                            user.setDatabase(this.getCurrentDB());
                            user.setLogin(login);
                            login.setUsers(userName);
                        } else {
                            LoginSqlServer newLogin = this.stoDesign.getLoginSet().createLogin();
                            if (newLogin != null) {
                                newLogin.setAuthentication("WINDOWS");
                                newLogin.setName(userName);
                                this.design.getRelationalDesign().stampModelObjectDDL(newLogin);
                                UserSqlServer user = this.stoDesign.getUserSet().createUser();
                                user.setName(userName);
                                user.setDatabase(this.getCurrentDB());
                                user.setLogin(newLogin);
                                this.design.getRelationalDesign().stampModelObjectDDL(user);
                                newLogin.setUsers(userName);
                            }
                        }
                    }
                } else if (tokenizer.countTokens() != 1) {
                    LOGGER.error("LoginSqlServer.initUsers(): wrong syntax!");
                    this.importLog.addWarning("Wrong syntax defining users " + exp);
                }
            }
        }
    }
}

