/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseSqlServer
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateDatabaseSqlServer.class);
    private DataBaseSqlServer db;

    public SHCreateDatabaseSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDatabaseSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "create database")) {
            try {
                this.parseDatabase(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateDatabaseSqlServer.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseDatabase(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (storageDesign != null) {
            this.db = storageDesign.getDataBaseSet().createDataBase();
            if (this.db != null) {
                this.design.getRelationalDesign().stampModelObjectDDL(this.db);
                if (Token.hasToken(this.statement, "ON") && !Token.getTokenBefore(this.statement, "ON").equalsIgnoreCase("LOG")) {
                    ((StorageObjectCollection)this.db.getChild(0)).removeAll();
                }
                String nameDB = this.initDatabaseName();
                this.db.setName(nameDB);
                this.initOn(this.db, storageDesign);
                this.initLogOn(this.db, storageDesign);
                this.initCollate();
            }
        }
    }

    private String initDatabaseName() {
        String temp = Token.getTokenAfter(this.statement, "DATABASE").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "DATABASE", '[', ']').trim() : Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
        return name;
    }

    private void initOn(DataBaseSqlServer db, StorageDesignSqlServerv2k storageDesign) {
        if (Token.hasToken(this.statement, "ON") && !Token.getTokenBefore(this.statement, "ON").equalsIgnoreCase("LOG")) {
            String values = Token.getStringAfter(this.statement, "ON").trim();
            if (Token.hasString(values, "LOG ON")) {
                values = values.substring(0, values.toUpperCase().indexOf("LOG ON"));
            }
            FileGroupSqlServer fgroup = null;
            DataFileSqlServer datafile = null;
            String groupToken = Token.getStringBefore(values, "FILEGROUP").trim();
            values = values.substring(groupToken.length());
            if ("".equalsIgnoreCase(groupToken)) {
                groupToken = values;
            }
            String groupName = "";
            boolean lastGroup = true;
            while (!groupToken.equalsIgnoreCase("")) {
                if (groupToken.toUpperCase().startsWith("FILEGROUP")) {
                    groupToken = groupToken.substring(10);
                }
                groupName = Token.getTokenBefore(groupToken, "(");
                groupToken = groupToken.substring(groupName.length());
                if (groupName.equalsIgnoreCase("")) {
                    groupName = "PRIMARY";
                }
                String fGroupName = Token.getValBetweenSquareBrackets(groupName.trim());
                fgroup = (FileGroupSqlServer)storageDesign.getFileGroupSet().getByName(fGroupName);
                if (fgroup == null || fgroup.getDataBase() != db) {
                    fgroup = storageDesign.getFileGroupSet().createFileGroup();
                    this.design.getRelationalDesign().stampModelObjectDDL(fgroup);
                    fgroup.setDataBase(db);
                    fgroup.setName(fGroupName);
                    StorageObjectCollection groups = (StorageObjectCollection)db.getChild(0);
                    fgroup.setParent(groups);
                    groups.add(fgroup);
                }
                while (!groupToken.equalsIgnoreCase("") && Token.hasCloseAndOpenBrackets(groupToken) && !Token.getValBetweenBrackets(groupToken, 1).trim().equalsIgnoreCase("")) {
                    String log = Token.getValBetweenBrackets(groupToken, 1);
                    StringTokenizer tokens = new StringTokenizer(log, ",");
                    String token = "";
                    datafile = storageDesign.getDataFileSet().createDataFile();
                    this.design.getRelationalDesign().stampModelObjectDDL(datafile);
                    datafile.setFileGroup(fgroup);
                    StorageObjectCollection files = (StorageObjectCollection)fgroup.getChild(0);
                    datafile.setParent(files);
                    files.add(datafile);
                    if (tokens.hasMoreTokens()) {
                        token = tokens.nextToken();
                        token = this.initLogName(datafile, tokens, token);
                        token = this.initLogFileName(datafile, tokens, token);
                        token = this.initLogSize(datafile, tokens, token);
                        token = this.initLogMaxSize(datafile, tokens, token);
                        this.initLogFileGrowth(datafile, token);
                    }
                    groupToken = groupToken.trim().substring(log.length() + 2);
                }
                if (values.trim().toUpperCase().startsWith("FILEGROUP")) {
                    String tmp = values.trim().substring(10);
                    groupToken = "FILEGROUP " + Token.getStringBefore(tmp, "FILEGROUP");
                } else {
                    groupToken = Token.getStringBefore(values, "FILEGROUP").trim();
                }
                if ("".equalsIgnoreCase(groupToken)) continue;
                if ((values = values.trim().substring(groupToken.length()).trim()).startsWith(",")) {
                    values = values.substring(1).trim();
                }
                if (!groupToken.equalsIgnoreCase("") || values.equalsIgnoreCase("") || values.equalsIgnoreCase(")") || !lastGroup) continue;
                groupToken = values;
                lastGroup = false;
            }
        }
    }

    private void initLogOn(DataBaseSqlServer db, StorageDesignSqlServerv2k storageDesign) {
        if (Token.hasToken(this.statement, "LOG") && Token.getTokenAfter(this.statement, "LOG").trim().equalsIgnoreCase("ON")) {
            String values = Token.getStringAfter(this.statement, "LOG ON").trim();
            DataFileSqlServer logfile = null;
            if (Token.hasString(values, "COLLATE")) {
                values = Token.getStringBefore(values, "COLLATE");
            }
            while (!values.equalsIgnoreCase("") && !Token.getValBetweenBrackets(values, 1).trim().equalsIgnoreCase("")) {
                String log = Token.getValBetweenBrackets(values, 1);
                StringTokenizer tokens = new StringTokenizer(log, ",");
                String token = "";
                logfile = storageDesign.getDataFileSet().createDataFile();
                this.design.getRelationalDesign().stampModelObjectDDL(logfile);
                logfile.setDataBase(db);
                StorageObjectCollection logs = (StorageObjectCollection)db.getChild(1);
                logfile.setParent(logs);
                logs.add(logfile);
                if (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    token = this.initLogName(logfile, tokens, token);
                    token = this.initLogFileName(logfile, tokens, token);
                    token = this.initLogSize(logfile, tokens, token);
                    token = this.initLogMaxSize(logfile, tokens, token);
                    this.initLogFileGrowth(logfile, token);
                }
                values = values.trim().substring(log.length() + 2);
            }
        }
    }

    private String initLogName(DataFileSqlServer logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("NAME")) {
            String logname = Token.getStringAfter(token, "NAME").trim();
            if ((logname = Token.getStringAfter(logname, "=").trim()).startsWith("N'")) {
                logname = logname.substring(1);
            }
            if (logname.startsWith("'")) {
                logname = Token.getValBetweenQuotationMarks(logname);
            }
            logfile.setName(Token.getValBetweenSquareBrackets(logname));
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private String initLogFileName(DataFileSqlServer logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("FILENAME")) {
            String fname = Token.getStringAfter(token, "FILENAME").trim();
            if ((fname = Token.getStringAfter(fname, "=").trim()).startsWith("N'")) {
                fname = fname.substring(1);
            }
            if (fname.startsWith("'")) {
                fname = Token.getValBetweenQuotationMarks(fname);
            }
            logfile.setFileName(Token.getValBetweenSquareBrackets(fname));
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private String initLogSize(DataFileSqlServer logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("SIZE")) {
            String size = Token.getStringAfter(token, "SIZE");
            size = Token.getStringAfter(size, "=").trim();
            try {
                String unit = this.parseForUnit(size);
                if (!unit.equals("")) {
                    String inUnit = logfile.getSizeInUnitFromUnit(unit);
                    if (!inUnit.equals("")) {
                        logfile.setInitialSizeInUnit(inUnit);
                    }
                    size = size.substring(0, size.length() - 2).trim();
                }
                logfile.setInitialSize(Integer.parseInt(size));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Wrong format:", e);
                this.importLog.addWarning("Unknown initialial size of file " + logfile.getName());
            }
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private String initLogMaxSize(DataFileSqlServer logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("MAXSIZE")) {
            String maxsize = Token.getStringAfter(token, "MAXSIZE");
            if ((maxsize = Token.getStringAfter(maxsize, "=").trim()).equalsIgnoreCase("UNLIMITED")) {
                logfile.setIsUnlimited(true);
            } else {
                try {
                    String unit = this.parseForUnit(maxsize);
                    if (!unit.equals("")) {
                        String inUnit = logfile.getSizeInUnitFromUnit(unit);
                        if (!inUnit.equals("")) {
                            logfile.setMaxSizeInUnit(inUnit);
                        }
                        maxsize = maxsize.substring(0, maxsize.length() - 2).trim();
                    }
                    logfile.setMaxSize(Integer.parseInt(maxsize));
                    logfile.setIsUnlimited(false);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("", e);
                    this.importLog.addWarning("Unknown max size of file " + logfile.getName());
                }
            }
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private void initLogFileGrowth(DataFileSqlServer logfile, String token) {
        if (token.trim().toUpperCase().startsWith("FILEGROWTH")) {
            String filegrowth = Token.getStringAfter(token, "FILEGROWTH").trim();
            filegrowth = Token.getStringAfter(token, "=").trim();
            if (Token.hasString(filegrowth, "%")) {
                logfile.setGrowthMethod("By Percent");
                filegrowth = filegrowth.substring(0, filegrowth.length() - 1).trim();
            } else {
                logfile.setGrowthMethod("In MegaBytes");
            }
            try {
                String unit = this.parseForUnit(filegrowth);
                if (!unit.equals("")) {
                    String inUnit = logfile.getSizeInUnitFromUnit(unit);
                    if (!inUnit.equals("")) {
                        logfile.setGrowthMethod(inUnit);
                    }
                    filegrowth = filegrowth.substring(0, filegrowth.length() - 2).trim();
                }
                logfile.setGrowthValue(Integer.parseInt(filegrowth));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Wrong format:", e);
                this.importLog.addWarning("Unknown filegrowth of file " + logfile.getName());
            }
        }
    }

    private void initCollate() {
        if (Token.hasToken(this.statement, "COLLATE")) {
            String collate = Token.getStringAfter(this.statement, "COLLATE");
            this.db.setCollationName(collate);
        }
    }

    private String parseForUnit(String spec) {
        String unit;
        if (spec.length() > 2 && ((unit = spec.substring(spec.length() - 2)).equalsIgnoreCase("KB") || unit.equalsIgnoreCase("MB") || unit.equalsIgnoreCase("GB") || unit.equalsIgnoreCase("TB"))) {
            return unit;
        }
        return "";
    }
}

