/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterDatabaseSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String ADD_FILE = "add file";
    private static final Logger LOGGER = new Logger(SHAlterDatabaseSqlServer.class);
    private DataBaseSqlServer db;
    private StorageDesignSqlServerv2k storageDesign;

    public SHAlterDatabaseSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHAlterDatabaseSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "alter database")) {
            try {
                this.parseAlterDatabase(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHAlterDatabaseSqlServer.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseAlterDatabase(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            this.db = (DataBaseSqlServer)this.storageDesign.getDataBaseSet().getByName(this.initDatabaseName());
            if (this.db != null) {
                this.initFileGroup();
                this.initAddFile();
                this.initAddLogFile();
                this.initUserState();
                this.initCursorClose();
                this.initCursorDefault();
                this.initAutoClose();
                this.initAutoCreateStatistics();
                this.initAutoShrink();
                this.initAutoUpdateStatistics();
                this.initAnsiNulls();
                this.initAnsiPadding();
                this.initAnsiWarnings();
                this.initArithabort();
                this.initConcatNullYieldsNull();
                this.initNumericRoundAbort();
                this.initQuotedId();
                this.initRecursiveTriggers();
                this.initRecovery();
                this.initTornPageDetection();
            }
        }
    }

    private void initAddFile() {
        if (this.statement.toUpperCase().indexOf(ADD_FILE) > -1 && !this.statement.toLowerCase().substring(this.statement.toUpperCase().indexOf(ADD_FILE) + 8).startsWith("group")) {
            FileGroupSqlServer fgroup;
            String files = Token.getStringAfter(this.statement, ADD_FILE);
            String groupName = "";
            if (Token.hasString(files.toLowerCase(), "to filegroup ")) {
                groupName = Token.getStringAfter(files.toLowerCase(), "to filegroup ");
                files = files.substring(0, files.toLowerCase().indexOf("to filegroup "));
            }
            if (groupName.equalsIgnoreCase("")) {
                groupName = "PRIMARY";
            }
            if ((fgroup = (FileGroupSqlServer)((StorageObjectCollection)this.db.getChild(0)).getByName(groupName)) != null) {
                DataFileSqlServer datafile = null;
                while (!files.equalsIgnoreCase("") && Token.hasCloseAndOpenBrackets(files) && !Token.getValBetweenBrackets(files, 1).trim().equalsIgnoreCase("")) {
                    String file = Token.getValBetweenBrackets(files, 1);
                    StringTokenizer tokens = new StringTokenizer(file, ",");
                    String token = "";
                    if (tokens.hasMoreTokens()) {
                        token = tokens.nextToken();
                        if (token.trim().toUpperCase().startsWith("NAME")) {
                            String name = Token.getStringAfter(token, "NAME").trim();
                            if ((name = Token.getStringAfter(name, "=").trim()).startsWith("N'")) {
                                name = name.substring(1);
                            }
                            if (name.startsWith("'")) {
                                name = Token.getValBetweenQuotationMarks(name);
                            }
                            if ((datafile = (DataFileSqlServer)((StorageObjectCollection)fgroup.getChild(0)).getByName(name)) == null) {
                                datafile = this.storageDesign.getDataFileSet().createDataFile();
                                this.design.getRelationalDesign().stampModelObjectDDL(datafile);
                                datafile.setFileGroup(fgroup);
                            }
                            datafile.setName(Token.getValBetweenSquareBrackets(name));
                            if (tokens.hasMoreTokens()) {
                                token = tokens.nextToken();
                            }
                        }
                        token = this.initLogFileName(datafile, tokens, token);
                        token = this.initLogSize(datafile, tokens, token);
                        token = this.initLogMaxSize(datafile, tokens, token);
                        this.initLogFileGrouth(datafile, token);
                    }
                    files = files.trim().substring(file.length() + 2);
                }
            }
        }
    }

    private void initAddLogFile() {
        if (this.statement.toLowerCase().indexOf("add log file ") > -1) {
            String logs = Token.getStringAfter(this.statement.toLowerCase(), "add log file");
            DataFileSqlServer logfile = null;
            while (!logs.equalsIgnoreCase("") && !Token.getValBetweenBrackets(logs, 1).trim().equalsIgnoreCase("")) {
                String log = Token.getValBetweenBrackets(logs, 1);
                StringTokenizer tokens = new StringTokenizer(log, ",");
                String token = "";
                if (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    if (token.trim().toUpperCase().startsWith("NAME")) {
                        String name = Token.getStringAfter(token, "NAME").trim();
                        if ((name = Token.getStringAfter(name, "=").trim()).startsWith("N'")) {
                            name = name.substring(1);
                        }
                        if (name.startsWith("'")) {
                            name = Token.getValBetweenQuotationMarks(name);
                        }
                        if ((logfile = (DataFileSqlServer)((StorageObjectCollection)this.db.getChild(1)).getByName(name)) == null) {
                            logfile = this.storageDesign.getDataFileSet().createDataFile();
                            this.design.getRelationalDesign().stampModelObjectDDL(logfile);
                            logfile.setDataBase(this.db);
                        }
                        logfile.setName(Token.getValBetweenSquareBrackets(name));
                        if (tokens.hasMoreTokens()) {
                            token = tokens.nextToken();
                        }
                    }
                    token = this.initLogFileName(logfile, tokens, token);
                    token = this.initLogSize(logfile, tokens, token);
                    token = this.initLogMaxSize(logfile, tokens, token);
                    this.initLogFileGrouth(logfile, token);
                }
                logs = logs.trim().substring(log.length() + 2);
            }
        }
    }

    private void initFileGroup() {
        String fgroup = "";
        if (this.statement.toLowerCase().indexOf("add filegroup ") > -1 && !(fgroup = Token.getStringAfter(this.statement.toLowerCase(), "add filegroup ")).equalsIgnoreCase("")) {
            FileGroupSqlServer fg = this.storageDesign.getFileGroupSet().createFileGroup();
            this.design.getRelationalDesign().stampModelObjectDDL(fg);
            fg.setName(fgroup);
            fg.setDataBase(this.db);
        }
    }

    private void initUserState() {
        if (Token.hasToken(this.statement, "SINGLE_USER")) {
            this.db.setUserState("SINGLE_USER");
        } else if (Token.hasToken(this.statement, "RESTRICTED_USER")) {
            this.db.setUserState("RESTRICTED_USER");
        } else if (Token.hasToken(this.statement, "MULTI_USER")) {
            this.db.setUserState("MULTI_USER");
        }
    }

    private void initCursorClose() {
        if (Token.hasToken(this.statement, "CURSOR_CLOSE_ON_COMMIT")) {
            String cursorClose = Token.getTokenAfter(this.statement, "CURSOR_CLOSE_ON_COMMIT");
            this.db.setCursorCloseOnCommit(cursorClose);
        }
    }

    private void initCursorDefault() {
        if (Token.hasToken(this.statement, "CURSOR_DEFAULT")) {
            String cursorDefault = Token.getTokenAfter(this.statement, "CURSOR_DEFAULT");
            this.db.setCursorDefault(cursorDefault);
        }
    }

    private void initAutoClose() {
        if (Token.hasToken(this.statement, "AUTO_CLOSE")) {
            String autoClose = Token.getTokenAfter(this.statement, "AUTO_CLOSE");
            this.db.setAutoClose(autoClose);
        }
    }

    private void initAutoCreateStatistics() {
        if (Token.hasToken(this.statement, "AUTO_CREATE_STATISTICS")) {
            String autoCreateStatistics = Token.getTokenAfter(this.statement, "AUTO_CREATE_STATISTICS");
            this.db.setAutoCreateStatistics(autoCreateStatistics);
        }
    }

    private void initAutoShrink() {
        if (Token.hasToken(this.statement, "AUTO_SHRINK")) {
            String autoShrink = Token.getTokenAfter(this.statement, "AUTO_SHRINK");
            this.db.setAutoShrink(autoShrink);
        }
    }

    private void initAutoUpdateStatistics() {
        if (Token.hasToken(this.statement, "AUTO_UPDATE_STATISTICS")) {
            String autoUpdateStatistics = Token.getTokenAfter(this.statement, "AUTO_UPDATE_STATISTICS");
            this.db.setAutoUpdateStatistics(autoUpdateStatistics);
        }
    }

    private void initAnsiNulls() {
        if (Token.hasToken(this.statement, "ANSI_NULLS")) {
            String ansiNulls = Token.getTokenAfter(this.statement, "ANSI_NULLS");
            this.db.setAnsiNulls(ansiNulls);
        }
    }

    private void initAnsiPadding() {
        if (Token.hasToken(this.statement, "ANSI_PADDING")) {
            String ansiPadding = Token.getTokenAfter(this.statement, "ANSI_PADDING");
            this.db.setAnsiPadding(ansiPadding);
        }
    }

    private void initAnsiWarnings() {
        if (Token.hasToken(this.statement, "ANSI_WARNINGS")) {
            String ansiWarnings = Token.getTokenAfter(this.statement, "ANSI_WARNINGS");
            this.db.setAnsiWarnings(ansiWarnings);
        }
    }

    private void initArithabort() {
        if (Token.hasToken(this.statement, "ARITHABORT")) {
            String arithabort = Token.getTokenAfter(this.statement, "ARITHABORT");
            this.db.setArithabort(arithabort);
        }
    }

    private void initConcatNullYieldsNull() {
        if (Token.hasToken(this.statement, "CONCAT_NULL_YIELDS_NULL")) {
            String concatNull = Token.getTokenAfter(this.statement, "CONCAT_NULL_YIELDS_NULL");
            this.db.setConcatNullYieldsNull(concatNull);
        }
    }

    private void initNumericRoundAbort() {
        if (Token.hasToken(this.statement, "NUMERIC_ROUNDABORT")) {
            String num = Token.getTokenAfter(this.statement, "NUMERIC_ROUNDABORT");
            this.db.setNumericRoundabort(num);
        }
    }

    private void initQuotedId() {
        if (Token.hasToken(this.statement, "QUOTED_IDENTIFIER")) {
            String quotedId = Token.getTokenAfter(this.statement, "QUOTED_IDENTIFIER");
            this.db.setQuotedIdentifier(quotedId);
        }
    }

    private void initRecursiveTriggers() {
        if (Token.hasToken(this.statement, "RECURSIVE_TRIGGERS")) {
            String recTriggers = Token.getTokenAfter(this.statement, "RECURSIVE_TRIGGERS");
            this.db.setRecursiveTriggers(recTriggers);
        }
    }

    private void initRecovery() {
        if (Token.hasToken(this.statement, "RECOVERY")) {
            String recovery = Token.getTokenAfter(this.statement, "RECOVERY");
            this.db.setRecovery(recovery);
        }
    }

    private void initTornPageDetection() {
        if (Token.hasToken(this.statement, "TORN_PAGE_DETECTION")) {
            String tornPage = Token.getTokenAfter(this.statement, "TORN_PAGE_DETECTION");
            this.db.setTornPageDetection(tornPage);
        }
    }

    private String initDatabaseName() {
        String temp = Token.getTokenAfter(this.statement, "DATABASE").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "DATABASE", '[', ']').trim() : Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
        return name;
    }

    private String initLogFileName(DataFileSqlServer logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("FILENAME")) {
            String fname = Token.getStringAfter(token.toUpperCase(), "FILENAME").trim();
            if ((fname = Token.getStringAfter(fname, "=").trim()).startsWith("N'")) {
                fname = fname.substring(1);
            }
            if (fname.startsWith("'")) {
                fname = Token.getValBetweenQuotationMarks(fname);
            }
            logfile.setFileName(Token.getValBetweenSquareBrackets(fname));
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private String initLogSize(DataFileSqlServer logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("SIZE")) {
            String size = Token.getStringAfter(token, "SIZE");
            size = Token.getStringAfter(size, "=").trim();
            try {
                String unit = this.parseForUnit(size);
                if (!unit.equals("")) {
                    String inUnit = logfile.getSizeInUnitFromUnit(unit);
                    if (!inUnit.equals("")) {
                        logfile.setInitialSizeInUnit(inUnit);
                    }
                    size = size.substring(0, size.length() - 2).trim();
                }
                logfile.setInitialSize(Integer.parseInt(size));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
            }
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private String initLogMaxSize(DataFileSqlServer logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("MAXSIZE")) {
            String maxsize = Token.getStringAfter(token, "MAXSIZE");
            if ((maxsize = Token.getStringAfter(maxsize, "=").trim()).equalsIgnoreCase("UNLIMITED")) {
                logfile.setIsUnlimited(true);
            } else {
                try {
                    String unit = this.parseForUnit(maxsize);
                    if (!unit.equals("")) {
                        String inUnit = logfile.getSizeInUnitFromUnit(unit);
                        if (!inUnit.equals("")) {
                            logfile.setMaxSizeInUnit(inUnit);
                        }
                        maxsize = maxsize.substring(0, maxsize.length() - 2).trim();
                    }
                    logfile.setMaxSize(Integer.parseInt(maxsize));
                    logfile.setIsUnlimited(false);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("", e);
                    this.importLog.addWarning("Max size of file " + logfile.getName() + " is unknown");
                }
            }
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private void initLogFileGrouth(DataFileSqlServer logfile, String token) {
        if (token.trim().toUpperCase().startsWith("FILEGROWTH")) {
            String filegrowth = Token.getStringAfter(token, "FILEGROWTH").trim();
            filegrowth = Token.getStringAfter(token, "=").trim();
            if (Token.hasString(filegrowth, "%")) {
                logfile.setGrowthMethod("By Percent");
                filegrowth = filegrowth.substring(0, filegrowth.length() - 1).trim();
            } else {
                logfile.setGrowthMethod("In MegaBytes");
            }
            try {
                String unit = this.parseForUnit(filegrowth);
                if (!unit.equals("")) {
                    String inUnit = logfile.getSizeInUnitFromUnit(unit);
                    if (!inUnit.equals("")) {
                        logfile.setGrowthMethod(inUnit);
                    }
                    filegrowth = filegrowth.substring(0, filegrowth.length() - 2).trim();
                }
                logfile.setGrowthValue(Integer.parseInt(filegrowth));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Growth value of file " + logfile.getName() + " is unknown");
            }
        }
    }

    private String parseForUnit(String spec) {
        String unit;
        if (spec.length() > 2 && ((unit = spec.substring(spec.length() - 2)).equalsIgnoreCase("KB") || unit.equalsIgnoreCase("MB") || unit.equalsIgnoreCase("GB") || unit.equalsIgnoreCase("TB"))) {
            return unit;
        }
        return "";
    }
}

