/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataBaseOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RedoLogGroupOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UndoTablespaceOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseOraclev9i
extends DDLStatementHandler {
    private DataBaseOraclev9i database;
    private StorageDesignOraclev9i stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateDatabaseOraclev9i.class);

    public SHCreateDatabaseOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDatabaseOraclev9i.clearCR(line);
        if (Token.startsWithString(statement, "CREATE DATABASE")) {
            try {
                this.parseDatabase(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateDatabaseOraclev9i.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseDatabase(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(site);
        if (this.stoDesign != null) {
            this.database = (DataBaseOraclev9i)this.stoDesign.getDataBaseSet().createDataBase();
            if (this.database != null) {
                String nameDB = this.initDatabaseName();
                this.database.setName(nameDB);
                this.design.getRelationalDesign().stampModelObjectDDL(this.database);
                this.initUserSysPass();
                this.initUserSystemPass();
                this.initControlFileReuse();
                this.initLogFiles();
                this.initMaxLogFiles();
                this.initMaxLogHistory();
                this.initMaxDataFiles();
                this.initMaxInstances();
                this.initArchiveLog();
                this.initForceLogging();
                this.initCharacterSet();
                this.initNationalCharacterSet();
                this.initDataFiles();
                this.initTempTablespace();
                this.initUndoTablespace();
                this.initTimeZone();
            }
        }
    }

    private void initUserSysPass() {
        if (this.statement.toUpperCase().indexOf("USER SYS IDENTIFIED BY") > -1) {
            this.database.setPassForSYS(Token.getTokenAfter(this.statement, "USER SYS IDENTIFIED BY"));
        }
    }

    private void initUserSystemPass() {
        if (this.statement.toUpperCase().indexOf("USER SYSTEM IDENTIFIED BY") > -1) {
            this.database.setPassForSYSTEM(Token.getTokenAfter(this.statement, "USER SYSTEM IDENTIFIED BY"));
        }
    }

    private String initDatabaseName() {
        return Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
    }

    private void initControlFileReuse() {
        if (Token.hasToken(this.statement, "CONTROLFILE")) {
            this.database.setControlFileReuse("YES");
        }
    }

    private void initLogFiles() {
        if (Token.hasToken(this.statement, "LOGFILE")) {
            String[] match = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String redoLogs = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "LOGFILE"), match);
            StringTokenizer tokenizer = new StringTokenizer(redoLogs, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                RedoLogGroupOraclev9i redo = this.initRedoLogGroup(token);
                redo.setDataBase(this.database);
            }
        }
    }

    private RedoLogGroupOraclev9i initRedoLogGroup(String dfInfo) {
        if (!"".equalsIgnoreCase(dfInfo)) {
            RedoLogGroupOraclev9i logGroup = (RedoLogGroupOraclev9i)this.stoDesign.getRedoLogGroupSet().createRedoLogGroup();
            String fileName = Token.getValBetweenQuotes(dfInfo);
            logGroup.setFileName(fileName);
            this.design.getRelationalDesign().stampModelObjectDDL(logGroup);
            if (Token.hasToken(dfInfo, "SIZE")) {
                String sizeStr = Token.getTokenAfter(dfInfo, "SIZE").trim();
                try {
                    int size = Integer.parseInt(this.removeMeasureUnit(sizeStr));
                    logGroup.setSize(size);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong format in SHCreateDatabaseOraclev9i.initRedoLogGroup!", e);
                    this.importLog.addWarning("Wrong redo log group SIZE format in statement " + this.statement);
                }
                String measureUnit = this.getMeasureUnit(sizeStr, dfInfo);
                logGroup.setMeasureUnit(measureUnit);
            }
            if (Token.hasToken(dfInfo, "REUSE")) {
                logGroup.setReuse("YES");
            } else {
                logGroup.setReuse("NO");
            }
            return logGroup;
        }
        return null;
    }

    private String getMeasureUnit(String value, String dfInfo) {
        if (value.toUpperCase().endsWith("K")) {
            return "K";
        }
        if (value.toUpperCase().endsWith("M")) {
            return "M";
        }
        if (Token.getTokenAfter(dfInfo, value).equalsIgnoreCase("K")) {
            return "K";
        }
        if (Token.getTokenAfter(dfInfo, value).equalsIgnoreCase("M")) {
            return "M";
        }
        return "";
    }

    private void initMaxLogFiles() {
        if (Token.hasToken(this.statement, "MAXLOGFILES")) {
            try {
                int maxLogFiles = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXLOGFILES"));
                this.database.setMaxLogFiles(maxLogFiles);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MAXLOGFILES format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseOracle.initMaxLogFiles : " + e.getMessage());
            }
        }
    }

    private void initMaxLogHistory() {
        if (Token.hasToken(this.statement, "MAXLOGHISTORY")) {
            try {
                int maxLogHistory = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXLOGHISTORY"));
                this.database.setMaxLogHistory(maxLogHistory);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MAXLOGHISTORY format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseOracle.initMaxLogHistory : " + e.getMessage());
            }
        }
    }

    private void initMaxDataFiles() {
        if (Token.hasToken(this.statement, "MAXDATAFILES")) {
            try {
                int maxDataFiles = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXDATAFILES"));
                this.database.setMaxDataFiles(maxDataFiles);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MAXDATAFILES format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseOracle.initMaxDataFiles : " + e.getMessage());
            }
        }
    }

    private void initMaxInstances() {
        if (Token.hasToken(this.statement, "MAXINSTANCES")) {
            try {
                int maxInstances = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXINSTANCES"));
                this.database.setMaxInstances(maxInstances);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MAXINSTANCES format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseOracle.initMaxInstances : " + e.getMessage());
            }
        }
    }

    private void initDataFiles() {
        if (Token.hasToken(this.statement, "DATAFILE")) {
            String[] match = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String dataFiles = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), match);
            StringTokenizer tokenizer = new StringTokenizer(dataFiles, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                DataFileOraclev9i file = this.initDataFile(token);
                file.setDataBase(this.database);
            }
        }
    }

    private void initArchiveLog() {
        if (Token.hasToken(this.statement, "ARCHIVELOG")) {
            this.database.setArchiveLog("YES");
        } else {
            this.database.setArchiveLog("NO");
        }
    }

    private void initForceLogging() {
        if (this.statement.toUpperCase().indexOf("FORCE LOGGING") > -1) {
            this.database.setForceLogging("YES");
        }
    }

    private void initCharacterSet() {
        if (Token.hasToken(this.statement, "CHARACTER") && !"NATIONAL".equalsIgnoreCase(Token.getTokenBefore(this.statement, "CHARACTER"))) {
            String characterSet = Token.getTokenAfter(this.statement, "SET").trim();
            this.database.setCharacterSet(characterSet);
        }
    }

    private void initNationalCharacterSet() {
        if (Token.hasToken(this.statement, "NATIONAL")) {
            String line = Token.getStringAfter(this.statement, "NATIONAL");
            String nationalCharSet = Token.getTokenAfter(line, "SET").trim();
            this.database.setNationalCharacterSet(nationalCharSet);
        }
    }

    private void initTempTablespace() {
        if (this.statement.toUpperCase().indexOf("DEFAULT TEMPORARY TABLESPACE") > -1) {
            String tempTS = Token.getQuotedNameAfterToken(this.statement, "DEFAULT TEMPORARY TABLESPACE");
            TemporaryTablespaceOraclev9i temp = (TemporaryTablespaceOraclev9i)this.stoDesign.getTemporaryTablespaceSet().getByName(tempTS);
            if (temp == null) {
                temp = (TemporaryTablespaceOraclev9i)this.stoDesign.getTemporaryTablespaceSet().createTemporaryTablespace();
                temp.setName(tempTS);
                this.design.getRelationalDesign().stampModelObjectDDL(temp);
            }
            this.database.setTempTablespace(temp);
            if (Token.hasToken(this.statement, "TEMPFILE")) {
                String[] match = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
                String dataFiles = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), match);
                StringTokenizer tokenizer = new StringTokenizer(dataFiles, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    DataFileOraclev9i file = this.initDataFile(token);
                    file.setTemporaryTablespace(temp);
                }
            }
            if (Token.hasToken(this.statement, "UNIFORM")) {
                String line = Token.getStringAfterToken(this.statement, "UNIFORM");
                line = this.getNumberOnly(Token.getTokenAfter(line, "SIZE").trim());
                try {
                    temp.setUniformSize(Long.parseLong(line));
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong UNIFORM format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateDatabaseOraclev9i.initExtManagement : " + e.getMessage());
                }
            }
        }
    }

    private DataFileOraclev9i initDataFile(String dfInfo) {
        if (!"".equalsIgnoreCase(dfInfo)) {
            DataFileOraclev9i dataFile = (DataFileOraclev9i)this.stoDesign.getDataFileSet().createDataFile();
            String fileName = Token.getValBetweenQuotes(dfInfo);
            dataFile.setFileName(fileName);
            this.design.getRelationalDesign().stampModelObjectDDL(dataFile);
            if (Token.hasToken(dfInfo, "SIZE")) {
                String afterSize = Token.getStringAfter(dfInfo, "SIZE");
                String sizeStr = Token.getFirstToken(afterSize);
                try {
                    long size = Long.parseLong(this.removeMeasureUnit(sizeStr));
                    dataFile.setSize(size);
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                    LOGGER.error("wrong SIZE format in SHCreateDatabaseOraclev9i.initDataFile", e);
                }
                String measureUnit = this.getMeasureUnit(sizeStr, afterSize);
                dataFile.setMeasureUnit(measureUnit);
            }
            if (Token.hasToken(dfInfo, "REUSE")) {
                dataFile.setReuse("YES");
            } else {
                dataFile.setReuse("NO");
            }
            if (Token.hasToken(dfInfo, "AUTOEXTEND")) {
                String autoextend = Token.getTokenAfter(dfInfo, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("ON");
                    if (Token.hasToken(dfInfo, "NEXT")) {
                        String afterNext = Token.getStringAfter(dfInfo, "NEXT");
                        String nextStr = Token.getFirstToken(afterNext);
                        try {
                            int size = Integer.parseInt(this.removeMeasureUnit(nextStr));
                            dataFile.setNextBlockSize(size);
                        }
                        catch (NumberFormatException e) {
                            this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                            LOGGER.error("wrong NEXT format in SHCreateDatabaseOraclev9i.initDataFile", e);
                        }
                        String nextUnit = this.getMeasureUnit(nextStr, afterNext);
                        dataFile.setNextBlockSizeUnit(nextUnit);
                    }
                    if (Token.hasToken(dfInfo, "MAXSIZE")) {
                        String afterMaxsize = Token.getStringAfter(dfInfo, "MAXSIZE");
                        String maxsizeStr = Token.getFirstToken(afterMaxsize);
                        if (maxsizeStr.equalsIgnoreCase("UNLIMITED")) {
                            dataFile.setMaxSize("UNLIMITED");
                        } else {
                            try {
                                String noUnit = this.removeMeasureUnit(maxsizeStr);
                                Long.parseLong(noUnit);
                                dataFile.setMaxSize(noUnit);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("wrong MAXSIZE format in SHCreateDatabaseOraclev9i.initDataFile", e);
                                this.importLog.addWarning("Wrong MAXSIZE format in statement " + this.statement);
                            }
                            String maxsizeUnit = this.getMeasureUnit(maxsizeStr, afterMaxsize);
                            dataFile.setMaxSizeUnit(maxsizeUnit);
                        }
                    }
                } else if ("OFF".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("OFF");
                }
            }
            return dataFile;
        }
        return null;
    }

    private String removeMeasureUnit(String value) {
        if (value.toUpperCase().endsWith("K") || value.toUpperCase().endsWith("M")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private void initUndoTablespace() {
        if (this.statement.toUpperCase().indexOf("UNDO TABLESPACE") > -1) {
            String undoTS = Token.getQuotedNameAfterToken(this.statement, "UNDO TABLESPACE");
            UndoTablespaceOraclev9i undo = (UndoTablespaceOraclev9i)this.stoDesign.getUndoTablespaceSet().getByName(undoTS);
            if (undo == null) {
                undo = (UndoTablespaceOraclev9i)this.stoDesign.getUndoTablespaceSet().createTablespace();
                undo.setName(undoTS);
                this.design.getRelationalDesign().stampModelObjectDDL(undo);
            }
            this.database.setUndoTablespace(undo);
            if (Token.hasToken(this.statement, "TEMPFILE")) {
                String[] match = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
                String dataFiles = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), match);
                StringTokenizer tokenizer = new StringTokenizer(dataFiles, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    DataFileOraclev9i file = this.initDataFile(token);
                    file.setUndoTablespace(undo);
                }
            }
        }
    }

    private void initTimeZone() {
        if (Token.hasToken(this.statement, "TIME_ZONE")) {
            String time = Token.getStringAfterToken(this.statement, "TIME_ZONE");
            if ((time = Token.cutFirstToken(time)).startsWith("'")) {
                this.database.setTimeZone(Token.getValBetweenQuotationMarks(time));
            }
        }
    }
}

