/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.util.logging.Logger;

public class SHColumnElementsOraclev10g
implements StatementsConstants {
    private Map mapElementsColumn;
    private String statement;
    private static final Logger LOGGER = new Logger(SHColumnElementsOraclev10g.class);
    private final String[] afterDefaultWords = new String[]{"ENCRYPT", "CONSTRAINT", "NOT NULL", "NULL", "UNIQUE", "PRIMARY KEY", "REFERENCES", "CHECK", "SCOPE IS", "WITH ROWID"};
    private final String[] constraintStartWords = new String[]{"CONSTRAINT", "NOT NULL", "UNIQUE", "PRIMARY KEY", "REFERENCES", "CHECK", "SCOPE IS"};

    private void parseColumns(String columnStatement, RDBMSType dbType) {
        this.statement = columnStatement.trim();
        this.mapElementsColumn = new HashMap();
        try {
            if (this.statement.toUpperCase(Locale.ROOT).startsWith("PERIOD FOR")) {
                this.processValidTimeDimension();
            } else if (!this.initColumnName(dbType)) {
                this.initPrimaryKeyOrUnique();
                this.initConstraintCheck();
            }
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + columnStatement + " for Oracle failed!", e);
        }
    }

    private void processValidTimeDimension() {
        String betweenBrackets;
        this.mapElementsColumn.put("columnname", "");
        this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.FALSE);
        this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
        this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
        String periodClause = Token.getStringAfter(this.statement, "PERIOD FOR");
        String name = Token.getFirstName(periodClause, '\"', '\"');
        this.mapElementsColumn.put("VALID_TIME_NAME", name);
        if (periodClause.startsWith("\"")) {
            this.mapElementsColumn.put("VALID_TIME_NAME_QUOTED", Boolean.TRUE);
        }
        if ((betweenBrackets = Token.getValBetweenBrackets(periodClause = Token.cutFirstToken2(periodClause), 1).trim()).length() > 0) {
            String startTimeColName = Token.getFirstName(betweenBrackets, '\"', '\"');
            this.mapElementsColumn.put("VALID_TIME_START_COL", startTimeColName);
            int commaIndex = betweenBrackets.indexOf(44, startTimeColName.length());
            if (commaIndex > 0) {
                String endTimeColName = Token.getFirstName(betweenBrackets.substring(commaIndex + 1), '\"', '\"');
                this.mapElementsColumn.put("VALID_TIME_END_COL", endTimeColName);
            }
        }
    }

    private boolean initColumnName(RDBMSType dbType) {
        String beforeBracket;
        int bracketIndex;
        boolean isConstraint = false;
        String firstToken = Token.getFirstToken(this.statement).toUpperCase(Locale.ROOT);
        if ((firstToken.equals("CONSTRAINT") || firstToken.equals("PRIMARY") || firstToken.equals("UNIQUE") || firstToken.equals("FOREIGN") || firstToken.equals("CHECK") || firstToken.equals("SCOPE") || firstToken.equals("REF")) && (bracketIndex = this.statement.indexOf("(")) > -1 && ((beforeBracket = this.statement.substring(0, bracketIndex).trim().toUpperCase(Locale.ROOT)).endsWith("PRIMARY KEY") || beforeBracket.endsWith("UNIQUE") || beforeBracket.endsWith("FOREIGN KEY") || beforeBracket.endsWith("CHECK") || beforeBracket.endsWith("SCOPE FOR") || beforeBracket.endsWith("REF"))) {
            isConstraint = true;
        }
        if (!isConstraint) {
            this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.FALSE);
            String columnName = "";
            if (this.statement.startsWith("\"")) {
                this.mapElementsColumn.put("COL_NAME_QUOTED", Boolean.TRUE);
                columnName = Token.getValBetweenDoubleQuotes(this.statement);
                this.statement = Token.getStringAfter(this.statement, columnName);
                this.statement = Token.cutFirstToken(this.statement);
            } else {
                columnName = Token.getFirstToken(this.statement).trim();
                this.statement = Token.getStringAfter(this.statement, columnName);
            }
            this.mapElementsColumn.put("columnname", columnName);
            this.initDatatype(dbType);
            this.skipSort();
            this.initVisible();
            if (this.isIdentity()) {
                this.initIdentity();
                this.mapElementsColumn.put("COMPUTED", Boolean.FALSE);
                this.mapElementsColumn.put("IS DEFAULT", Boolean.FALSE);
            } else {
                this.initVirtualCol();
                this.initWithDefault();
            }
            this.initEncrypt();
            this.initNotNull();
            this.initPrimaryKeyOrUnique();
            this.initReferences();
            this.initConstraintCheck();
            this.initWithRowid();
            return true;
        }
        this.mapElementsColumn.put("columnname", "");
        this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.TRUE);
        return false;
    }

    private void skipSort() {
        if (Token.getFirstToken(this.statement).equalsIgnoreCase("SORT")) {
            this.statement = Token.cutTokenFromFront(this.statement, "SORT");
        }
    }

    private void initVisible() {
        String firstToken = Token.getFirstToken(this.statement);
        if (firstToken.equalsIgnoreCase("INVISIBLE")) {
            this.mapElementsColumn.put("INVISIBLE", Boolean.TRUE);
            this.statement = Token.cutTokenFromFront(this.statement, firstToken);
        } else if (firstToken.equalsIgnoreCase("VISIBLE")) {
            this.statement = Token.cutTokenFromFront(this.statement, firstToken);
        }
    }

    private boolean isIdentity() {
        String afterGenerated = Token.getStringAfter(this.statement, "GENERATED");
        return afterGenerated.length() > 0 && afterGenerated.toUpperCase(Locale.ROOT).indexOf("AS IDENTITY") > -1;
    }

    private void initIdentity() {
        this.mapElementsColumn.put("IDENTITY", Boolean.TRUE);
        this.statement = Token.getStringAfter(this.statement, "GENERATED");
        String nextToken = Token.getFirstToken(this.statement);
        if (nextToken.equalsIgnoreCase("ALWAYS")) {
            this.mapElementsColumn.put("GENERATED", "ALWAYS");
        } else if (nextToken.equalsIgnoreCase("BY")) {
            this.mapElementsColumn.put("GENERATED", "BY DEFAULT");
            String afterBy = Token.cutTokenFromFront(this.statement, "BY");
            if (afterBy.toUpperCase(Locale.ROOT).startsWith("DEFAULT ON NULL")) {
                this.mapElementsColumn.put("DEFAULT ON NULL", Boolean.TRUE);
            }
        }
        this.statement = Token.getStringAfter(this.statement, "IDENTITY");
        if (this.statement.startsWith("(")) {
            String identityOptions = Token.getValBetweenBrackets(this.statement, 1).toUpperCase(Locale.ROOT);
            if (identityOptions.indexOf("START") > -1) {
                String startWith = Token.getTokenAfter(identityOptions, "WITH");
                this.mapElementsColumn.put("START", startWith);
            }
            if (identityOptions.indexOf("INCREMENT") > -1) {
                String increment = Token.getTokenAfter(identityOptions, "BY");
                this.mapElementsColumn.put("INCREMENT", increment);
            }
            if (identityOptions.indexOf("NOCACHE") > -1) {
                this.mapElementsColumn.put("CACHE", "NO");
            } else {
                String cache = Token.getTokenAfter(identityOptions, "CACHE");
                this.mapElementsColumn.put("CACHE", cache);
            }
            if (Token.hasToken(identityOptions, "CYCLE")) {
                this.mapElementsColumn.put("CYCLE", "YES");
            }
            if (Token.hasToken(identityOptions, "MAXVALUE")) {
                String maxValue = Token.getTokenAfter(identityOptions, "MAXVALUE");
                this.mapElementsColumn.put("MAXVALUE", maxValue);
            }
            if (Token.hasToken(identityOptions, "MINVALUE")) {
                String minValue = Token.getTokenAfter(identityOptions, "MINVALUE");
                this.mapElementsColumn.put("MINVALUE", minValue);
            }
            if (Token.hasToken(identityOptions, "ORDER")) {
                this.mapElementsColumn.put("ORDER", "YES");
            }
            this.statement = Token.getValAfterBrackets(this.statement, 1);
        }
    }

    private void initVirtualCol() {
        if (Token.getFirstToken(this.statement).equalsIgnoreCase("GENERATED")) {
            this.statement = Token.cutTokenFromFront(this.statement, "GENERATED");
            if (Token.getFirstToken(this.statement).equalsIgnoreCase("ALWAYS")) {
                this.statement = Token.cutTokenFromFront(this.statement, "ALWAYS");
            }
        }
        if (Token.getFirstToken(this.statement).equalsIgnoreCase("AS")) {
            this.statement = Token.cutTokenFromFront(this.statement, "AS");
            this.mapElementsColumn.put("COMPUTED", Boolean.TRUE);
            this.mapElementsColumn.put("FORMULA", Token.getValBetweenBrackets(this.statement, 1).trim());
            this.statement = Token.getValAfterBrackets(this.statement, 1);
            if (Token.getFirstToken(this.statement).equalsIgnoreCase("VIRTUAL")) {
                this.statement = Token.cutTokenFromFront(this.statement, "VIRTUAL");
            }
        } else {
            this.mapElementsColumn.put("COMPUTED", Boolean.FALSE);
        }
    }

    private void initDatatype(RDBMSType dbType) {
        String dtName = this.statement;
        String dtype = this.searchWhichDatatype(this.statement, dbType);
        if (dtype != null) {
            String datatype = StandardDatatypeNames.getUsedDatatypeName(dtype);
            if ((datatype = StandardDatatypeNames.getTransformedDatatypeName(datatype, dbType)) != null) {
                this.mapElementsColumn.put("datatype", datatype);
                if (dtype.startsWith("TIMESTAMP")) {
                    String precision = "6";
                    this.statement = Token.cutTokenFromFront(this.statement, "TIMESTAMP");
                    if (this.statement.startsWith("(")) {
                        precision = Token.getValBetweenBrackets(this.statement, 1).trim();
                        this.statement = Token.getValAfterBrackets(this.statement, 1).trim();
                    }
                    if (dtype.endsWith("ZONE")) {
                        this.statement = Token.getStringAfter(this.statement, "ZONE");
                    }
                    this.mapElementsColumn.put("precision", precision);
                } else if (dtype.equals("INTERVAL YEAR TO MONTH")) {
                    String precision = "2";
                    this.statement = Token.getStringAfter(this.statement, "YEAR");
                    if (this.statement.startsWith("(")) {
                        precision = Token.getValBetweenBrackets(this.statement, 1).trim();
                    }
                    this.statement = Token.getStringAfter(this.statement, "MONTH");
                    this.mapElementsColumn.put("precision", precision);
                } else if (dtype.equals("INTERVAL DAY TO SECOND")) {
                    String dayPrecision = "2";
                    String secondsPrecision = "6";
                    this.statement = Token.getStringAfter(this.statement, "DAY");
                    if (this.statement.startsWith("(")) {
                        dayPrecision = Token.getValBetweenBrackets(this.statement, 1).trim();
                    }
                    this.statement = Token.getStringAfter(this.statement, "SECOND");
                    if (this.statement.startsWith("(")) {
                        secondsPrecision = Token.getValBetweenBrackets(this.statement, 1).trim();
                        this.statement = Token.getValAfterBrackets(this.statement, 1).trim();
                    }
                    this.mapElementsColumn.put("precision", dayPrecision);
                    this.mapElementsColumn.put("scale", secondsPrecision);
                } else {
                    this.statement = Token.cutTokenFromFront(this.statement, dtype);
                    if (this.statement.startsWith("(")) {
                        String parameters = Token.getValBetweenBrackets(this.statement, 1);
                        int positionKomma = parameters.indexOf(",");
                        if (positionKomma != -1) {
                            this.mapElementsColumn.put("size", "0");
                            this.mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                            this.mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                        } else if (StandardDatatypeNames.isPackedSized(datatype)) {
                            this.mapElementsColumn.put("size", "0");
                            this.mapElementsColumn.put("precision", parameters.trim());
                            this.mapElementsColumn.put("scale", "0");
                        } else {
                            this.mapElementsColumn.put("size", parameters.trim());
                            this.mapElementsColumn.put("precision", "0");
                            this.mapElementsColumn.put("scale", "0");
                        }
                        this.statement = Token.getValAfterBrackets(this.statement, 1).trim();
                    }
                }
            }
        } else {
            this.mapElementsColumn.put(NameElements.COL_STRUCTURED_TYPE, dtName);
        }
    }

    protected String searchWhichDatatype(String statement, RDBMSType dbType) {
        String statementUpper = statement.toUpperCase(Locale.ROOT);
        if (Token.getFirstToken(statementUpper).equals("INTERVAL")) {
            if (Token.cutTokenFromFront(statementUpper, "INTERVAL").startsWith("YEAR")) {
                return "INTERVAL YEAR TO MONTH";
            }
            return "INTERVAL DAY TO SECOND";
        }
        if (statementUpper.startsWith("SYS.XMLTYPE")) {
            return "XMLTYPE";
        }
        if (statementUpper.startsWith("DOUBLE PRECISION")) {
            return "DOUBLE PRECISION";
        }
        String[] names = StandardDatatypeNames.getAllPossibleDatatypes(dbType.getName());
        for (int number = 0; number < names.length; ++number) {
            String name = names[number];
            boolean isTrue = statementUpper.startsWith(name.toUpperCase(Locale.ROOT));
            if (!isTrue) continue;
            try {
                char nextChar = statement.charAt(name.length());
                isTrue = nextChar == '(' || nextChar == ' ' || nextChar == '\n' || nextChar == '\t' || nextChar == ')';
            }
            catch (StringIndexOutOfBoundsException e) {
                isTrue = true;
            }
            if (!isTrue) continue;
            if (name.equals("TIMESTAMP")) {
                if (Token.hasString(statementUpper, "WITH LOCAL TIME ZONE")) {
                    name = "TIMESTAMP WITH LOCAL TIME ZONE";
                } else if (Token.hasString(statementUpper, "WITH TIME ZONE")) {
                    name = "TIMESTAMP WITH TIME ZONE";
                }
            }
            return name;
        }
        return null;
    }

    private void initEncrypt() {
        if (Token.hasToken(this.statement, "ENCRYPT")) {
            int endQuoteIndex;
            int endQuoteIndex2;
            String afterUsing;
            this.mapElementsColumn.put("ENCRYPT", Boolean.TRUE);
            String afterEncrypt = Token.getStringAfterToken(this.statement, "ENCRYPT");
            if (Token.getFirstToken(afterEncrypt).equalsIgnoreCase("USING") && (afterUsing = Token.cutTokenFromFront(afterEncrypt, "USING")).startsWith("'") && (endQuoteIndex2 = afterUsing.indexOf("'", 1)) > 0) {
                this.mapElementsColumn.put("ENCRYPT_ALGORITHM", afterUsing.substring(1, endQuoteIndex2));
                afterEncrypt = afterUsing.substring(endQuoteIndex2 + 1).trim();
            }
            if (afterEncrypt.toUpperCase(Locale.ROOT).startsWith("IDENTIFIED BY")) {
                afterEncrypt = Token.cutFirstToken(afterEncrypt.substring(13));
            }
            if (afterEncrypt.startsWith("'") && (endQuoteIndex = afterEncrypt.indexOf("'", 1)) > 0) {
                this.mapElementsColumn.put("INTEGRITY_ALGORITHM", afterEncrypt.substring(1, endQuoteIndex));
                afterEncrypt = afterEncrypt.substring(endQuoteIndex + 1);
            }
            if (Token.hasToken(afterEncrypt, "SALT")) {
                if (Token.hasString(afterEncrypt.toUpperCase(Locale.ROOT), "NO SALT")) {
                    this.mapElementsColumn.put("SALT", "NO");
                } else {
                    this.mapElementsColumn.put("SALT", "YES");
                }
            }
        }
    }

    private void initNotNull() {
        boolean notNull = this.statement.toUpperCase(Locale.ROOT).indexOf("NOT NULL") > -1;
        this.mapElementsColumn.put("NOT NULL", notNull ? Boolean.TRUE : Boolean.FALSE);
        if (notNull) {
            String str;
            String beforeNotNull = Token.getStringBeforeToken(this.statement, "NOT NULL");
            if ((beforeNotNull = Token.getStringAfterToken(beforeNotNull, "CONSTRAINT")).length() > 0) {
                while (Token.hasToken(beforeNotNull, "CONSTRAINT")) {
                    beforeNotNull = Token.getStringAfterToken(beforeNotNull, "CONSTRAINT");
                }
                if (beforeNotNull.indexOf(32) == -1 || beforeNotNull.startsWith("\"") && beforeNotNull.indexOf("\"", 1) == beforeNotNull.length() - 1) {
                    this.mapElementsColumn.put("NN_CONSTRAINT_NAME", Token.getName(beforeNotNull));
                }
            }
            String line = Token.getStringAfter(this.statement, "NOT NULL");
            if (Token.hasToken(line = Token.getStringToFirstMatch(line, this.constraintStartWords), "DEFERRABLE")) {
                str = Token.getTokenBefore(line, "DEFERRABLE");
                boolean deferrable = !str.equalsIgnoreCase("NOT");
                this.mapElementsColumn.put("NN_DEFERRABLE", deferrable ? Boolean.TRUE : Boolean.FALSE);
            }
            if ((str = Token.getStringAfter(line, "INITIALLY")).length() > 0) {
                String initially = Token.getFirstToken(str);
                this.mapElementsColumn.put("NN_INITIALLY", initially);
            }
            if (Token.hasToken(line, "RELY")) {
                this.mapElementsColumn.put("NN_RELY", Boolean.TRUE);
            } else if (Token.hasToken(line, "NORELY")) {
                this.mapElementsColumn.put("NN_RELY", Boolean.FALSE);
            }
            if (Token.hasToken(line, "DISABLE")) {
                this.mapElementsColumn.put("NN_DISABLE", Boolean.TRUE);
                this.mapElementsColumn.put("NN_NOVALIDATE", Boolean.TRUE);
            } else if (Token.hasToken(line, "ENABLE")) {
                this.mapElementsColumn.put("NN_DISABLE", Boolean.FALSE);
            }
            if (Token.hasToken(line, "NOVALIDATE")) {
                this.mapElementsColumn.put("NN_NOVALIDATE", Boolean.TRUE);
            } else if (Token.hasToken(line, "VALIDATE")) {
                this.mapElementsColumn.put("NN_NOVALIDATE", Boolean.FALSE);
            }
            str = Token.getStringAfter(line, "EXCEPTIONS");
            if (!"".equals(str)) {
                String tableName = Token.getNameAfterToken(str, "INTO", '\"', '\"');
                this.mapElementsColumn.put("NN_EXCEPTIONS", tableName);
            }
        } else if (Token.hasToken(this.statement, "NULL")) {
            this.mapElementsColumn.put("NULL", Boolean.TRUE);
        }
    }

    private void initPrimaryKeyOrUnique() {
        boolean primary;
        boolean unique = false;
        boolean bl = primary = this.statement.toUpperCase(Locale.ROOT).indexOf("PRIMARY KEY") > -1;
        if (primary) {
            String constName = Token.getStringBeforeToken(this.statement, "PRIMARY");
            if ((constName = Token.getStringAfterToken(constName, "CONSTRAINT")).length() > 0) {
                while (Token.hasToken(constName, "CONSTRAINT")) {
                    constName = Token.getStringAfterToken(constName, "CONSTRAINT");
                }
                if (constName.startsWith("\"")) {
                    if (constName.indexOf("\"", 1) == constName.length() - 1) {
                        this.mapElementsColumn.put("PKUK_CONSTRAINT_NAME_QUOTED", Boolean.TRUE);
                        constName = Token.getName(constName);
                    } else {
                        constName = "";
                    }
                } else if (constName.indexOf(32) > -1) {
                    constName = "";
                }
            }
            this.mapElementsColumn.put("PKUK_CONSTRAINT_NAME", constName);
            String line = Token.getStringAfter(this.statement, "PRIMARY KEY");
            if (line.startsWith("(")) {
                String values = Token.getValBetweenBrackets(line, 1).trim();
                this.mapElementsColumn.put("VALUES", values);
                line = Token.getValAfterBrackets(line, 1).trim();
            } else {
                this.mapElementsColumn.put("VALUES", this.mapElementsColumn.get("columnname"));
            }
            line = Token.getStringToFirstMatch(line, this.constraintStartWords);
            boolean isPK = false;
            if (!"".equalsIgnoreCase(line)) {
                String str;
                isPK = true;
                if (Token.hasToken(line, "DEFERRABLE")) {
                    str = Token.getTokenBefore(line, "DEFERRABLE");
                    boolean deferrable = !str.equalsIgnoreCase("NOT");
                    this.mapElementsColumn.put("PKUK_DEFERRABLE", deferrable ? Boolean.TRUE : Boolean.FALSE);
                }
                if ((str = Token.getStringAfter(line, "INITIALLY")).length() > 0) {
                    String initially = Token.getFirstToken(str);
                    this.mapElementsColumn.put("PKUK_INITIALLY", initially);
                }
                if (Token.hasToken(line, "DISABLE")) {
                    this.mapElementsColumn.put("PKUK_DISABLE", Boolean.TRUE);
                    this.mapElementsColumn.put("PKUK_NOVALIDATE", Boolean.TRUE);
                } else if (Token.hasToken(line, "ENABLE")) {
                    this.mapElementsColumn.put("PKUK_DISABLE", Boolean.FALSE);
                }
                if (Token.hasToken(line, "NOVALIDATE")) {
                    this.mapElementsColumn.put("PKUK_NOVALIDATE", Boolean.TRUE);
                } else if (Token.hasToken(line, "VALIDATE")) {
                    this.mapElementsColumn.put("PKUK_NOVALIDATE", Boolean.FALSE);
                }
                str = Token.getStringAfter(line, "EXCEPTIONS");
                if (!"".equals(str)) {
                    String tableName = Token.getNameAfterToken(str, "INTO", '\"', '\"');
                    this.mapElementsColumn.put("PKUK_EXCEPTIONS", tableName);
                }
            }
            this.mapElementsColumn.put("IS_PK_CONSTRAINT", isPK ? Boolean.TRUE : Boolean.FALSE);
        } else {
            unique = Token.hasToken(this.statement, "UNIQUE");
            if (unique) {
                String constName = Token.getStringBeforeToken(this.statement, "UNIQUE");
                if ((constName = Token.getStringAfterToken(constName, "CONSTRAINT")).length() > 0) {
                    while (Token.hasToken(constName, "CONSTRAINT")) {
                        constName = Token.getStringAfterToken(constName, "CONSTRAINT");
                    }
                    if (constName.startsWith("\"")) {
                        if (constName.indexOf("\"", 1) == constName.length() - 1) {
                            this.mapElementsColumn.put("PKUK_CONSTRAINT_NAME_QUOTED", Boolean.TRUE);
                            constName = Token.getName(constName);
                        } else {
                            constName = "";
                        }
                    } else if (constName.indexOf(32) > -1) {
                        constName = "";
                    }
                }
                this.mapElementsColumn.put("PKUK_CONSTRAINT_NAME", constName);
                String line = Token.getStringAfter(this.statement, "UNIQUE");
                if (line.startsWith("(")) {
                    String values = Token.getValBetweenBrackets(line, 1).trim();
                    this.mapElementsColumn.put("VALUES", values);
                    line = Token.getValAfterBrackets(line, 1).trim();
                } else {
                    this.mapElementsColumn.put("VALUES", this.mapElementsColumn.get("columnname"));
                }
                line = Token.getStringToFirstMatch(line, this.constraintStartWords);
                if (!"".equalsIgnoreCase(line)) {
                    String str;
                    if (Token.hasToken(line, "DEFERRABLE")) {
                        str = Token.getTokenBefore(line, "DEFERRABLE");
                        boolean deferrable = !str.equalsIgnoreCase("NOT");
                        this.mapElementsColumn.put("PKUK_DEFERRABLE", deferrable ? Boolean.TRUE : Boolean.FALSE);
                    }
                    if ((str = Token.getStringAfter(line, "INITIALLY")).length() > 0) {
                        String initially = Token.getFirstToken(str);
                        this.mapElementsColumn.put("PKUK_INITIALLY", initially);
                    }
                    if (Token.hasToken(line, "DISABLE")) {
                        this.mapElementsColumn.put("PKUK_DISABLE", Boolean.TRUE);
                        this.mapElementsColumn.put("PKUK_NOVALIDATE", Boolean.TRUE);
                    } else if (Token.hasToken(line, "ENABLE")) {
                        this.mapElementsColumn.put("PKUK_DISABLE", Boolean.FALSE);
                    }
                    if (Token.hasToken(line, "NOVALIDATE")) {
                        this.mapElementsColumn.put("PKUK_NOVALIDATE", Boolean.TRUE);
                    } else if (Token.hasToken(line, "VALIDATE")) {
                        this.mapElementsColumn.put("PKUK_NOVALIDATE", Boolean.FALSE);
                    }
                    str = Token.getStringAfter(line, "EXCEPTIONS");
                    if (!"".equals(str)) {
                        String tableName = Token.getNameAfterToken(str, "INTO", '\"', '\"');
                        this.mapElementsColumn.put("PKUK_EXCEPTIONS", tableName);
                    }
                }
            }
        }
        this.mapElementsColumn.put("PRIMARY KEY", primary ? Boolean.TRUE : Boolean.FALSE);
        this.mapElementsColumn.put("UNIQUE", unique ? Boolean.TRUE : Boolean.FALSE);
        if (primary || unique) {
            this.initUsingIndex();
        }
    }

    private void initWithDefault() {
        boolean hasDefault = Token.hasToken(this.statement, "DEFAULT");
        if (hasDefault) {
            String defaultValue;
            String afterDefault = Token.getStringAfter(this.statement, "DEFAULT");
            if (Token.getFirstToken(afterDefault).equalsIgnoreCase("ON") && Token.getToken(afterDefault, 2).equalsIgnoreCase("NULL")) {
                this.mapElementsColumn.put("DEFAULT ON NULL", Boolean.TRUE);
                afterDefault = Token.getStringAfter(afterDefault, "NULL");
            }
            if ((defaultValue = Token.getFirstTextLiteral(afterDefault)).equals("")) {
                String strAfter;
                if (afterDefault.startsWith("(")) {
                    defaultValue = "(" + Token.getValBetweenBrackets(afterDefault, 1) + ")";
                    strAfter = Token.getValAfterBrackets(afterDefault, 1).trim();
                } else {
                    defaultValue = Token.getFirstToken(afterDefault);
                    strAfter = afterDefault.substring(defaultValue.length()).trim();
                    if (strAfter.startsWith("(")) {
                        defaultValue = defaultValue + "(" + Token.getValBetweenBrackets(strAfter, 1) + ")";
                        strAfter = Token.getValAfterBrackets(strAfter, 1).trim();
                    }
                }
                if (strAfter.length() > 0) {
                    String moreDefault = Token.getStringToFirstMatch(strAfter, this.afterDefaultWords);
                    if (Token.hasToken(moreDefault, "CHECK")) {
                        moreDefault = Token.getStringBeforeToken(moreDefault, "CHECK");
                    }
                    if (!moreDefault.isEmpty()) {
                        defaultValue = defaultValue + ' ' + moreDefault;
                    }
                }
            }
            this.statement = Token.getStringAfter(this.statement, "DEFAULT");
            this.mapElementsColumn.put("IS DEFAULT", Boolean.TRUE);
            this.mapElementsColumn.put("DEFAULT", defaultValue);
        } else {
            this.mapElementsColumn.put("IS DEFAULT", Boolean.FALSE);
        }
    }

    private void initConstraintCheck() {
        boolean hasCheckConstraint = Token.hasToken(this.statement, "CHECK");
        if (hasCheckConstraint) {
            String str;
            String checkName = Token.getStringBeforeToken(this.statement, "CHECK");
            if ((checkName = Token.getStringAfterToken(checkName, "CONSTRAINT")).length() > 0) {
                while (Token.hasToken(checkName, "CONSTRAINT")) {
                    checkName = Token.getStringAfterToken(checkName, "CONSTRAINT");
                }
                if (checkName.startsWith("\"")) {
                    if (checkName.indexOf("\"", 1) == checkName.length() - 1) {
                        this.mapElementsColumn.put("CHK_NAME_QUOTED", Boolean.TRUE);
                        checkName = Token.getName(checkName);
                    } else {
                        checkName = "";
                    }
                } else if (checkName.indexOf(32) > -1) {
                    checkName = "";
                }
            }
            this.mapElementsColumn.put("CHECK_CONSTRAINT", checkName);
            String temp = Token.getStringAfter(this.statement, "CHECK");
            String check = Token.getValBetweenBrackets(temp, 1).trim();
            this.mapElementsColumn.put("CHECK", check);
            temp = Token.getValAfterBrackets(temp, 1);
            temp = Token.getStringToFirstMatch(temp, this.constraintStartWords);
            if (Token.hasToken(temp, "DEFERRABLE")) {
                str = Token.getTokenBefore(temp, "DEFERRABLE");
                boolean deferrable = !str.equalsIgnoreCase("NOT");
                this.mapElementsColumn.put("CHK_DEFERRABLE", deferrable ? Boolean.TRUE : Boolean.FALSE);
            }
            if ((str = Token.getStringAfter(temp, "INITIALLY")).length() > 0) {
                String initially = Token.getFirstToken(str);
                this.mapElementsColumn.put("CHK_INITIALLY", initially);
            }
            if (Token.hasToken(temp, "DISABLE")) {
                this.mapElementsColumn.put("CHK_DISABLE", Boolean.TRUE);
                this.mapElementsColumn.put("CHK_NOVALIDATE", Boolean.TRUE);
            } else if (Token.hasToken(temp, "ENABLE")) {
                this.mapElementsColumn.put("CHK_DISABLE", Boolean.FALSE);
            }
            if (Token.hasToken(temp, "NOVALIDATE")) {
                this.mapElementsColumn.put("CHK_NOVALIDATE", Boolean.TRUE);
            } else if (Token.hasToken(temp, "VALIDATE")) {
                this.mapElementsColumn.put("CHK_NOVALIDATE", Boolean.FALSE);
            }
            str = Token.getStringAfter(temp, "EXCEPTIONS");
            if (!"".equals(str)) {
                String tableName = Token.getNameAfterToken(str, "INTO", '\"', '\"');
                this.mapElementsColumn.put("CHK_EXCEPTIONS", tableName);
            }
        }
        this.mapElementsColumn.put("HAS_CHECK_CONSTRAINT", hasCheckConstraint ? Boolean.TRUE : Boolean.FALSE);
    }

    private void initUsingIndex() {
        if (Token.hasString(this.statement.toUpperCase(Locale.ROOT), "USING INDEX")) {
            this.mapElementsColumn.put("USING INDEX", Boolean.TRUE);
            String text = Token.getStringAfter(this.statement, "USING INDEX");
            if (text.startsWith("(")) {
                this.mapElementsColumn.put("BY CREATE INDEX STATEMENT", Token.getValBetweenBrackets(text, 1).trim());
            }
            if ("GLOBAL".equalsIgnoreCase(Token.getFirstToken(text))) {
                String partitions;
                String columnList;
                this.mapElementsColumn.put("GLOBAL", Boolean.TRUE);
                if (Token.hasToken(text, "HASH")) {
                    text = Token.getStringAfter(text, "HASH");
                    columnList = Token.getValBetweenBrackets(text, 1).trim();
                    this.mapElementsColumn.put("COLUMN_LIST", columnList);
                    text = Token.getValAfterBrackets(text, 1);
                    if (Token.getFirstToken(text).equalsIgnoreCase("PARTITIONS")) {
                        this.mapElementsColumn.put("GLOBAL HASH PARTITION BY QUANTITY", Boolean.TRUE);
                        this.mapElementsColumn.put("QUANTITY", Token.getTokenAfter(text, "PARTITIONS"));
                        String temp = Token.getStringAfter(text, "OVERFLOW STORE IN");
                        String tableSpaces = Token.getValBetweenBrackets(temp, 1).trim();
                        this.mapElementsColumn.put("OVERFLOW TABLESPACES", tableSpaces);
                        temp = Token.getStringAfter(text, "STORE IN", "OVERFLOW");
                        tableSpaces = Token.getValBetweenBrackets(temp, 1).trim();
                        this.mapElementsColumn.put("HASH TABLESPACES", tableSpaces);
                    } else {
                        this.mapElementsColumn.put("GLOBAL HASH PARTITION BY LIST", Boolean.TRUE);
                        partitions = Token.getValBetweenBrackets(text, 1).trim();
                        this.mapElementsColumn.put("PARTITIONS", partitions);
                    }
                } else {
                    this.mapElementsColumn.put("GLOBAL BY RANGE", Boolean.TRUE);
                    text = Token.getStringAfter(text, "RANGE");
                    columnList = Token.getValBetweenBrackets(text, 1).trim();
                    this.mapElementsColumn.put("COLUMN_LIST", columnList);
                    text = Token.getValAfterBrackets(text, 1);
                    partitions = Token.getValBetweenBrackets(text, 1).trim();
                    this.mapElementsColumn.put("PARTITIONS", partitions);
                }
            } else {
                this.mapElementsColumn.put("GLOBAL", Boolean.FALSE);
            }
            if ("LOCAL".equalsIgnoreCase(Token.getFirstToken(text))) {
                this.mapElementsColumn.put("LOCAL", Boolean.TRUE);
            }
            if (Token.hasToken(text, "PCTFREE")) {
                String pctFree = Token.getTokenAfter(text, "PCTFREE").trim();
                this.mapElementsColumn.put("PCTFREE", pctFree);
            } else {
                this.mapElementsColumn.put("PCTFREE", "");
            }
            if (Token.hasToken(text, "INITRANS")) {
                String initrans = Token.getTokenAfter(text, "INITRANS").trim();
                this.mapElementsColumn.put("INITRANS", initrans);
            } else {
                this.mapElementsColumn.put("INITRANS", "");
            }
            if (Token.hasToken(text, "MAXTRANS")) {
                String maxtrans = Token.getTokenAfter(text, "MAXTRANS").trim();
                this.mapElementsColumn.put("MAXTRANS", maxtrans);
            } else {
                this.mapElementsColumn.put("MAXTRANS", "");
            }
            if (Token.hasToken(text, "TABLESPACE")) {
                String tsName = Token.getQuotedNameAfterToken(text, "TABLESPACE").trim();
                this.mapElementsColumn.put("TABLESPACE", tsName);
            } else {
                this.mapElementsColumn.put("TABLESPACE", "");
            }
            if (Token.hasToken(text, "STORAGE")) {
                text = Token.getStringAfter(text, "STORAGE");
                String storLine = Token.getValBetweenBrackets(text, 1).trim();
                this.mapElementsColumn.put("STORAGE", Boolean.TRUE);
                if (Token.hasToken(storLine, "INITIAL")) {
                    String initial = Token.getTokenAfter(storLine, "INITIAL").trim();
                    this.mapElementsColumn.put("INITIAL", initial);
                } else {
                    this.mapElementsColumn.put("INITIAL", "");
                }
                if (Token.hasToken(storLine, "NEXT")) {
                    String next = Token.getTokenAfter(storLine, "NEXT").trim();
                    this.mapElementsColumn.put("NEXT", next);
                } else {
                    this.mapElementsColumn.put("NEXT", "");
                }
                if (Token.hasToken(storLine, "PCTINCREASE")) {
                    String pctIncrease = Token.getTokenAfter(storLine, "PCTINCREASE").trim();
                    this.mapElementsColumn.put("PCTINCREASE", pctIncrease);
                } else {
                    this.mapElementsColumn.put("PCTINCREASE", "");
                }
                if (Token.hasToken(storLine, "MINEXTENTS")) {
                    String minExtents = Token.getTokenAfter(storLine, "MINEXTENTS").trim();
                    this.mapElementsColumn.put("MINEXTENTS", minExtents);
                } else {
                    this.mapElementsColumn.put("MINEXTENTS", "");
                }
                if (Token.hasToken(storLine, "MAXEXTENTS")) {
                    String maxExtents = Token.getTokenAfter(storLine, "MAXEXTENTS").trim();
                    this.mapElementsColumn.put("MAXEXTENTS", maxExtents);
                } else {
                    this.mapElementsColumn.put("MAXEXTENTS", "");
                }
                if (Token.hasToken(storLine, "FREELISTS")) {
                    String freeLists = Token.getTokenAfter(storLine, "FREELISTS").trim();
                    this.mapElementsColumn.put("FREELISTS", freeLists);
                } else {
                    this.mapElementsColumn.put("FREELISTS", "");
                }
                if (Token.hasToken(storLine, "GROUPS")) {
                    String freeListGroups = Token.getTokenAfter(storLine, "GROUPS").trim();
                    this.mapElementsColumn.put("GROUPS", freeListGroups);
                } else {
                    this.mapElementsColumn.put("GROUPS", "");
                }
                if (Token.hasToken(storLine, "BUFFER_POOL")) {
                    String bufferPool = Token.getTokenAfter(storLine, "BUFFER_POOL").trim();
                    this.mapElementsColumn.put("BUFFER_POOL", bufferPool);
                } else {
                    this.mapElementsColumn.put("BUFFER_POOL", "");
                }
            } else {
                this.mapElementsColumn.put("STORAGE", Boolean.FALSE);
            }
            if (Token.hasToken(text, "NOLOGGING")) {
                this.mapElementsColumn.put("LOGGING", "NO");
            } else if (Token.hasToken(text, "LOGGING")) {
                this.mapElementsColumn.put("LOGGING", "YES");
            }
        } else {
            this.mapElementsColumn.put("USING INDEX", Boolean.FALSE);
        }
    }

    private void initReferences() {
        boolean isReferences = Token.hasToken(this.statement, "REFERENCES");
        if (isReferences) {
            String str;
            String onDelete;
            String beforeReferences = Token.getStringBeforeToken(this.statement, "REFERENCES");
            String constraintName = Token.getStringAfterToken(beforeReferences, "CONSTRAINT");
            if (constraintName.length() > 0) {
                while (Token.hasToken(constraintName, "CONSTRAINT")) {
                    constraintName = Token.getStringAfterToken(constraintName, "CONSTRAINT");
                }
                if (constraintName.startsWith("\"")) {
                    if (constraintName.indexOf("\"", 1) == constraintName.length() - 1) {
                        this.mapElementsColumn.put("REF_CONSTRAINT_NAME_QUOTED", Boolean.TRUE);
                        constraintName = Token.getName(constraintName);
                    } else {
                        constraintName = "";
                    }
                } else if (constraintName.indexOf(32) > -1) {
                    constraintName = "";
                }
            }
            if (constraintName.length() > 0) {
                this.mapElementsColumn.put("CONSTRAINT_NAME", constraintName);
            }
            String afterReferences = Token.getStringAfterToken(this.statement, "REFERENCES");
            afterReferences = Token.getStringToFirstMatch(afterReferences, this.constraintStartWords);
            String tableName = Token.getFirstName(afterReferences, '\"', '\"');
            this.mapElementsColumn.put("REFERENCES", tableName);
            String text = Token.cutFirstToken2(afterReferences);
            boolean hasBrackets = Token.hasString(text, "(");
            if (hasBrackets) {
                String columnReferenced = Token.getValBetweenBrackets(text, 1).trim();
                this.mapElementsColumn.put("REFERENCED_COLUMN", columnReferenced);
                text = Token.getValAfterBrackets(text, 1);
            }
            if ((onDelete = Token.getStringAfter(text, "ON DELETE").toUpperCase(Locale.ROOT)).length() > 0) {
                text = onDelete;
                if ((onDelete = onDelete.startsWith("CASCADE") ? "CASCADE" : (onDelete.startsWith("SET NULL") ? "SET NULL" : null)) != null) {
                    this.mapElementsColumn.put("ON DELETE", onDelete);
                }
            }
            if (Token.hasToken(text, "DEFERRABLE")) {
                str = Token.getTokenBefore(text, "DEFERRABLE");
                boolean deferrable = !str.equalsIgnoreCase("NOT");
                this.mapElementsColumn.put("REF_DEFERRABLE", deferrable ? Boolean.TRUE : Boolean.FALSE);
            }
            if ((str = Token.getStringAfter(text, "INITIALLY")).length() > 0) {
                String initially = Token.getFirstToken(str);
                this.mapElementsColumn.put("REF_INITIALLY", initially);
            }
            if (Token.hasToken(text, "DISABLE")) {
                this.mapElementsColumn.put("REF_DISABLE", Boolean.TRUE);
                this.mapElementsColumn.put("REF_NOVALIDATE", Boolean.TRUE);
            } else if (Token.hasToken(text, "ENABLE")) {
                this.mapElementsColumn.put("REF_DISABLE", Boolean.FALSE);
            }
            if (Token.hasToken(text, "NOVALIDATE")) {
                this.mapElementsColumn.put("REF_NOVALIDATE", Boolean.TRUE);
            } else if (Token.hasToken(text, "VALIDATE")) {
                this.mapElementsColumn.put("REF_NOVALIDATE", Boolean.FALSE);
            }
            str = Token.getStringAfter(text, "EXCEPTIONS");
            if (!"".equals(str)) {
                String excTableName = Token.getNameAfterToken(str, "INTO", '\"', '\"');
                this.mapElementsColumn.put("REF_EXCEPTIONS", excTableName);
            }
        }
    }

    private void initWithRowid() {
        boolean withRowId = Token.hasString(this.statement.toUpperCase(Locale.ROOT), "WITH ROWID");
        if (withRowId) {
            this.mapElementsColumn.put("WITH ROWID", Boolean.TRUE);
        }
    }

    public Map getElementsColumn(String statement, RDBMSType dbType) {
        this.parseColumns(statement, dbType);
        return this.mapElementsColumn;
    }
}

