/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTemporaryTablespaceOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTemporaryTablespaceOracle.class);

    public SHCreateTemporaryTablespaceOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTemporaryTablespaceOracle.clearCR(line);
        if (Token.startsWithString(statement, "CREATE TEMPORARY TABLESPACE") || Token.startsWithString(statement, "CREATE SMALLFILE TEMPORARY TABLESPACE") || Token.startsWithString(statement, "CREATE BIGFILE TEMPORARY TABLESPACE")) {
            try {
                this.parseTemporaryTablespace(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateTemporaryTablespaceOracle.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseTemporaryTablespace(String statement) {
        TemporaryTablespaceOracle ts;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOracle stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (stoDesign != null && (ts = stoDesign.getTemporaryTablespaceSet().createTemporaryTablespace()) != null) {
            this.initName(ts);
            this.initTempFile(ts);
            this.initExtent(ts);
            this.design.getRelationalDesign().stampModelObjectDDL(ts);
        }
    }

    private void initName(TemporaryTablespaceOracle ts) {
        String name = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
        ts.setName(name);
    }

    private void initTempFile(TemporaryTablespaceOracle ts) {
        if (Token.hasToken(this.statement, "TEMPFILE")) {
            String file = Token.getStringAfterToken(this.statement, "TEMPFILE");
            if (file.startsWith("'")) {
                String filename = Token.getValBetweenQuotes(file);
                ts.setFilename(filename);
            }
            if (Token.hasToken(file, "SIZE")) {
                String size = Token.getTokenAfter(file, "SIZE");
                try {
                    ts.setSize(Long.parseLong(this.removeMeasureUnit(size)));
                    ts.setMeasureUnitSize(this.getMeasureUnit(size, file));
                }
                catch (Exception e) {
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                    LOGGER.error(" Wrong syntax near " + size + "!");
                }
            }
            if (Token.hasToken(file, "REUSE")) {
                ts.setReuse("YES");
            } else {
                ts.setReuse("NO");
            }
            if (Token.hasToken(file, "AUTOEXTEND")) {
                String extend = Token.getStringAfterToken(file, "AUTOEXTEND");
                if (Token.hasToken(extend, "OFF")) {
                    ts.setAutoextend("OFF");
                } else if (Token.hasToken(extend, "ON")) {
                    ts.setAutoextend("ON");
                    if (Token.hasToken(extend, "NEXT")) {
                        String size = Token.getTokenAfter(file, "NEXT");
                        try {
                            ts.setNextBlockSize(Integer.parseInt(size));
                        }
                        catch (NumberFormatException e) {
                            this.importLog.addWarning("Wrong AUTOEXTEND format in statement " + this.statement);
                            LOGGER.error(" Wrong syntax near " + size + "!");
                        }
                    }
                    if (Token.hasToken(extend, "MAXSIZE")) {
                        String maxsize = Token.getStringAfterToken(file, "MAXSIZE");
                        if (Token.hasToken(maxsize, "UNLIMITED")) {
                            ts.setMaxSize("UNLIMITED");
                        } else {
                            String size = Token.getTokenAfter(file, "MAXSIZE");
                            ts.setMaxSize(size);
                        }
                    }
                }
            }
        }
    }

    private String removeMeasureUnit(String value) {
        String sizeStr = value.toUpperCase();
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private String getMeasureUnit(String value, String dfInfo) {
        String sizeStr = value.toUpperCase();
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M")) {
            return sizeStr.substring(sizeStr.length() - 1);
        }
        sizeStr = Token.getTokenAfter(dfInfo, value).toUpperCase();
        if (sizeStr.equals("K") || sizeStr.equals("M")) {
            return sizeStr;
        }
        return "";
    }

    private void initExtent(TemporaryTablespaceOracle ts) {
        if (Token.hasToken(this.statement, "UNIFORM")) {
            String extent = Token.getStringAfterToken(this.statement, "UNIFORM");
            String size = Token.getTokenAfter(extent, "SIZE");
            try {
                ts.setUniformSize(Long.parseLong(this.removeMeasureUnit(size)));
                ts.setMeasureUnitUniformSize(this.getMeasureUnit(size, extent));
            }
            catch (NumberFormatException e) {
                LOGGER.error(" Wrong syntax near " + size);
                this.importLog.addWarning("Wrong UNIFORM format in statement " + this.statement);
            }
        }
    }
}

