/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;

public class SHLabelOn
extends DDLStatementHandler {
    public SHLabelOn(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHLabelOn.clearCR(line);
        if (Token.startsWithString(statement, "label on")) {
            try {
                this.parseLabelOn(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHLabelOn.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseLabelOn(String statement) {
        this.statement = statement;
        String onObject = this.getNameOnly(Token.getTokenAfter(this.statement, "ON").trim());
        String label = Token.getStringAfter(this.statement, "IS").trim();
        label = Token.getValBetweenQuotationMarks(label);
        if (onObject.trim().equalsIgnoreCase("TABLE")) {
            RDBMSSite site;
            AbstractStorageDesignDB2 storageDesign;
            TableProxyDB2 tableProxy;
            onObject = this.getNameOnly(Token.getTokenAfter(this.statement, "TABLE").trim());
            Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(onObject);
            if (table != null && (tableProxy = (TableProxyDB2)(storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site = this.design.getSelectedRDBMSSite())).getTableProxySet().getProxy(table.getObjectID())) != null) {
                tableProxy.setLabel(label);
            }
        } else if (onObject.trim().equalsIgnoreCase("COLUMN")) {
            RDBMSSite site;
            AbstractStorageDesignDB2 storageDesign;
            ColumnProxyDB2 columnProxy;
            Column col;
            onObject = Token.getTokenAfter(this.statement, "COLUMN").trim();
            StringTokenizer tokenizer = new StringTokenizer(onObject, ".");
            if (tokenizer.countTokens() == 2) {
                onObject = onObject.substring(onObject.indexOf(46) + 1);
            }
            if ((col = (Column)this.design.getRelationalDesign().getColumnSet().getByName(onObject)) != null && (columnProxy = (ColumnProxyDB2)(storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site = this.design.getSelectedRDBMSSite())).getColumnProxySet().getProxy(col.getObjectID())) != null) {
                columnProxy.setLabel(label);
            }
        } else {
            RDBMSSite site;
            AbstractStorageDesignDB2 storageDesign;
            TableViewProxyDB2 tableViewProxy;
            TableView view = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(onObject);
            if (view != null && (tableViewProxy = (TableViewProxyDB2)(storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site = this.design.getSelectedRDBMSSite())).getTableViewProxySet().getProxy(view.getObjectID())) != null) {
                tableViewProxy.setLabelOn(label);
            }
        }
    }
}

