/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;

public class SHCreateAlias
extends DDLStatementHandler {
    public SHCreateAlias(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateAlias.clearCR(line);
        if (Token.startsWithString(statement, "create alias")) {
            try {
                this.parseAlias(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHCreateAlias.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseAlias(String statement) {
        this.statement = statement;
        String aliasName = this.getNameOnly(Token.getTokenAfter(this.statement, "ALIAS").trim());
        String tableOrViewName = this.getNameOnly(Token.getTokenAfter(this.statement, "FOR").trim());
        Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(tableOrViewName);
        TableView view = null;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (table == null) {
            view = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(tableOrViewName);
        }
        if (table != null || view != null) {
            AliasDB2 alias = storageDesign.getAliasSet().createAlias();
            alias.setName(aliasName);
            this.design.getRelationalDesign().stampModelObjectDDL(alias);
            if (table != null) {
                TableProxyDB2 tableProxy = (TableProxyDB2)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                String ownerName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "ALIAS").trim(), '.');
                if (!ownerName.equalsIgnoreCase("")) {
                    Owner owner = (Owner)((AbstractStorageDesignDB2)tableProxy.getStorageDesign()).getOwnerSet().getByName(ownerName);
                    if (owner == null) {
                        owner = (Owner)((AbstractStorageDesignDB2)tableProxy.getStorageDesign()).getOwnerSet().createElement(null);
                        owner.setName(ownerName);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    alias.setOwner(owner);
                } else if (this.getOwner() != null) {
                    alias.setOwner(this.getOwner());
                } else {
                    alias.setOwner(storageDesign.getOwnerSet().getDefaultOwner());
                }
                alias.setTable(tableProxy);
            } else if (view != null) {
                TableViewProxyDB2 tableViewProxy = (TableViewProxyDB2)storageDesign.getTableViewProxySet().getProxy(view.getObjectID());
                String ownerName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "ALIAS").trim(), '.');
                if (!ownerName.equalsIgnoreCase("")) {
                    Owner owner = (Owner)((AbstractStorageDesignDB2)tableViewProxy.getStorageDesign()).getOwnerSet().getByName(ownerName);
                    if (owner == null) {
                        owner = (Owner)((AbstractStorageDesignDB2)tableViewProxy.getStorageDesign()).getOwnerSet().createElement(null);
                        owner.setName(ownerName);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    alias.setOwner(owner);
                }
                alias.setView(tableViewProxy);
            }
        } else {
            StorageObject st = (StorageObject)storageDesign.getAliasSet().getByName(tableOrViewName);
            if (st != null) {
                AliasDB2 alias = storageDesign.getAliasSet().createAlias();
                alias.setName(aliasName);
                this.design.getRelationalDesign().stampModelObjectDDL(alias);
                String ownerName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "ALIAS").trim(), '.');
                if (!ownerName.equalsIgnoreCase("")) {
                    Owner owner = (Owner)((AbstractStorageDesignDB2)alias.getStorageDesign()).getOwnerSet().getByName(ownerName);
                    if (owner == null) {
                        owner = (Owner)((AbstractStorageDesignDB2)alias.getStorageDesign()).getOwnerSet().createElement(null);
                        owner.setName(ownerName);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    alias.setOwner(owner);
                }
                alias.setAnotherAlias((AliasDB2)st);
            }
        }
    }
}

