/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.BaseDDLFileHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.util.IdeUtil;

public class DDLFileHandler
extends BaseDDLFileHandler {
    public static final String ENCODED_CR = "$%@*$";
    public static final String ENCODED_CR_PATTERN = "\\$\\%\\@\\*\\$";
    private static final String CREATE_PACKAGE = "CREATE PACKAGE";
    private static final String CREATE_OR_REPLACE_PACKAGE = "CREATE OR REPLACE PACKAGE";
    private static final String CREATE_PACKAGE_BODY = "CREATE PACKAGE BODY";
    private static final String CREATE_OR_REPLACE_PACKAGE_BODY = "CREATE OR REPLACE PACKAGE BODY";
    private static final String CREATE_TYPE_BODY = "CREATE TYPE BODY";
    private static final String CREATE_OR_REPLACE_TYPE_BODY = "CREATE OR REPLACE TYPE BODY";
    private static final String CREATE_TRIGGER = "CREATE TRIGGER";
    private static final String CREATE_OR_REPLACE_TRIGGER = "CREATE OR REPLACE TRIGGER";
    private static final String CREATE_PROCEDURE = "CREATE PROCEDURE";
    private static final String CREATE_OR_REPLACE_PROCEDURE = "CREATE OR REPLACE PROCEDURE";
    private static final String BEGIN = "BEGIN";
    private static final String END = "END";
    private static final String LOOP = "LOOP";
    private static final String CREATE = "CREATE";
    private static final String FUNCTION = "FUNCTION";
    private static final String[] RESERVED_WORDS = new String[]{" TRIGGER "};
    private StreamTokenizer st;
    private InputStream is;
    private InputStreamReader isr;
    private BufferedReader in;
    private File file;
    private static Map oracleStartWithMap = new TreeMap();
    private static final Logger LOGGER = new Logger(DDLFileHandler.class);

    private void setBuffer() {
        try {
            this.is = new FileInputStream(this.file);
            this.isr = new InputStreamReader(this.is, IdeUtil.getIdeEncoding());
            this.in = new BufferedReader(this.isr);
            this.st = new StreamTokenizer(this.in);
            this.st.commentChar(45);
            this.st.slashStarComments(true);
            this.st.eolIsSignificant(true);
            this.st.wordChars(95, 95);
            this.st.wordChars(44, 44);
            this.st.wordChars(9, 9);
            this.st.wordChars(32, 32);
            this.st.wordChars(40, 41);
            this.st.wordChars(59, 59);
            this.st.wordChars(61, 61);
            this.st.wordChars(62, 62);
            this.st.wordChars(60, 60);
            this.st.wordChars(34, 34);
            this.st.wordChars(39, 39);
            this.st.wordChars(58, 58);
            this.st.wordChars(92, 92);
            this.st.wordChars(36, 36);
            this.st.wordChars(38, 38);
            this.st.wordChars(47, 47);
            this.st.wordChars(64, 64);
            this.st.wordChars(45, 45);
            this.st.wordChars(43, 43);
            this.st.wordChars(37, 37);
            this.st.wordChars(91, 91);
            this.st.wordChars(93, 93);
            this.st.wordChars(42, 42);
            this.st.wordChars(124, 124);
            this.st.wordChars(35, 35);
            this.st.wordChars(33, 33);
            this.st.wordChars(63, 63);
        }
        catch (IOException e) {
            LOGGER.error("ERROR reading file in DDLFileHandler.setBuffer()", e);
        }
    }

    @Override
    public void setFile(File file) {
        this.file = file;
        this.setBuffer();
    }

    private boolean isValidEnd(int rdbms, String line) {
        String temp = DDLStatementHandler.clearCR(line).toUpperCase();
        if (temp.startsWith(CREATE)) {
            if (line.toUpperCase().indexOf(FUNCTION) > -1) {
                return !Token.hasToken(line, BEGIN);
            }
            if ((rdbms == 7 || rdbms == 8 || rdbms == 9 || rdbms == 11) && (temp.startsWith(CREATE_PROCEDURE) || temp.startsWith(CREATE_OR_REPLACE_PROCEDURE))) {
                return false;
            }
            if (rdbms != 0 && rdbms != 1 && rdbms != 2 && rdbms != 3 && rdbms != 10) {
                for (int i = 0; i < RESERVED_WORDS.length; ++i) {
                    String reserved = RESERVED_WORDS[i];
                    if (temp.indexOf(reserved) <= -1) continue;
                    return false;
                }
            }
        } else if (temp.startsWith(BEGIN)) {
            return false;
        }
        return true;
    }

    private String removeComments(String line) {
        try {
            int pos = line.indexOf("--");
            if (pos > -1) {
                if (pos == 0) {
                    return "";
                }
                String s = line.substring(0, pos - 1).trim();
                return s;
            }
            return line;
        }
        catch (Exception e) {
            LOGGER.error("DDLFileHandler.removeComments()", e);
            return "";
        }
    }

    private static void initStartWithMap() {
        oracleStartWithMap.put("APPEND", "APPEND");
        oracleStartWithMap.put("CHANGE", "CHANGE");
        oracleStartWithMap.put("CONNECT", "CONNECT");
        oracleStartWithMap.put("DEL", "DEL");
        oracleStartWithMap.put("INPUT", "INPUT");
        oracleStartWithMap.put("LIST", "LIST");
        oracleStartWithMap.put("EDIT", "EDIT");
        oracleStartWithMap.put("GET", "GET");
        oracleStartWithMap.put("REM", "REM");
        oracleStartWithMap.put("REMARK", "REMARK");
        oracleStartWithMap.put("SAV", "SAV");
        oracleStartWithMap.put("SAVE", "SAVE");
        oracleStartWithMap.put("STA", "STA");
        oracleStartWithMap.put("START", "START");
        oracleStartWithMap.put("WHENEVER", "WHENEVER");
        oracleStartWithMap.put("ACC", "ACC");
        oracleStartWithMap.put("ACCEPT", "ACCEPT");
        oracleStartWithMap.put("DEF", "DEF");
        oracleStartWithMap.put("DEFINE", "DEFINE");
        oracleStartWithMap.put("PAU", "PAU");
        oracleStartWithMap.put("PAUSE", "PAUSE");
        oracleStartWithMap.put("PROMPT", "PROMPT");
        oracleStartWithMap.put("UNDEF", "UNDEF");
        oracleStartWithMap.put("UNDEFINE", "UNDEFINE");
        oracleStartWithMap.put("PRINT", "PRINT");
        oracleStartWithMap.put("VAR", "VAR");
        oracleStartWithMap.put("VARIABLE", "VARIABLE");
        oracleStartWithMap.put("SET", "SET");
        oracleStartWithMap.put("SHOW", "SHOW");
    }

    private String getDDLStatement(int dbType) {
        boolean isFunction = false;
        StringBuffer line = new StringBuffer();
        String token = this.nextToken().trim();
        if (dbType == 7 || dbType == 8 || dbType == 9 || dbType == 11) {
            String firstToken = Token.getFirstToken(token.trim().toUpperCase());
            while ((token.trim().startsWith("--") || oracleStartWithMap.get(firstToken) != null) && token.trim() != "") {
                token = this.nextToken().trim();
                firstToken = Token.getFirstToken(token.trim().toUpperCase());
            }
        } else {
            while (token.trim().startsWith("--") && token.trim() != "") {
                token = this.nextToken().trim();
            }
        }
        block11: while (!"".equalsIgnoreCase(token)) {
            String temp;
            isFunction = false;
            int indexOfPointComma = token.indexOf(59);
            if (indexOfPointComma > -1 && ((temp = line.toString() + token).indexOf(34) > -1 || temp.indexOf(39) > -1)) {
                String before = temp.substring(0, temp.lastIndexOf(59));
                boolean withinQuotesCheckComplete = false;
                while (!withinQuotesCheckComplete) {
                    int closeQuoteIndex;
                    int doubleQuoteIndex = before.indexOf(34);
                    int checkLength = doubleQuoteIndex >= 0 ? doubleQuoteIndex : before.length();
                    int singleQuoteIndex = before.substring(0, checkLength).indexOf(39);
                    if (singleQuoteIndex >= 0) {
                        before = before.substring(singleQuoteIndex + 1);
                        closeQuoteIndex = before.indexOf(39);
                    } else if (doubleQuoteIndex >= 0) {
                        before = before.substring(doubleQuoteIndex + 1);
                        closeQuoteIndex = before.indexOf(34);
                    } else {
                        closeQuoteIndex = -1;
                        withinQuotesCheckComplete = true;
                    }
                    if (closeQuoteIndex >= 0) {
                        before = before.substring(closeQuoteIndex + 1);
                        continue;
                    }
                    if (withinQuotesCheckComplete) continue;
                    indexOfPointComma = -1;
                    withinQuotesCheckComplete = true;
                }
            }
            int indexOfGO = -1;
            int indexOfSlash = token.indexOf(47);
            if (indexOfSlash > -1 && Token.isBetweenQuotes(token, "/")) {
                indexOfSlash = -1;
            }
            int indexOfEnd = -1;
            if (Token.hasToken(token.trim(), "GO")) {
                indexOfGO = 0;
            }
            if (token.trim().toUpperCase().startsWith(END)) {
                indexOfEnd = 0;
            }
            int index = -1;
            switch (dbType) {
                case 7: {
                    String comment;
                    String clearedString = DDLStatementHandler.clearCR(line.toString());
                    clearedString = Token.replaceAll(clearedString, " ", " ").trim().toUpperCase();
                    if (clearedString.startsWith(CREATE_PACKAGE) || clearedString.startsWith(CREATE_OR_REPLACE_PACKAGE) || clearedString.startsWith(CREATE_PACKAGE_BODY) || clearedString.startsWith(CREATE_OR_REPLACE_PACKAGE_BODY) || clearedString.startsWith(CREATE_TRIGGER) || clearedString.startsWith(CREATE_OR_REPLACE_TRIGGER) || clearedString.startsWith(CREATE_PROCEDURE) || clearedString.startsWith(CREATE_OR_REPLACE_PROCEDURE) || clearedString.startsWith("BEGIN ")) {
                        isFunction = true;
                        if (indexOfSlash >= 0) {
                            index = indexOfSlash;
                            line.append(token);
                            return line.toString().trim();
                        }
                        if (indexOfEnd >= 0 && this.matchNumberEndPackage(line.toString() + token, END) == this.matchNumber(line.toString(), BEGIN)) {
                            line.append(token);
                            token = this.nextToken().trim();
                            line.append(token);
                            return line.toString().trim();
                        }
                    } else if (clearedString.startsWith(CREATE_TYPE_BODY) || clearedString.startsWith(CREATE_OR_REPLACE_TYPE_BODY)) {
                        String str;
                        isFunction = true;
                        if (indexOfSlash >= 0) {
                            index = indexOfSlash;
                            line.append(token);
                            return line.toString().trim();
                        }
                        if ((indexOfEnd >= 0 || token.toUpperCase().equals(END)) && this.matchNumberToken(str = DDLStatementHandler.clearCR(line.toString() + token), END) == this.matchNumberToken(str, BEGIN) + this.numberOf(line.toString(), "IF ") + this.numberOf(line.toString(), "LOOP ") + this.numberOf(line.toString(), "CASE ") + 1) {
                            line.append(token);
                            token = this.nextToken().trim();
                            line.append(token);
                            return line.toString().trim();
                        }
                    } else if (!this.isValidEnd(7, line.toString())) {
                        if (indexOfSlash == token.trim().length() - 1) {
                            index = indexOfSlash;
                            if (token.trim().length() != 1) continue block11;
                            token = this.nextToken().trim();
                            break;
                        }
                        if (indexOfEnd >= 0 && this.matchNumberPointComma(line.toString(), END) == this.matchNumber(line.toString(), BEGIN) - 1) {
                            line.append(token);
                            token = this.nextToken().trim();
                            line.append(token);
                            return line.toString().trim();
                        }
                    }
                    if (!(indexOfPointComma < 0 || !this.isValidEnd(7, line.toString()) || clearedString.startsWith(CREATE_PACKAGE) || clearedString.startsWith(CREATE_OR_REPLACE_PACKAGE) || clearedString.startsWith(CREATE_PACKAGE_BODY) || clearedString.startsWith(CREATE_OR_REPLACE_PACKAGE_BODY) || clearedString.startsWith(CREATE_TYPE_BODY) || clearedString.startsWith(CREATE_OR_REPLACE_TYPE_BODY) || clearedString.startsWith(CREATE_TRIGGER) || clearedString.startsWith(CREATE_OR_REPLACE_TRIGGER) || clearedString.startsWith(CREATE_PROCEDURE) || clearedString.startsWith(CREATE_OR_REPLACE_PROCEDURE) || clearedString.startsWith("BEGIN "))) {
                        index = indexOfPointComma;
                    }
                    if (!(indexOfSlash != token.trim().length() - 1 || !this.isValidEnd(7, line.toString()) || clearedString.startsWith(CREATE_PACKAGE) || clearedString.startsWith(CREATE_OR_REPLACE_PACKAGE) || clearedString.startsWith(CREATE_PACKAGE_BODY) || clearedString.startsWith(CREATE_OR_REPLACE_PACKAGE_BODY) || clearedString.startsWith(CREATE_TYPE_BODY) || clearedString.startsWith(CREATE_OR_REPLACE_TYPE_BODY) || clearedString.startsWith(CREATE_TRIGGER) || clearedString.startsWith(CREATE_OR_REPLACE_TRIGGER) || clearedString.startsWith(CREATE_PROCEDURE) || clearedString.startsWith(CREATE_OR_REPLACE_PROCEDURE) || clearedString.startsWith("BEGIN "))) {
                        index = indexOfSlash;
                    }
                    if (index > 0) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (index == -1) {
                        line.append(token);
                        if (token.endsWith(";")) {
                            line.append('\n');
                        } else {
                            line.append(" ");
                        }
                        token = this.nextToken().trim();
                        StringBuffer cb = new StringBuffer();
                        String firstToken = Token.getFirstToken(token.trim().toUpperCase());
                        while ((token.trim().startsWith("--") || !isFunction && firstToken.equalsIgnoreCase("SET") || oracleStartWithMap.get(firstToken) != null) && token != "") {
                            token = this.nextToken().trim();
                            firstToken = Token.getFirstToken(token.trim().toUpperCase());
                        }
                        comment = cb.toString();
                        if ("".equalsIgnoreCase(comment)) continue block11;
                        cb.delete(0, cb.length() - 1);
                        token = cb.append('\n').append(comment).append('\n').append(token).toString();
                        break;
                    }
                    if (line.toString().equalsIgnoreCase("")) {
                        token = this.nextToken().trim();
                        break;
                    }
                    return line.toString().trim();
                }
                case 8: 
                case 9: 
                case 11: {
                    String comment;
                    String clearedString = DDLStatementHandler.clearCR(line.toString()).toUpperCase();
                    if (clearedString.startsWith(CREATE_PACKAGE) || clearedString.startsWith(CREATE_OR_REPLACE_PACKAGE) || clearedString.startsWith(CREATE_PACKAGE_BODY) || clearedString.startsWith(CREATE_OR_REPLACE_PACKAGE_BODY) || clearedString.startsWith(CREATE_TRIGGER) || clearedString.startsWith(CREATE_OR_REPLACE_TRIGGER) || clearedString.startsWith(CREATE_PROCEDURE) || clearedString.startsWith(CREATE_OR_REPLACE_PROCEDURE) || clearedString.startsWith("BEGIN ")) {
                        isFunction = true;
                        if (indexOfSlash >= 0) {
                            index = indexOfSlash;
                            line.append(token);
                            return line.toString().trim();
                        }
                        if (indexOfEnd >= 0 && this.matchNumberEndPackage(line.toString() + token, END) == this.matchNumber(line.toString(), BEGIN)) {
                            line.append(token);
                            token = this.nextToken().trim();
                            line.append(token);
                            return line.toString().trim();
                        }
                    } else if (Token.startsWithString(clearedString, CREATE_TYPE_BODY) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_TYPE_BODY)) {
                        String str;
                        isFunction = true;
                        if (indexOfSlash >= 0) {
                            index = indexOfSlash;
                            line.append(token);
                            return line.toString().trim();
                        }
                        if ((indexOfEnd >= 0 || token.toUpperCase().equals(END)) && this.matchNumberToken(str = DDLStatementHandler.clearCR(line.toString() + token), END) == this.matchNumberToken(str, BEGIN) + this.numberOf(line.toString(), "IF ") + this.numberOf(line.toString(), "LOOP ") + this.numberOf(line.toString(), "CASE ") + 1) {
                            line.append(token);
                            token = this.nextToken().trim();
                            line.append(token);
                            return line.toString().trim();
                        }
                    } else if (!this.isValidEnd(8, line.toString()) && indexOfEnd >= 0) {
                        if (indexOfSlash == token.trim().length() - 1) {
                            index = indexOfSlash;
                            if (token.trim().length() != 1) continue block11;
                            token = this.nextToken().trim();
                            break;
                        }
                        if (this.matchNumberPointComma(line.toString(), END) == this.matchNumber(line.toString(), BEGIN) - 1) {
                            line.append(token);
                            token = this.nextToken().trim();
                            line.append(token);
                            return line.toString().trim();
                        }
                    }
                    if (!(indexOfPointComma < 0 || !this.isValidEnd(8, line.toString()) || Token.startsWithString(clearedString, CREATE_PACKAGE) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_PACKAGE) || Token.startsWithString(clearedString, CREATE_PACKAGE_BODY) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_PACKAGE_BODY) || Token.startsWithString(clearedString, CREATE_TYPE_BODY) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_TYPE_BODY) || Token.startsWithString(clearedString, CREATE_TRIGGER) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_TRIGGER) || Token.startsWithString(clearedString, CREATE_PROCEDURE) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_PROCEDURE) || Token.startsWithString(clearedString, BEGIN))) {
                        index = indexOfPointComma;
                    }
                    if (!(indexOfSlash != token.trim().length() - 1 || !this.isValidEnd(8, line.toString()) || Token.startsWithString(clearedString, CREATE_PACKAGE) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_PACKAGE) || Token.startsWithString(clearedString, CREATE_PACKAGE_BODY) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_PACKAGE_BODY) || Token.startsWithString(clearedString, CREATE_TYPE_BODY) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_TYPE_BODY) || Token.startsWithString(clearedString, CREATE_TRIGGER) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_TRIGGER) || Token.startsWithString(clearedString, CREATE_PROCEDURE) || Token.startsWithString(clearedString, CREATE_OR_REPLACE_PROCEDURE) || Token.startsWithString(clearedString, BEGIN))) {
                        index = indexOfSlash;
                    }
                    if (index > 0) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (index == -1) {
                        line.append(token);
                        if (token.endsWith(";")) {
                            line.append('\n');
                        } else {
                            line.append(" ");
                        }
                        token = this.nextToken().trim();
                        StringBuffer cb = new StringBuffer();
                        String firstToken = Token.getFirstToken(token.trim().toUpperCase());
                        while ((token.trim().startsWith("--") || !isFunction && firstToken.equalsIgnoreCase("SET") || oracleStartWithMap.get(firstToken) != null) && token != "") {
                            token = this.nextToken().trim();
                            firstToken = Token.getFirstToken(token.trim().toUpperCase());
                        }
                        comment = cb.toString();
                        if ("".equalsIgnoreCase(comment)) continue block11;
                        cb.delete(0, cb.length() - 1);
                        token = cb.append('\n').append(comment).append('\n').append(token).toString();
                        break;
                    }
                    if (line.toString().equalsIgnoreCase("")) {
                        token = this.nextToken().trim();
                        break;
                    }
                    return line.toString().trim();
                }
                case 0: {
                    if (!this.isValidEnd(0, line.toString()) && indexOfEnd >= 0 && this.matchNumberPointComma(line.toString(), END) == this.matchNumber(line.toString(), BEGIN) - 1) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (indexOfPointComma >= 0 && this.isValidEnd(0, line.toString())) {
                        index = indexOfPointComma;
                    }
                    if (index > 0) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (index == -1) {
                        line.append(token);
                        line.append(" ");
                        token = this.nextToken().trim();
                        StringBuffer cb = new StringBuffer();
                        while (token.trim().startsWith("--") && token != "") {
                            token = this.nextToken().trim();
                        }
                        String comment = cb.toString();
                        if ("".equalsIgnoreCase(comment)) continue block11;
                        cb.delete(0, cb.length() - 1);
                        token = cb.append('\n').append(comment).append('\n').append(token).toString();
                        break;
                    }
                    if (line.toString().trim().equalsIgnoreCase("")) {
                        token = this.nextToken().trim();
                        break;
                    }
                    return line.toString().trim();
                }
                case 1: {
                    if (!this.isValidEnd(1, line.toString()) && indexOfEnd >= 0 && this.matchNumberPointComma(line.toString(), END) == this.matchNumber(line.toString(), BEGIN) - 1) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (indexOfPointComma >= 0 && this.isValidEnd(1, line.toString())) {
                        index = indexOfPointComma;
                    }
                    if (index > 0) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (index == -1) {
                        line.append(token);
                        line.append(" ");
                        token = this.nextToken().trim();
                        StringBuffer cb = new StringBuffer();
                        while (token.trim().startsWith("--") && token != "") {
                            token = this.nextToken().trim();
                        }
                        String comment = cb.toString();
                        if ("".equalsIgnoreCase(comment)) continue block11;
                        cb.delete(0, cb.length() - 1);
                        token = cb.append('\n').append(comment).append('\n').append(token).toString();
                        break;
                    }
                    if (line.toString().trim().equalsIgnoreCase("")) {
                        token = this.nextToken().trim();
                        break;
                    }
                    return line.toString().trim();
                }
                case 2: {
                    if (!this.isValidEnd(2, line.toString()) && indexOfEnd >= 0 && this.matchNumberPointComma(line.toString(), END) == this.matchNumber(line.toString(), BEGIN) - 1) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (indexOfPointComma >= 0 && this.isValidEnd(2, line.toString())) {
                        index = indexOfPointComma;
                    }
                    if (index > 0) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (index == -1) {
                        line.append(token);
                        line.append(" ");
                        token = this.nextToken().trim();
                        StringBuffer cb = new StringBuffer();
                        while (token.trim().startsWith("--") && token != "") {
                            token = this.nextToken().trim();
                        }
                        String comment = cb.toString();
                        if ("".equalsIgnoreCase(comment)) continue block11;
                        cb.delete(0, cb.length() - 1);
                        token = cb.append('\n').append(comment).append('\n').append(token).toString();
                        break;
                    }
                    if (line.toString().trim().equalsIgnoreCase("")) {
                        token = this.nextToken().trim();
                        break;
                    }
                    return line.toString().trim();
                }
                case 3: 
                case 10: {
                    if ((dbType == 3 && !this.isValidEnd(3, line.toString()) || dbType == 10 && !this.isValidEnd(10, line.toString())) && indexOfEnd >= 0 && this.matchNumberPointComma(line.toString(), END) == this.matchNumber(line.toString(), BEGIN) - 1) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (indexOfPointComma >= 0 && (dbType == 3 && this.isValidEnd(3, line.toString()) || dbType == 10 && this.isValidEnd(10, line.toString()))) {
                        index = indexOfPointComma;
                    }
                    if (index > 0) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (index == -1) {
                        line.append(token);
                        line.append(" ");
                        token = this.nextToken().trim();
                        StringBuffer cb = new StringBuffer();
                        while (token.trim().startsWith("--") && token != "") {
                            token = this.nextToken().trim();
                        }
                        String comment = cb.toString();
                        if ("".equalsIgnoreCase(comment)) continue block11;
                        cb.delete(0, cb.length() - 1);
                        token = cb.append('\n').append(comment).append('\n').append(token).toString();
                        break;
                    }
                    if (line.toString().trim().equalsIgnoreCase("")) {
                        token = this.nextToken().trim();
                        break;
                    }
                    return line.toString().trim();
                }
                case 4: 
                case 5: 
                case 12: 
                case 13: {
                    if (indexOfPointComma >= 0) {
                        index = indexOfPointComma;
                    } else if (indexOfGO > -1) {
                        index = indexOfGO;
                    }
                    if (index > 0) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (index == -1) {
                        line.append(token);
                        line.append(" ");
                        token = this.nextToken().trim();
                        StringBuffer cb = new StringBuffer();
                        while (token.trim().startsWith("--") && token != "") {
                            token = this.nextToken().trim();
                        }
                        String comment = cb.toString();
                        if ("".equalsIgnoreCase(comment)) continue block11;
                        cb.delete(0, cb.length() - 1);
                        token = cb.append('\n').append(comment).append('\n').append(token).toString();
                        break;
                    }
                    return line.toString().trim();
                }
                default: {
                    if (indexOfPointComma >= 0) {
                        index = indexOfPointComma;
                    } else if (indexOfGO > -1) {
                        index = indexOfGO;
                    }
                    if (index > 0) {
                        line.append(token);
                        return line.toString().trim();
                    }
                    if (index == -1) {
                        line.append(token);
                        line.append(" ");
                        token = this.nextToken().trim();
                        StringBuffer cb = new StringBuffer();
                        while (token.trim().startsWith("--") && token != "") {
                            token = this.nextToken().trim();
                        }
                        String comment = cb.toString();
                        if ("".equalsIgnoreCase(comment)) continue block11;
                        cb.delete(0, cb.length() - 1);
                        token = cb.append('\n').append(comment).append('\n').append(token).toString();
                        break;
                    }
                    return line.toString().trim();
                }
            }
        }
        return "";
    }

    @Override
    public List getDDLStatements(int dbType) {
        LinkedList<String> statements = new LinkedList<String>();
        String ddlstatement = this.getDDLStatement(dbType);
        ddlstatement = Token.replaceAll(ddlstatement, "\t", " ");
        ddlstatement = Token.replaceAll(ddlstatement, String.valueOf('\u2019'), "'");
        ddlstatement = Token.replaceAll(ddlstatement, "`", "'");
        if (dbType == 7 || dbType == 8 || dbType == 9 || dbType == 11) {
            if (ddlstatement.endsWith(";") || ddlstatement.endsWith("/")) {
                ddlstatement = ddlstatement.substring(0, ddlstatement.length() - 1).trim();
            }
            while (!ddlstatement.equals("")) {
                if (!ddlstatement.trim().startsWith("--") && !DDLStatementHandler.clearCR(ddlstatement).trim().equalsIgnoreCase("")) {
                    statements.addLast(ddlstatement);
                }
                ddlstatement = this.getDDLStatement(dbType);
                ddlstatement = Token.replaceAll(ddlstatement, "\t", " ");
                ddlstatement = Token.replaceAll(ddlstatement, String.valueOf('\u2019'), "'");
                if (!(ddlstatement = Token.replaceAll(ddlstatement, "`", "'")).endsWith(";") && !ddlstatement.endsWith("/")) continue;
                ddlstatement = ddlstatement.substring(0, ddlstatement.length() - 1).trim();
            }
        } else {
            if (ddlstatement.endsWith(";")) {
                ddlstatement = ddlstatement.substring(0, ddlstatement.length() - 1).trim();
            }
            while (!ddlstatement.equals("")) {
                if (!ddlstatement.startsWith("--") && !DDLStatementHandler.clearCR(ddlstatement).trim().equalsIgnoreCase("")) {
                    statements.addLast(ddlstatement);
                }
                ddlstatement = this.getDDLStatement(dbType);
                ddlstatement = Token.replaceAll(ddlstatement, "\t", " ");
                ddlstatement = Token.replaceAll(ddlstatement, String.valueOf('\u2019'), "'");
                if (!(ddlstatement = Token.replaceAll(ddlstatement, "`", "'")).endsWith(";")) continue;
                ddlstatement = ddlstatement.substring(0, ddlstatement.length() - 1).trim();
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
                this.isr.close();
                this.is.close();
            }
            catch (IOException e) {
                LOGGER.error("ERROR closing file in DDLFileHandler.getDDLStatements()", e);
            }
        }
        return statements;
    }

    private String nextToken() {
        String token = "";
        try {
            while (token == "" && this.st.nextToken() != -1) {
                if (this.st.ttype == -3) {
                    token = this.st.sval;
                }
                if (this.st.ttype == -2) {
                    int tokenNr = new Double(this.st.nval).intValue();
                    token = Integer.toString(tokenNr);
                }
                if (this.st.ttype == 10) {
                    token = ENCODED_CR;
                }
                if (token.trim().startsWith("--") || token.toUpperCase().trim().startsWith("REM\t") || token.toUpperCase().trim().startsWith("REM ") || token.equalsIgnoreCase("REM")) {
                    token = "";
                    continue;
                }
                if (token.indexOf("/*") <= -1) continue;
                StringBuffer buffer = new StringBuffer();
                if (token.indexOf("*/") > -1) {
                    buffer.append(token.substring(0, token.indexOf("/*")).trim());
                    buffer.append(' ').append(token.substring(token.lastIndexOf("*/") + 2, token.length()).trim());
                    buffer.append(ENCODED_CR);
                } else {
                    buffer.append(token.substring(0, token.indexOf("/*")));
                    token = "";
                    boolean notClosed = token.indexOf("*/") == -1;
                    int openSigns = 1;
                    int closeSigns = 0;
                    while (notClosed && this.st.nextToken() != -1) {
                        if (this.st.ttype == -3) {
                            token = this.st.sval;
                        }
                        if (this.st.ttype == -2) {
                            int tokenNr = new Double(this.st.nval).intValue();
                            token = Integer.toString(tokenNr);
                        }
                        if (this.st.ttype == 10) {
                            token = ENCODED_CR;
                        }
                        boolean bl = notClosed = token.indexOf("*/") == -1;
                        if (token.indexOf("/*") > -1) {
                            ++openSigns;
                        }
                        if (token.indexOf("*/") > -1) {
                            ++closeSigns;
                        }
                        if (openSigns <= closeSigns) continue;
                        notClosed = true;
                    }
                    if (token.indexOf("*/") > -1) {
                        buffer.append(' ').append(token.substring(token.lastIndexOf("*/") + 2));
                    }
                    buffer.append(ENCODED_CR);
                }
                token = buffer.toString();
            }
        }
        catch (IOException e) {
            LOGGER.error("ERROR reading file in DDLFileHandler.nextToken()", e);
        }
        return this.removeComments(token);
    }

    private int matchNumber(String str, String match) {
        int num = 0;
        while (str.toUpperCase().indexOf(match.toUpperCase()) > -1) {
            ++num;
            str = str.substring(str.toUpperCase().indexOf(match.toUpperCase()) + match.length());
        }
        return num;
    }

    private int numberOf(String str, String match) {
        int num = 0;
        int pos = str.toUpperCase().indexOf(ENCODED_CR + match.toUpperCase());
        while (pos > -1) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(str.substring(0, pos));
            buffer.append(' ').append(str.substring(pos + ENCODED_CR.length(), str.length()).trim());
            str = buffer.toString();
            pos = str.toUpperCase().indexOf(ENCODED_CR + match.toUpperCase());
        }
        while (str.toUpperCase().indexOf(' ' + match.toUpperCase()) > -1) {
            if (!Token.getStringBefore(str, ' ' + match).trim().toUpperCase().endsWith(END)) {
                ++num;
            }
            str = str.substring(str.toUpperCase().indexOf(' ' + match.toUpperCase()) + match.length() + 1);
        }
        return num;
    }

    private int matchNumberPointComma(String str, String match) {
        int num = 0;
        while (str.toUpperCase().indexOf(match.toUpperCase()) > -1) {
            if (!Token.getFirstToken(str = str.substring(str.toUpperCase().indexOf(match.toUpperCase()) + 1)).equalsIgnoreCase(";")) continue;
            ++num;
        }
        return num;
    }

    private int matchNumberEndPackage(String str, String match) {
        int num = 0;
        String name = Token.getStringAfter(str, "PACKAGE");
        if (Token.getFirstToken(name).equalsIgnoreCase("BODY")) {
            name = Token.cutFirstToken(name);
        }
        if ((name = Token.getFirstToken(name)).indexOf(46) > -1) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        while (str.toUpperCase().indexOf(match.toUpperCase()) > -1) {
            str = str.substring(str.toUpperCase().indexOf(match.toUpperCase()));
            if (!Token.getFirstToken(str = Token.cutFirstToken(str)).equalsIgnoreCase(";") && !Token.getFirstToken(str).equalsIgnoreCase(name) && !Token.getFirstToken(str).equalsIgnoreCase(name + ";")) continue;
            ++num;
        }
        return num;
    }

    private int matchNumberToken(String str, String match) {
        int num = 0;
        String next = "";
        if (Token.hasToken(str, match)) {
            StringTokenizer tokens = new StringTokenizer(str, " ");
            while (tokens.hasMoreTokens()) {
                next = tokens.nextToken().trim();
                if (!next.equalsIgnoreCase(match)) continue;
                ++num;
            }
        }
        return num;
    }

    static {
        DDLFileHandler.initStartWithMap();
    }
}

