/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateAllCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateCommand;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.VersionOperationSelectTablePanel;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.op.ui.UpdateCustomizer;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;

public class SVNUpdateWorkingCopyCommand
extends SVNUpdateAllCommand {
    public static final String COMMAND_ID = "oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateWorkingCopyCommand";
    public static String NAME = Messages.getString("DataModelingAddin.UpdateWorkingCopy");
    protected VersionOperationSelectTablePanel versionOperationPanel = null;
    protected Design design = null;
    protected List<VersioningTreeNode> nodesForRefreshing = null;
    protected List<File> filePaths = null;
    private static final Logger LOGGER = new Logger(SVNUpdateWorkingCopyCommand.class);
    private static final IdeAction ACTION = DataModelerAddin.createAction("oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateWorkingCopyCommand", NAME, (Icon)SVNUpdateCommand.getAction().getValue("SmallIcon"), (Command)new SVNUpdateWorkingCopyCommand());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public static IdeAction getAction() {
        return ACTION;
    }

    @Override
    public boolean isAvailableImpl() {
        if (this.context != null) {
            this.design = VCSClientHelper.getSelectionDesign(this.context.getView());
        }
        if (this.design != null) {
            return this.design.isVersioned();
        }
        return false;
    }

    @Override
    protected List<File> collectFilePaths(List<VersioningTreeNode> treeNodesForRefreshing) {
        if (this.context != null) {
            this.design = VCSClientHelper.getSelectionDesign(this.context.getView());
        }
        ArrayList<File> filePaths = new ArrayList<File>();
        if (this.design != null && this.design.isVersioned()) {
            File designPath = new File(this.design.getDesignPath());
            filePaths.add(designPath);
            return filePaths;
        }
        if (this.design != null) {
            String systemTypesPath = this.design.getAppView().getSettings().getDefaultSystemTypesPath();
            if (SVNClientHelper.getInstance().isVersioned(systemTypesPath)) {
                filePaths.add(new File(systemTypesPath));
                return filePaths;
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void updateNotAddedParents(List<File> filePaths) {
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        VersioningTreeNode node;
        SVNStorableObjectStatus storableObjectStatus;
        ISVNStatus objectStatus;
        int i;
        Locatable[] locatables = commandState.getLocatables();
        if (locatables == null || locatables.length == 0) {
            return true;
        }
        SVNRevision revision = (SVNRevision)options.get("oracle.jdeveloper.subversion.REVISION");
        boolean ignoreExternals = (Boolean)options.get("oracle.jdeveloper.subversion.IGNORE_EXTERNALS");
        boolean forceupdate = (Boolean)options.get("oracle.jdeveloper.subversion.FORCE_UPDATE");
        int depth = (Integer)options.get("oracle.jdeveloper.subversion.DEPTH");
        ArrayList<File> conflicted = new ArrayList<File>();
        ArrayList<File> changed = new ArrayList<File>();
        ArrayList<File> merged = new ArrayList<File>();
        if (this.context != null) {
            this.design = VCSClientHelper.getSelectionDesign(this.context.getView());
        }
        SVNDepth svnDepth = SVNDepth.fromID((int)depth);
        SVN_CLIENT_HELPER.doUpdate(this.filePaths.toArray(new File[0]), true, conflicted, changed, merged, revision, svnDepth);
        if (conflicted.size() > 0) {
            this.fixConflicts(conflicted, this.nodesForRefreshing);
        }
        if (changed.size() > 0) {
            for (i = 0; i < changed.size(); ++i) {
                objectStatus = SVN_CLIENT_HELPER.getSingleStatusLocal((File)changed.get(i));
                storableObjectStatus = new SVNStorableObjectStatus(this.design, objectStatus, false, false);
                storableObjectStatus.setTextStatus("M");
                node = new VersioningTreeNode(storableObjectStatus);
                this.nodesForRefreshing.add(node);
            }
        }
        if (merged.size() > 0) {
            for (i = 0; i < merged.size(); ++i) {
                objectStatus = SVN_CLIENT_HELPER.getSingleStatusLocal((File)merged.get(i));
                storableObjectStatus = new SVNStorableObjectStatus(this.design, objectStatus, false, false);
                storableObjectStatus.setTextStatus("M");
                node = new VersioningTreeNode(storableObjectStatus);
                this.nodesForRefreshing.add(node);
            }
        }
        VersioningTreeNode.refresh(this.nodesForRefreshing, false);
        SVNChangeListWindow.getSVNIncomingChangesChangeList().refresh();
        return true;
    }

    protected int doitImpl() throws Exception {
        CommandState commandState = VCSClientHelper.createCommandState(this.context.getView(), true, true);
        boolean res = this.invokeCommand(this.getProfile(), commandState);
        return 0;
    }

    protected boolean invokeCommand(final VCSProfile profile, final CommandState commandState) throws Exception {
        if (!this.prepareStateForUI(commandState)) {
            return false;
        }
        this.nodesForRefreshing = new ArrayList<VersioningTreeNode>();
        this.filePaths = this.collectFilePaths(this.nodesForRefreshing);
        if (!this.filePaths.isEmpty()) {
            DisplayableLocatableNode displayableLocatableNode = new DisplayableLocatableNode(this.filePaths.get(0));
            displayableLocatableNode.setUserObject(this.filePaths.get(0).getName());
            if (this.design.isVersioned()) {
                displayableLocatableNode.setObjectClass(Design.class);
            } else {
                displayableLocatableNode.setObjectClass(File.class);
            }
            ArrayList<DisplayableLocatableNode> displayableLocatableNodesList = new ArrayList<DisplayableLocatableNode>();
            displayableLocatableNodesList.add(displayableLocatableNode);
            VCSOptionsCustomizer customizer = this.createOptionsCustomizer();
            final JEWTDialog dialog = this.createOperationDialog(displayableLocatableNodesList, customizer, commandState);
            dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

                protected boolean doCommitOperation(Map options) throws Exception {
                    if (SVNUpdateWorkingCopyCommand.this.versionOperationPanel != null) {
                        Locatable[] locatables = SVNUpdateWorkingCopyCommand.this.versionOperationPanel.getSelectedLocatables();
                        commandState.setLocatables(locatables);
                    }
                    boolean result = true;
                    try {
                        result = SVNUpdateWorkingCopyCommand.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
                    }
                    catch (Exception ex) {
                        throw SVNExceptionWrapper.wrapException((Exception)ex);
                    }
                    return result;
                }
            });
            return VCSDialogRunner.runDialog((JDialog)dialog);
        }
        return false;
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        this.versionOperationPanel = SVN_CLIENT_HELPER.createVersionOperationTablePanel((List)nodes);
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)this.versionOperationPanel, (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
    }

    @Override
    protected VCSOptionsCustomizer createOptionsCustomizer() {
        URL wc = null;
        if (!this.filePaths.isEmpty()) {
            URL url = null;
            try {
                url = this.filePaths.get(0).toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.error(e);
            }
            if (url != null) {
                wc = SVNUtil.resolveWorkingCopy((URL)url);
            }
            SVNUrl reposUrl = null;
            try {
                reposUrl = SVNURLInfoCache.getInstance().getURL(wc);
            }
            catch (SVNException e) {
                LOGGER.error((Object)e);
            }
            catch (IOException e) {
                LOGGER.error(e);
            }
            UpdateCustomizer customizer = new UpdateCustomizer();
            HashMap<String, Object> defaultOpts = new HashMap<String, Object>(7);
            defaultOpts.put("oracle.jdeveloper.subversion.REVISION", SVNRevision.HEAD);
            defaultOpts.put("oracle.jdeveloper.subversion.IGNORE_EXTERNALS", Boolean.FALSE);
            defaultOpts.put("oracle.jdeveloper.subversion.DEPTH", 3);
            defaultOpts.put("oracle.jdeveloper.subversion.FORCE_UPDATE", Boolean.FALSE);
            defaultOpts.put("oracle.jdeveloper.subversion.LIST_REVISION_URL", reposUrl);
            customizer.setOptions(defaultOpts);
            return customizer;
        }
        return null;
    }
}

