/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Locatable;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.UpdateCustomizer;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class DMSVNOperationUpdate
extends AbstractSVNOperation {
    public DMSVNOperationUpdate(String commandId) {
        super(commandId);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        UpdateCustomizer customizer = new UpdateCustomizer();
        HashMap<String, Object> defaultOpts = new HashMap<String, Object>(7);
        defaultOpts.put("oracle.jdeveloper.subversion.REVISION", SVNRevision.HEAD);
        defaultOpts.put("oracle.jdeveloper.subversion.IGNORE_EXTERNALS", Boolean.FALSE);
        defaultOpts.put("oracle.jdeveloper.subversion.DEPTH", 3);
        defaultOpts.put("oracle.jdeveloper.subversion.FORCE_UPDATE", Boolean.FALSE);
        customizer.setOptions(defaultOpts);
        return customizer;
    }

    protected String getProgressTitle() {
        return null;
    }

    protected String getProgressMessage() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        Locatable[] locatables = commandState.getLocatables();
        if (locatables == null || locatables.length == 0) {
            return true;
        }
        DeterminateProgressMonitor progress = new DeterminateProgressMonitor(parentUi, this.getProgressTitle(), (Object)this.getProgressMessage(), "", 0, -1);
        progress.setCancellable(true);
        progress.setCloseOnFinish(true);
        SVNRevision revision = (SVNRevision)options.get("oracle.jdeveloper.subversion.REVISION");
        boolean ignoreExternals = (Boolean)options.get("oracle.jdeveloper.subversion.IGNORE_EXTERNALS");
        boolean forceupdate = (Boolean)options.get("oracle.jdeveloper.subversion.FORCE_UPDATE");
        int depth = (Integer)options.get("oracle.jdeveloper.subversion.DEPTH");
        URL[] resources = VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
        URL[] operands = this.sortForRecursive(resources);
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository((URL[])operands);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, repos);
            progress.setMaximum(operands.length + 1);
            progress.setProgress(0);
            Collection processed = this.getProcessedUrlsNotifier(commandState);
            for (int i = 0; i < operands.length && !progress.isCancelled(); ++i) {
                client.update(new File[]{SVNUtil.toFile((URL)operands[i])}, revision, depth, false, ignoreExternals, forceupdate);
                processed.add(operands[i]);
                progress.setProgress(processed.size());
            }
            this.postUpdate(operands);
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            progress.finish();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        Locatable[] locatables = commandState.getLocatables();
        if (locatables == null || locatables.length == 0) {
            return true;
        }
        SVNRevision revision = SVNRevision.HEAD;
        boolean ignoreExternals = true;
        boolean recursive = true;
        URL[] resources = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
        URL[] operands = recursive ? this.sortForRecursive(resources) : this.sortForNonRecursive(resources);
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository((URL[])operands);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, repos);
            Collection processed = this.getProcessedUrlsNotifier(commandState);
            for (int i = 0; i < operands.length; ++i) {
                client.update(new File[]{SVNUtil.toFile((URL)operands[i])}, revision, recursive, ignoreExternals);
                processed.add(operands[i]);
            }
            this.postUpdate(operands);
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
        return true;
    }

    protected void postUpdate(URL[] operands) {
        this.fireFileStructureChanged(operands);
    }

    protected URL[] sortForRecursive(URL[] resources) {
        return VCSFileSystemUtils.coalesceURLs((URL[])resources);
    }

    private URL[] sortForNonRecursive(URL[] resources) {
        return new URL[0];
    }
}

