/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeWindow;
import oracle.dbtools.crest.model.design.Design;
import oracle.ide.Context;
import oracle.ide.model.Locatable;
import oracle.ide.view.View;
import oracle.jdevimpl.vcs.svn.properties.AbstractPropertiesTableModel;
import oracle.jdevimpl.vcs.svn.properties.DockPropertiesTableModel;
import oracle.jdevimpl.vcs.svn.properties.SVNPropertiesWindow;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class SVNViewPropertiesWindow
extends SVNPropertiesWindow {
    private static final SVNViewPropertiesWindow INSTANCE = new SVNViewPropertiesWindow();
    private Design design;
    private ISVNProperty[] properties;
    private SVNViewPropertiesWindowTableModel svnViewPropertiesWindowTableModel;
    private boolean readOnly = true;

    private SVNViewPropertiesWindow() {
    }

    public static SVNViewPropertiesWindow getInstance() {
        return INSTANCE;
    }

    public Design getDesign() {
        return this.design;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public File[] getSelectionResources() {
        ArrayList<File> resources = new ArrayList<File>();
        int[] selectedRows = this.getTable().getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            File resource = new File((String)this.getTableModel().getValueAt(selectedRows[i], 2));
            resources.add(resource);
        }
        return resources.toArray(new File[0]);
    }

    public void refresh(Context context) {
        if (context != null) {
            View contextView = context.getView();
            Locatable[] selection = VCSClientHelper.getSelection(contextView);
            this.design = VCSClientHelper.getSelectionDesign(contextView);
            this.setViewContext(context);
            if (contextView instanceof SVNHistoryWindow) {
                this.readOnly = !((SVNHistoryWindow)contextView).isSelectedWorkingCopyRevision();
                this.updatePropertiesTable(contextView);
            } else if (contextView instanceof SVNMergeWindow) {
                this.readOnly = true;
                this.updatePropertiesTable(contextView);
            } else if (selection != null) {
                this.readOnly = false;
                this.updatePropertieTable(DisplayableLocatableNode.convertToFileArray(selection, false));
            }
        } else {
            super.refresh();
        }
    }

    public void refresh() {
        if (this.properties != null) {
            this.setTableData(this.properties, this.getScope());
        } else {
            super.refresh();
        }
    }

    public AbstractPropertiesTableModel getTableModel() {
        if (this.svnViewPropertiesWindowTableModel == null) {
            this.svnViewPropertiesWindowTableModel = new SVNViewPropertiesWindowTableModel();
        }
        return this.svnViewPropertiesWindowTableModel;
    }

    protected void remove() {
        if (!this.readOnly) {
            super.remove();
        }
    }

    public void clearForDesign(Design design) {
        if (design.equals(this.design)) {
            this.clear();
        }
    }

    public void clear() {
        this.properties = null;
        this.updatePropertieTable(new File[0]);
    }

    protected void updatePropertiesTable(View contextView) {
        ArrayList<ISVNProperty> allProperties = new ArrayList<ISVNProperty>();
        List<StorableObjectStatus> storableObjectStatuses = ((SVNHistoryWindow)contextView).getSelectedStorableObjectsStatuses();
        for (StorableObjectStatus storableObjectStatus : storableObjectStatuses) {
            ISVNProperty[] properties = null;
            if (!storableObjectStatus.getTextStatus().equals("D")) {
                properties = SVNClientHelper.getInstance().doGetProperties(storableObjectStatus.getURL(), storableObjectStatus.getRevision());
            }
            if (properties == null || properties.length <= 0) continue;
            allProperties.addAll(Arrays.asList(properties));
        }
        this.properties = allProperties.toArray(new ISVNProperty[0]);
        this.setTableData(this.properties, this.getScope());
    }

    protected class SVNViewPropertiesWindowTableModel
    extends DockPropertiesTableModel {
        protected SVNViewPropertiesWindowTableModel() {
        }

        public void assignTableValues(String[] propColumnArray, ISVNProperty prop) {
            File file = prop.getFile();
            propColumnArray[0] = prop.getName();
            propColumnArray[1] = prop.getValue();
            propColumnArray[2] = file != null ? file.getAbsolutePath() : prop.getUrl().toString();
        }
    }
}

