/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class ReportsPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_REPORTSPP";
    private static final String DRP = "def_reports_path";
    private static final String DSAXP = "def_saxon_path";
    private static final String CN = "company_name";
    private static final String PB = "use_page_breaks";
    private static final String ED = "embed_diagrams_in_reports";
    private static final String EMD = "embed_main_diagram_in_reports";
    private static final String GS = "group_by_schema_name_in_report";
    private static final String GHT = "generate_html_report_toc_in_separate_file";
    private static final String ISS = "include_select_statement_in_view_reports";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected ReportsPreferences(HashStructure hash) {
        super(hash);
    }

    public static ReportsPreferences getInstance(PropertyStorage prefs) {
        return new ReportsPreferences(ReportsPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public String getDefaultReportsPath() {
        return this._hash.getString(DRP);
    }

    public void setDefaultReportsPath(String defaultReportsPath) {
        this._hash.putString(DRP, defaultReportsPath);
    }

    public String getDefaultSaxonPath() {
        return this._hash.getString(DSAXP);
    }

    public void setDefaultSaxonPath(String defaultSaxonPath) {
        this._hash.putString(DSAXP, defaultSaxonPath);
    }

    public String getCompanyName() {
        return this._hash.getString(CN);
    }

    public void setCompanyName(String companyName) {
        this._hash.putString(CN, companyName);
    }

    public boolean isUsePageBreaks() {
        return this._hash.getBoolean(PB);
    }

    public void setUsePageBreaks(boolean value) {
        this._hash.putBoolean(PB, value);
    }

    public boolean isEmbedDiagrams() {
        return this._hash.getBoolean(ED);
    }

    public void setEmbedDiagrams(boolean value) {
        this._hash.putBoolean(ED, value);
    }

    public boolean isEmbedMainDiagram() {
        return this._hash.getBoolean(EMD);
    }

    public void setEmbedMainDiagram(boolean value) {
        this._hash.putBoolean(EMD, value);
    }

    public boolean isGroupBySchemaName() {
        return this._hash.getBoolean(GS);
    }

    public void setGroupBySchemaName(boolean value) {
        this._hash.putBoolean(GS, value);
    }

    public boolean isGenerateHTMLReportTOCInSeparateFile() {
        return this._hash.getBoolean(GHT);
    }

    public void setGenerateHTMLReportTOCInSeparateFile(boolean value) {
        this._hash.putBoolean(GHT, value);
    }

    public boolean isIncludeSelectStatementInViewReports() {
        return this._hash.getBoolean(ISS);
    }

    public void setIncludeSelectStatementInViewReports(boolean value) {
        this._hash.putBoolean(ISS, value);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(CN)) {
            settings.setReportsCompanyName(this.getCompanyName());
        }
        if (this.contains(PB)) {
            settings.setUsePageBreaksInReports(this.isUsePageBreaks());
        }
        if (this.contains(ED)) {
            settings.setEmbedDiagramsInReports(this.isEmbedDiagrams());
        }
        if (this.contains(EMD)) {
            settings.setEmbedMainDiagramInReports(this.isEmbedMainDiagram());
        }
        if (this.contains(GS)) {
            settings.setGroupBySchemaNameInReports(this.isGroupBySchemaName());
        }
        if (this.contains(GHT)) {
            settings.setGenerateHTMLReportTOCInSeparateFile(this.isGenerateHTMLReportTOCInSeparateFile());
        }
        if (this.contains(ISS)) {
            settings.setIncludeSelectStatementInViewReport(this.isIncludeSelectStatementInViewReports());
        }
        if (this.contains(DRP)) {
            settings.setDefaultReportsPath(this.getDefaultReportsPath());
        }
        if (this.contains(DSAXP)) {
            settings.setDefaultSaxonPath(this.getDefaultSaxonPath());
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setCompanyName(settings.getReportsCompanyName());
        this.setUsePageBreaks(settings.isUsePageBreaksInReports());
        this.setEmbedDiagrams(settings.isEmbedDiagramsInReports());
        this.setEmbedMainDiagram(settings.isEmbedMainDiagramInReports());
        this.setGroupBySchemaName(settings.isGroupBySchemaNameInReports());
        this.setGenerateHTMLReportTOCInSeparateFile(settings.isGenerateHTMLReportTOCInSeparateFile());
        this.setIncludeSelectStatementInViewReports(settings.isIncludeSelectStatementInViewReport());
        this.setDefaultReportsPath(settings.getDefaultReportsPath());
        this.setDefaultSaxonPath(settings.getDefaultSaxonPath());
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

