/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.fcp.preferences.OldConnection;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class RSConnectionPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_RSConnections";
    private static final String RS_CONNECTIONS = "rsconnections";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected RSConnectionPreferences(HashStructure hash) {
        super(hash);
    }

    public static RSConnectionPreferences getInstance(PropertyStorage prefs) {
        return new RSConnectionPreferences(RSConnectionPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public void removeOldConnections() {
        HashStructure hashstructure = HashStructure.newInstance();
        this._hash.putHashStructure(RS_CONNECTIONS, hashstructure);
    }

    public void loadToSettings(Settings settings) {
        HashStructure hsBasic = this._hash.getHashStructure(RS_CONNECTIONS);
        if (hsBasic != null) {
            OldConnection.getRSConnections().clear();
            Set stringKeys = hsBasic.keySet();
            TreeSet<Integer> integerKeys = new TreeSet<Integer>();
            Iterator it = stringKeys.iterator();
            while (it.hasNext()) {
                integerKeys.add(new Integer((String)it.next()));
            }
            for (Integer key : integerKeys) {
                HashStructure hs = hsBasic.getHashStructure(Integer.toString(key));
                OldConnection connection = new OldConnection();
                Set keys1 = hs.keySet();
                for (String key1 : keys1) {
                    if (key1 == null) continue;
                    HashStructure hsElement = hs.getHashStructure(key1);
                    Object value = this.getObjectFromElement(hsElement);
                    if (key1 == null || value == null) continue;
                    connection.put(key1, value);
                }
                OldConnection.getRSConnections().add(connection);
            }
        }
    }

    private Object getObjectFromElement(HashStructure hs) {
        String objectClassName2 = "";
        String valueString = "";
        Set keys = hs.keySet();
        for (String objectClassName2 : keys) {
            valueString = hs.getString(objectClassName2);
        }
        Object value = null;
        try {
            Class<?> objectClass = Class.forName(objectClassName2);
            Method valueOfMethod = null;
            Constructor<?> constructor = null;
            try {
                valueOfMethod = objectClass.getMethod("valueOf", String.class);
            }
            catch (Exception e) {
                constructor = objectClass.getConstructor(String.class);
            }
            if (valueOfMethod != null) {
                value = valueOfMethod.invoke(null, valueString);
            } else if (constructor != null) {
                value = constructor.newInstance(valueString);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return value;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

