/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelingPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelingPP";
    private static final String DPP = "def_proj_path";
    private static final String DIP = "def_import_path";
    private static final String DSP = "def_save_path";
    private static final String DST = "def_sys_types_path";
    private static final String SSRMD = "show_select_rel_model_dialog";
    private static final String SPDN = "show_properties_dialog_on_new";
    private static final String RLS = "reload_last_state";
    private static final String UVF = "use_versioning_functionality";
    private static final String SIL = "show_import_log";
    private static final String DRP = "def_reports_path";
    private static final String DSAXP = "def_saxon_path";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelingPreferences(HashStructure hash) {
        super(hash);
    }

    public static ModelingPreferences getInstance(PropertyStorage prefs) {
        return new ModelingPreferences(ModelingPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public void setDefaultDesignsPath(String dp) {
        this._hash.putString(DPP, dp);
    }

    public String getDefaultDesignsPath() {
        return this._hash.getString(DPP);
    }

    public void setDefaultImportPath(String value) {
        this._hash.putString(DIP, value);
    }

    public String getDefaultImportPath() {
        return this._hash.getString(DIP);
    }

    public void setDefaultSavePath(String value) {
        this._hash.putString(DSP, value);
    }

    public String getDefaultSavePath() {
        return this._hash.getString(DSP);
    }

    public String getDefaultReportsPath() {
        return this._hash.getString(DRP);
    }

    public String getDefaultSaxonPath() {
        return this._hash.getString(DSAXP);
    }

    public String getDefaultSystemTypesPath() {
        return this._hash.getString(DST);
    }

    public void setDefaultSystemTypesPath(String value) {
        this._hash.putString(DST, value);
    }

    public boolean isShowSelectRelModelDialog() {
        return this._hash.getBoolean(SSRMD);
    }

    public void setShowSelectRelModelDialog(boolean showSelectRelModelDialog) {
        this._hash.putBoolean(SSRMD, showSelectRelModelDialog);
    }

    public boolean isShowPropertiesDialogOnNew() {
        return this._hash.getBoolean(SPDN);
    }

    public void setShowPropertiesDialogOnNew(boolean showPropertiesDialogOnNew) {
        this._hash.putBoolean(SPDN, showPropertiesDialogOnNew);
    }

    public boolean isShowImportLog() {
        return this._hash.getBoolean(SIL);
    }

    public void setShowImportLog(boolean showImportLog) {
        this._hash.putBoolean(SIL, showImportLog);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public boolean isReloadLastState() {
        return this._hash.getBoolean(RLS);
    }

    public void setReloadLastState(boolean reloadLastState) {
        this._hash.putBoolean(RLS, reloadLastState);
    }

    public boolean isUseVersioningFunctionality() {
        return this._hash.getBoolean(UVF);
    }

    public void setUseVersioningFunctionality(boolean useVersioningFunctionality) {
        this._hash.putBoolean(UVF, useVersioningFunctionality);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(DPP)) {
            settings.setDefaultDesignsPath(this.getDefaultDesignsPath());
        }
        if (this.contains(DIP)) {
            settings.setDefaultImportPath(this.getDefaultImportPath());
        }
        if (this.contains(DSP)) {
            settings.setDefaultSavePath(this.getDefaultSavePath());
        }
        if (this.contains(DST)) {
            settings.initDefaultSystemTypesPath(this.getDefaultSystemTypesPath());
        }
        if (this.contains(SIL)) {
            settings.setShowImportLog(this.isShowImportLog());
        }
        if (this.contains(SPDN)) {
            settings.setShowPropertiesDialogOnNew(this.isShowPropertiesDialogOnNew());
        }
        if (this.contains(SSRMD)) {
            settings.setShowSelectRelModelDialog(this.isShowSelectRelModelDialog());
        }
        if (this.contains(RLS)) {
            settings.setReloadLastState(this.isReloadLastState());
        }
        if (this.contains(UVF)) {
            settings.setUseVersioningFunctionality(this.isUseVersioningFunctionality());
        }
        if (this.contains(DRP)) {
            settings.setDefaultReportsPath(this.getDefaultReportsPath());
        }
        if (this.contains(DSAXP)) {
            settings.setDefaultSaxonPath(this.getDefaultSaxonPath());
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setDefaultDesignsPath(settings.getDefaultDesignsPath());
        this.setDefaultImportPath(settings.getDefaultImportPath());
        this.setDefaultSavePath(settings.getDefaultSavePath());
        this.setDefaultSystemTypesPath(settings.getDefaultSystemTypesPath());
        this.setShowSelectRelModelDialog(settings.showSelectRelModelDialog());
        this.setShowPropertiesDialogOnNew(settings.showPropertiesDialogOnNew());
        this.setShowImportLog(settings.showImportLog());
    }
}

