/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class DialogPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_DialogSettings";
    private static final String DIALOGS_SETTINGS = "dialogs_settings";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected DialogPreferences(HashStructure hash) {
        super(hash);
    }

    public static DialogPreferences getInstance(PropertyStorage prefs) {
        return new DialogPreferences(DialogPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public void setDialogSettings(Map dialogs) {
        HashStructure hsBasic = HashStructure.newInstance();
        Object[] savedDialogs = dialogs.keySet().toArray();
        for (int i = 0; i < savedDialogs.length; ++i) {
            String key = (String)savedDialogs[i];
            Settings.DialogSettings ds = (Settings.DialogSettings)dialogs.get(key);
            HashStructure hs = HashStructure.newInstance();
            hs.putString("x", String.valueOf(ds.rec.getX()));
            hs.putString("y", String.valueOf(ds.rec.getY()));
            hs.putString("w", String.valueOf(ds.rec.getWidth()));
            hs.putString("h", String.valueOf(ds.rec.getHeight()));
            hs.putString("treepath", StringUtilities.encodeAttributeValue(ds.treePath));
            hs.putString("dividerLocation", String.valueOf(ds.dividerLocation));
            hsBasic.putHashStructure(key, hs);
        }
        this._hash.putHashStructure(DIALOGS_SETTINGS, hsBasic);
    }

    public HashStructure getDialogSettings() {
        return this._hash.getHashStructure(DIALOGS_SETTINGS);
    }

    public void loadToSettings(Settings settings) {
        HashStructure hsBasic = this._hash.getHashStructure(DIALOGS_SETTINGS);
        if (hsBasic != null) {
            Set keys = hsBasic.keySet();
            for (String key : keys) {
                HashStructure hs = hsBasic.getHashStructure(key);
                double x = Double.parseDouble(hs.getString("x"));
                double y = Double.parseDouble(hs.getString("y"));
                double w = Double.parseDouble(hs.getString("w"));
                double h = Double.parseDouble(hs.getString("h"));
                String treePath = hs.getString("treepath");
                if (treePath == null) {
                    treePath = "";
                }
                int dl = 0;
                try {
                    dl = Integer.parseInt(hs.getString("dividerLocation"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (dl > 0) {
                    settings.setDialogSettings(key, settings.fixScreenLocation((int)x, (int)y, (int)w, (int)h), StringUtilities.decodeAttributeValue(treePath), dl);
                    continue;
                }
                settings.setDialogSettings(key, settings.fixScreenLocation((int)x, (int)y, (int)w, (int)h), StringUtilities.decodeAttributeValue(treePath));
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

