/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.fcp.extension.SubordinateTablesReader;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.util.logging.Logger;

public class SubordinateTablesOracle
extends SubordinateTablesReader {
    private static final Logger LOGGER = new Logger(SubordinateTablesOracle.class);

    public SubordinateTablesOracle(Connection connection, List selectedObjects) {
        super(connection, selectedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAllObjects(boolean allSubordinateLevels) {
        Statement statement = null;
        if (this.tableObjects.size() > 0) {
            try {
                String sql = "select a.owner,a.table_name from sys.all_constraints a, (select owner,constraint_name from sys.all_constraints where owner = ? and table_name = ? and constraint_type in ('P','U')) b where a.constraint_type = 'R' and a.r_constraint_name = b.constraint_name and a.r_owner = b.owner";
                ArrayList<DBObject> tables = new ArrayList<DBObject>();
                tables.addAll(this.tableObjects);
                statement = this.connection.prepareStatement(sql);
                for (int step = 0; step < tables.size(); ++step) {
                    DBObject dbo = (DBObject)tables.get(step);
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, dbo.getName());
                    ResultSet rs = null;
                    rs = statement.executeQuery();
                    if (rs == null) continue;
                    while (rs.next()) {
                        String table_name;
                        String owner = rs.getString(1);
                        if (this.hasDBObject(this.tableObjects, owner, table_name = rs.getString(2))) continue;
                        DBObject dboTable = new DBObject(true, table_name, "TABLE", owner);
                        if (allSubordinateLevels) {
                            tables.add(dboTable);
                        }
                        this.tableObjects.add(dboTable);
                        this.selectedObjects.add(dboTable);
                    }
                    rs.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("SubordinateTablesOracle.getAllObjects():", e);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("SubordinateTablesOracle.getAllObjects():", e);
                    }
                }
            }
        }
        return this.selectedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFKs_fromChilds(Connection sqlConnection, List selectedObjects, Design design, RDBMSSite site) {
        ArrayList<DBObject> tableObjects = new ArrayList<DBObject>();
        for (DBObject dbo : selectedObjects) {
            if (!"TABLE".equalsIgnoreCase(dbo.getType())) continue;
            tableObjects.add(dbo);
        }
        Statement statement = null;
        Statement col_statement = null;
        if (tableObjects.size() > 0) {
            try {
                String sql = "select a.owner,a.table_name, a.constraint_name, a.delete_rule,a.r_constraint_name, a.deferred, a.deferrable from sys.all_constraints a, (select owner,constraint_name from sys.all_constraints where owner = ? and table_name = ? and constraint_type in ('P','U')) b where a.constraint_type = 'R' and a.r_constraint_name = b.constraint_name and a.r_owner = b.owner";
                ArrayList<DBObject> tables = new ArrayList<DBObject>();
                tables.addAll(tableObjects);
                statement = sqlConnection.prepareStatement(sql);
                for (int step = 0; step < tables.size(); ++step) {
                    DBObject dbo = (DBObject)tables.get(step);
                    Table table = this.getTable(dbo.getSchema(), dbo.getName(), design, site);
                    if (table == null) continue;
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, dbo.getName());
                    ResultSet rs = null;
                    rs = statement.executeQuery();
                    if (rs == null) continue;
                    while (rs.next()) {
                        Index index;
                        String table_name;
                        String owner = rs.getString(1);
                        Table ch_table = this.getTable(owner, table_name = rs.getString(2), design, site);
                        if (ch_table == null) continue;
                        String constr_name = rs.getString(3);
                        String delete_rule = rs.getString(4);
                        String key_name = rs.getString(5);
                        Index ref_key = table.getIndexByName(key_name);
                        if (ref_key == null || (index = ch_table.getIndexByName(constr_name)) != null) continue;
                        FKIndexAssociation fk = ch_table.addFK(ref_key);
                        fk.setName(constr_name);
                        fk.getLocalFKIndex().setName(constr_name);
                        fk.setDeleteRule(delete_rule);
                        if (col_statement == null) {
                            String col_sql = "select column_name from all_cons_columns where owner = ? and table_name = ? and constraint_name = ? order by position";
                            col_statement = sqlConnection.prepareStatement(col_sql);
                        }
                        col_statement.setString(1, owner);
                        col_statement.setString(2, table_name);
                        col_statement.setString(3, constr_name);
                        ResultSet crs = null;
                        crs = col_statement.executeQuery();
                        if (crs != null) {
                            int k = 0;
                            while (crs.next()) {
                                String colName = crs.getString(1);
                                Column column = (Column)ch_table.getElementByName(colName);
                                Column refCol = null;
                                try {
                                    refCol = (Column)ref_key.getElement(k);
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                if (column != null && refCol != null) {
                                    column.addFKAssociation(refCol, fk);
                                    fk.getLocalFKIndex().add(column);
                                }
                                ++k;
                            }
                            crs.close();
                        }
                        fk.resetMandatoryUsingColumns();
                        fk.resetEdgeParams();
                    }
                    rs.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("SubordinateTablesOracle.getAllObjects():", e);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (col_statement != null) {
                        col_statement.close();
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("SubordinateTablesOracle.getAllObjects():", e);
                }
            }
        }
    }

    private Table getTable(String schema, String name, Design design, RDBMSSite site) {
        RelationalDesign rd = design.getRelationalDesign();
        if (rd != null) {
            StorageDesign sd = rd.getStorageDesign(site);
            Iterator it = sd.getTableProxySet().iterator();
            while (it.hasNext()) {
                TableProxy tp = (TableProxy)it.next();
                StorageObject so = tp.getUserSchema();
                String sch = "";
                if (so != null) {
                    sch = so.getName();
                }
                Table table = (Table)tp.getObject();
                if (so == null) {
                    sch = table.getProperty("SCHEMA");
                }
                if ((sch == null || !sch.equalsIgnoreCase(schema) || !name.equalsIgnoreCase(tp.getName())) && (sch != null || !name.equalsIgnoreCase(tp.getName()))) continue;
                return table;
            }
        }
        return null;
    }
}

