/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;

public class RSViewContainers
extends RSGeneral {
    public static void export(Map map, Connection connection, AbstractView view) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_View_Containers (View_OVID, View_ID, View_Name, Container_ID, Container_OVID, Container_Name, Type, Alias, Sequence, Model_ID, Model_OVID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        RelationalDesign rd = (RelationalDesign)view.getDesignPart();
        Iterator it = view.getContainerMap().keySet().iterator();
        List refTables = view.getTables();
        List refViews = view.getViews();
        int seq = 1;
        while (it.hasNext()) {
            String refAlias = (String)it.next();
            String refID = (String)view.getContainerMap().get(refAlias);
            Table refTable = (Table)view.getTableSet().getObjectByID(refID);
            TableView refView = (TableView)((RelationalDesign)view.getDesignPart()).getTableViewSet().getObjectByID(refID);
            if ((refTable == null || !refTables.contains(refTable)) && (refView == null || !refViews.contains(refView))) continue;
            stmt.setString(1, (String)map.get(view.getObjectID()));
            stmt.setString(2, view.getObjectID());
            stmt.setString(3, view.getName());
            if (refTable != null) {
                stmt.setString(4, refTable.getObjectID());
                stmt.setString(5, RSViewContainers.getOrCreateOVID(map, refTable.getObjectID()));
                stmt.setString(6, refTable.getName());
                stmt.setString(7, "T");
            } else if (refView != null) {
                stmt.setString(4, refView.getObjectID());
                stmt.setString(5, RSViewContainers.getOrCreateOVID(map, refView.getObjectID()));
                stmt.setString(6, refView.getName());
                stmt.setString(7, "V");
            }
            stmt.setString(8, refAlias);
            stmt.setInt(9, seq++);
            stmt.setString(10, rd.getObjectID());
            stmt.setString(11, (String)map.get(rd.getObjectID()));
            stmt.setString(12, rd.getName());
            stmt.setString(13, (String)map.get(view.getDesign().getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

