/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.constraint.AVT;

public class RSValueRanges
extends RSGeneral {
    public static void export(Connection connection, List elements, Map map, String type) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_VALUE_RANGES (DataElement_ID, DataElement_OVID, Type, Sequence, Begin_Value, End_Value, Short_Description, Container_ID, Container_OVID, Container_Name, DataElement_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (ContainedObject element : elements) {
            Iterator it = element.getAVTs().iterator();
            int seq = 0;
            while (it.hasNext()) {
                AVT avt = (AVT)it.next();
                stmt.setString(1, element.getObjectID());
                stmt.setString(2, (String)map.get(element.getObjectID()));
                stmt.setString(3, type);
                stmt.setInt(4, ++seq);
                stmt.setString(5, avt.getBeginValue());
                stmt.setString(6, avt.getEndValue());
                stmt.setString(7, avt.getDescription());
                stmt.setString(8, element.getContainer().getObjectID());
                stmt.setString(9, (String)map.get(element.getObjectID()));
                stmt.setString(10, element.getContainer().getName());
                stmt.setString(11, element.getName());
                stmt.setString(12, (String)map.get(element.getDesign().getObjectID()));
                stmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

