/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSNotes;
import oracle.dbtools.crest.exports.reports.RSTaskParams;
import oracle.dbtools.crest.exports.reports.RSTransformationFlows;
import oracle.dbtools.crest.exports.reports.RSTransformations;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;

public class RSTransformationTasks
extends RSGeneral {
    public static void export(Map map, Connection connection, TransformationPackage transformPackage) throws Exception {
        ArrayList<TransformationTask> list = new ArrayList<TransformationTask>(1000);
        int count = 0;
        boolean count1 = false;
        ArrayList<TransformationTask> tasksCollection = new ArrayList<TransformationTask>();
        String query = "INSERT INTO DMRS_TRANSFORMATION_TASKS (Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Transformation_Package_ID, Transformation_Package_OVID, Transformation_Package_Name, Process_ID, Process_OVID, Process_Name, Top_Level, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (TransformationTask transformTask2 : transformPackage.getTransformationTaskSet()) {
            String transformTaskOVID = RSTransformationTasks.getOrCreateOVID(map, transformTask2.getObjectID());
            tasksCollection.add(transformTask2);
            String designOVID = (String)map.get(transformTask2.getDesign().getObjectID());
            Process proc = transformTask2.getProcess();
            stmt.setString(1, transformTask2.getObjectID());
            stmt.setString(2, transformTaskOVID);
            stmt.setString(3, transformTask2.getName());
            stmt.setString(4, transformPackage.getObjectID());
            stmt.setString(5, (String)map.get(transformPackage.getObjectID()));
            stmt.setString(6, transformPackage.getName());
            if (proc != null) {
                stmt.setString(7, proc.getObjectID());
                stmt.setString(8, RSTransformationTasks.getOrCreateOVID(map, proc.getObjectID()));
                stmt.setString(9, proc.getName());
            } else {
                stmt.setString(7, null);
                stmt.setString(8, null);
                stmt.setString(9, null);
            }
            stmt.setString(10, transformTask2.isTopLevel() ? "Y" : "N");
            stmt.setString(11, designOVID);
            stmt.addBatch();
            list.add(transformTask2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (TransformationTask transformTask2 : list) {
                RSComments.export(map, connection, transformTask2);
            }
            list.clear();
        }
        RSTransformationTasks.exportInfoStores(map, connection, tasksCollection);
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (TransformationTask transformTask : list) {
                RSComments.export(map, connection, transformTask);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportInfoStores(Map map, Connection connection, List tasks) throws Exception {
        int count = 0;
        int count1 = 0;
        String infoQuery = "INSERT INTO DMRS_TRANSFORMATION_TASK_INFOS (Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Info_Store_ID, Info_Store_OVID, Info_Store_Name, Source_Target_Flag, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement infoStmt = connection.prepareStatement(infoQuery);
        for (TransformationTask transformTask : tasks) {
            String designOVID = (String)map.get(transformTask.getDesign().getObjectID());
            for (InfoStore infoStore : transformTask.getSources()) {
                String infoStoreOVID = (String)map.get(infoStore.getObjectID());
                infoStmt.setString(1, transformTask.getObjectID());
                infoStmt.setString(2, (String)map.get(transformTask.getObjectID()));
                infoStmt.setString(3, transformTask.getName());
                infoStmt.setString(4, infoStore.getObjectID());
                infoStmt.setString(5, infoStoreOVID);
                infoStmt.setString(6, infoStore.getName());
                infoStmt.setString(7, "S");
                infoStmt.setString(8, designOVID);
                infoStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                infoStmt.executeBatch();
            }
            for (InfoStore infoStore : transformTask.getTargets()) {
                String infoStoreOVID = (String)map.get(infoStore.getObjectID());
                infoStmt.setString(1, transformTask.getObjectID());
                infoStmt.setString(2, (String)map.get(transformTask.getObjectID()));
                infoStmt.setString(3, transformTask.getName());
                infoStmt.setString(4, infoStore.getObjectID());
                infoStmt.setString(5, infoStoreOVID);
                infoStmt.setString(6, infoStore.getName());
                infoStmt.setString(7, "T");
                infoStmt.setString(8, designOVID);
                infoStmt.addBatch();
                if (++count1 != 1000) continue;
                count1 = 0;
                infoStmt.executeBatch();
            }
            RSTaskParams.export(map, connection, transformTask, transformTask.getInputParamsObject());
            RSTaskParams.export(map, connection, transformTask, transformTask.getOutputParamsObject());
            RSTransformationFlows.export(map, connection, transformTask);
            RSTransformations.export(map, connection, transformTask);
            RSNotes.export(map, connection, transformTask);
        }
        if (count > 0) {
            count = 0;
            infoStmt.executeBatch();
        }
        infoStmt.close();
        infoStmt = null;
    }
}

